/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.OrgLabor;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.base.OrgLaborServiceBaseImpl;
import com.liferay.portal.service.permission.OrganizationPermissionUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrgLaborServiceImpl
extends OrgLaborServiceBaseImpl {
    public OrgLabor addOrgLabor(long organizationId, int typeId, int sunOpen, int sunClose, int monOpen, int monClose, int tueOpen, int tueClose, int wedOpen, int wedClose, int thuOpen, int thuClose, int friOpen, int friClose, int satOpen, int satClose) throws PortalException, SystemException {
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"UPDATE");
        return this.orgLaborLocalService.addOrgLabor(organizationId, typeId, sunOpen, sunClose, monOpen, monClose, tueOpen, tueClose, wedOpen, wedClose, thuOpen, thuClose, friOpen, friClose, satOpen, satClose);
    }

    public void deleteOrgLabor(long orgLaborId) throws PortalException, SystemException {
        OrgLabor orgLabor = this.orgLaborPersistence.findByPrimaryKey(orgLaborId);
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)orgLabor.getOrganizationId(), (String)"UPDATE");
        this.orgLaborLocalService.deleteOrgLabor(orgLaborId);
    }

    public OrgLabor getOrgLabor(long orgLaborId) throws PortalException, SystemException {
        OrgLabor orgLabor = this.orgLaborPersistence.findByPrimaryKey(orgLaborId);
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)orgLabor.getOrganizationId(), (String)"VIEW");
        return orgLabor;
    }

    public List<OrgLabor> getOrgLabors(long organizationId) throws PortalException, SystemException {
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"VIEW");
        return this.orgLaborLocalService.getOrgLabors(organizationId);
    }

    public OrgLabor updateOrgLabor(long orgLaborId, int typeId, int sunOpen, int sunClose, int monOpen, int monClose, int tueOpen, int tueClose, int wedOpen, int wedClose, int thuOpen, int thuClose, int friOpen, int friClose, int satOpen, int satClose) throws PortalException, SystemException {
        OrgLabor orgLabor = this.orgLaborPersistence.findByPrimaryKey(orgLaborId);
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)orgLabor.getOrganizationId(), (String)"UPDATE");
        return this.orgLaborLocalService.updateOrgLabor(orgLaborId, typeId, sunOpen, sunClose, monOpen, monClose, tueOpen, tueClose, wedOpen, wedClose, thuOpen, thuClose, friOpen, friClose, satOpen, satClose);
    }
}

