/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.GroupServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.http.TunnelUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(GroupServiceHttp.class);

    public static Group addGroup(HttpPrincipal httpPrincipal, String name, String description, int type, String friendlyURL, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "addGroup", new Class[]{String.class, String.class, Integer.TYPE, String.class, Boolean.TYPE, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{name, description, type, friendlyURL, active, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Group addGroup(HttpPrincipal httpPrincipal, long liveGroupId, String name, String description, int type, String friendlyURL, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "addGroup", new Class[]{Long.TYPE, String.class, String.class, Integer.TYPE, String.class, Boolean.TYPE, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{liveGroupId, name, description, type, friendlyURL, active, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void addRoleGroups(HttpPrincipal httpPrincipal, long roleId, long[] groupIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "addRoleGroups", new Class[]{Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId, groupIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteGroup(HttpPrincipal httpPrincipal, long groupId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "deleteGroup", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Group getGroup(HttpPrincipal httpPrincipal, long groupId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "getGroup", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Group getGroup(HttpPrincipal httpPrincipal, long companyId, String name) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "getGroup", new Class[]{Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, name});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Group> getManageableGroups(HttpPrincipal httpPrincipal, String actionId, int max) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "getManageableGroups", new Class[]{String.class, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{actionId, max});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Group> getOrganizationsGroups(HttpPrincipal httpPrincipal, List<Organization> organizations) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "getOrganizationsGroups", new Class[]{List.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{organizations});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Group getUserGroup(HttpPrincipal httpPrincipal, long companyId, long userId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "getUserGroup", new Class[]{Long.TYPE, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, userId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Group> getUserGroupsGroups(HttpPrincipal httpPrincipal, List<UserGroup> userGroups) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "getUserGroupsGroups", new Class[]{List.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userGroups});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Group> getUserOrganizationsGroups(HttpPrincipal httpPrincipal, long userId, int start, int end) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "getUserOrganizationsGroups", new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static boolean hasUserGroup(HttpPrincipal httpPrincipal, long userId, long groupId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "hasUserGroup", new Class[]{Long.TYPE, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Group> search(HttpPrincipal httpPrincipal, long companyId, String name, String description, String[] params, int start, int end) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "search", new Class[]{Long.TYPE, String.class, String.class, String[].class, Integer.TYPE, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, name, description, params, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int searchCount(HttpPrincipal httpPrincipal, long companyId, String name, String description, String[] params) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "searchCount", new Class[]{Long.TYPE, String.class, String.class, String[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, name, description, params});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setRoleGroups(HttpPrincipal httpPrincipal, long roleId, long[] groupIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "setRoleGroups", new Class[]{Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId, groupIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetRoleGroups(HttpPrincipal httpPrincipal, long roleId, long[] groupIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "unsetRoleGroups", new Class[]{Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId, groupIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Group updateFriendlyURL(HttpPrincipal httpPrincipal, long groupId, String friendlyURL) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "updateFriendlyURL", new Class[]{Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, friendlyURL});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Group updateGroup(HttpPrincipal httpPrincipal, long groupId, String name, String description, int type, String friendlyURL, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "updateGroup", new Class[]{Long.TYPE, String.class, String.class, Integer.TYPE, String.class, Boolean.TYPE, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, name, description, type, friendlyURL, active, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Group updateGroup(HttpPrincipal httpPrincipal, long groupId, String typeSettings) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "updateGroup", new Class[]{Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, typeSettings});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Group updateWorkflow(HttpPrincipal httpPrincipal, long groupId, boolean workflowEnabled, int workflowStages, String workflowRoleNames) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(GroupServiceUtil.class.getName(), "updateWorkflow", new Class[]{Long.TYPE, Boolean.TYPE, Integer.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, workflowEnabled, workflowStages, workflowRoleNames});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

