/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.plugin;

import com.liferay.portal.kernel.plugin.License;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.TermQuery;
import com.liferay.portal.kernel.search.TermQueryFactoryUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.plugin.ModuleId;
import com.liferay.portal.plugin.PluginPackageUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletURL;

public class PluginPackageIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{PluginPackage.class.getName()};
    public static final String PORTLET_ID = "PluginPackageIndexer";

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public Summary getSummary(Document document, String snippet, PortletURL portletURL) {
        String title = document.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)document.get("content"), (int)200);
        }
        String moduleId = document.get("moduleId");
        String repositoryURL = document.get("repositoryURL");
        portletURL.setParameter("struts_action", "/admin/view");
        portletURL.setParameter("tabs2", "repositories");
        portletURL.setParameter("moduleId", moduleId);
        portletURL.setParameter("repositoryURL", repositoryURL);
        return new Summary(title, content, portletURL);
    }

    protected void doDelete(Object obj) throws Exception {
        PluginPackage pluginPackage = (PluginPackage)obj;
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, pluginPackage.getModuleId());
        SearchEngineUtil.deleteDocument((long)0L, (String)document.get("uid"));
    }

    protected Document doGetDocument(Object obj) throws Exception {
        PluginPackage pluginPackage = (PluginPackage)obj;
        String moduleId = pluginPackage.getModuleId();
        String name = pluginPackage.getName();
        String version = pluginPackage.getVersion();
        Date modifiedDate = pluginPackage.getModifiedDate();
        String author = pluginPackage.getAuthor();
        List types = pluginPackage.getTypes();
        List tags = pluginPackage.getTags();
        List licenses = pluginPackage.getLicenses();
        String shortDescription = HtmlUtil.extractText((String)pluginPackage.getShortDescription());
        String longDescription = HtmlUtil.extractText((String)pluginPackage.getLongDescription());
        String changeLog = pluginPackage.getChangeLog();
        String pageURL = pluginPackage.getPageURL();
        String repositoryURL = pluginPackage.getRepositoryURL();
        String[] statusAndInstalledVersion = PluginPackageUtil.getStatusAndInstalledVersion(pluginPackage);
        String status = statusAndInstalledVersion[0];
        String installedVersion = statusAndInstalledVersion[1];
        ModuleId moduleIdObj = ModuleId.getInstance(moduleId);
        StringBundler sb = new StringBundler(7);
        sb.append(name);
        sb.append(" ");
        sb.append(author);
        sb.append(" ");
        sb.append(shortDescription);
        sb.append(" ");
        sb.append(longDescription);
        String content = sb.toString();
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, moduleId);
        document.addModifiedDate(modifiedDate);
        document.addKeyword("portletId", PORTLET_ID);
        document.addKeyword("groupId", moduleIdObj.getGroupId());
        document.addText("title", name);
        document.addText("content", content);
        document.addKeyword("moduleId", moduleId);
        document.addKeyword("artifactId", moduleIdObj.getArtifactId());
        document.addKeyword("version", version);
        document.addText("author", author);
        document.addKeyword("type", types.toArray(new String[0]));
        document.addKeyword("tag", tags.toArray(new String[0]));
        String[] licenseNames = new String[licenses.size()];
        boolean osiLicense = false;
        int i = 0;
        while (i < licenses.size()) {
            License license = (License)licenses.get(i);
            licenseNames[i] = license.getName();
            if (license.isOsiApproved()) {
                osiLicense = true;
            }
            ++i;
        }
        document.addKeyword("license", licenseNames);
        document.addKeyword("osi-approved-license", String.valueOf(osiLicense));
        document.addText("shortDescription", shortDescription);
        document.addText("longDescription", longDescription);
        document.addText("changeLog", changeLog);
        document.addText("pageURL", pageURL);
        document.addKeyword("repositoryURL", repositoryURL);
        document.addKeyword("status", status);
        document.addKeyword("installedVersion", installedVersion);
        return document;
    }

    protected void doReindex(Object obj) throws Exception {
        PluginPackage pluginPackage = (PluginPackage)obj;
        Document document = this.getDocument(pluginPackage);
        SearchEngineUtil.updateDocument((long)0L, (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
    }

    protected void doReindex(String[] ids) throws Exception {
        SearchEngineUtil.deletePortletDocuments((long)0L, (String)PORTLET_ID);
        ArrayList<Document> documents = new ArrayList<Document>();
        for (PluginPackage pluginPackage : PluginPackageUtil.getAllAvailablePluginPackages()) {
            Document document = this.getDocument(pluginPackage);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((long)0L, documents);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void postProcessFullQuery(BooleanQuery fullQuery, SearchContext searchContext) throws Exception {
        String status;
        String license;
        String repositoryURL;
        String tag;
        String type = (String)((Object)searchContext.getAttribute("type"));
        if (Validator.isNotNull((String)type)) {
            BooleanQuery searchQuery = BooleanQueryFactoryUtil.create();
            searchQuery.addRequiredTerm("type", type);
            fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
        }
        if (Validator.isNotNull((String)(tag = (String)((Object)searchContext.getAttribute("tag"))))) {
            BooleanQuery searchQuery = BooleanQueryFactoryUtil.create();
            searchQuery.addExactTerm("tag", tag);
            fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
        }
        if (Validator.isNotNull((String)(repositoryURL = (String)((Object)searchContext.getAttribute("repositoryURL"))))) {
            BooleanQuery searchQuery = BooleanQueryFactoryUtil.create();
            TermQuery query = TermQueryFactoryUtil.create((String)"repositoryURL", (String)repositoryURL);
            searchQuery.add((Query)query, BooleanClauseOccur.SHOULD);
            fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
        }
        if (Validator.isNotNull((String)(license = (String)((Object)searchContext.getAttribute("license"))))) {
            BooleanQuery searchQuery = BooleanQueryFactoryUtil.create();
            searchQuery.addExactTerm("license", license);
            fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
        }
        if (Validator.isNotNull((String)(status = (String)((Object)searchContext.getAttribute("status")))) && !status.equals("all")) {
            BooleanQuery searchQuery = BooleanQueryFactoryUtil.create();
            if (status.equals("notInstalledOrOlderVersionInstalled")) {
                searchQuery.addExactTerm("status", "notInstalled");
                searchQuery.addExactTerm("status", "olderVersionInstalled");
            } else {
                searchQuery.addExactTerm("status", status);
            }
            fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
        }
    }
}

