/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.LayoutFriendlyURLException;
import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ColorScheme;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutType;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.impl.LayoutModelImpl;
import com.liferay.portal.model.impl.LayoutTypePortletImpl;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.ThemeLocalServiceUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.CookieKeys;
import com.liferay.portal.util.LayoutClone;
import com.liferay.portal.util.LayoutCloneFactory;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletURLImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutImpl
extends LayoutModelImpl
implements Layout {
    private static Log _log = LogFactoryUtil.getLog(LayoutImpl.class);
    private UnicodeProperties _typeSettingsProperties;

    public static int validateFriendlyURL(String friendlyURL) {
        if (friendlyURL.length() < 2) {
            return 3;
        }
        if (!friendlyURL.startsWith("/")) {
            return 1;
        }
        if (friendlyURL.endsWith("/")) {
            return 2;
        }
        if (friendlyURL.indexOf("//") != -1) {
            return 4;
        }
        char[] cArray = friendlyURL.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Validator.isChar((char)c) && !Validator.isDigit((char)c) && c != '-' && c != '%' && c != '.' && c != '+' && c != '/' && c != '*' && c != '_') {
                return 5;
            }
            ++n2;
        }
        return -1;
    }

    public static void validateFriendlyURLKeyword(String friendlyURL) throws LayoutFriendlyURLException {
        String[] keywords = PropsUtil.getArray("layout.friendly.url.keywords");
        int i = 0;
        while (i < keywords.length) {
            String keyword = keywords[i];
            if (friendlyURL.indexOf("/" + keyword + "/") != -1 || friendlyURL.endsWith("/" + keyword)) {
                LayoutFriendlyURLException lfurle = new LayoutFriendlyURLException(7);
                lfurle.setKeywordConflict(keyword);
                throw lfurle;
            }
            ++i;
        }
    }

    public List<Layout> getAllChildren() throws SystemException {
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        for (Layout layout : this.getChildren()) {
            layouts.add(layout);
            layouts.addAll(layout.getChildren());
        }
        return layouts;
    }

    public long getAncestorLayoutId() throws PortalException, SystemException {
        long layoutId = 0L;
        LayoutImpl layout = this;
        while (!layout.isRootLayout()) {
            layout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getParentLayoutId());
        }
        layoutId = layout.getLayoutId();
        return layoutId;
    }

    public long getAncestorPlid() throws PortalException, SystemException {
        long plid = 0L;
        LayoutImpl layout = this;
        while (!layout.isRootLayout()) {
            layout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getParentLayoutId());
        }
        plid = layout.getPlid();
        return plid;
    }

    public List<Layout> getAncestors() throws PortalException, SystemException {
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        LayoutImpl layout = this;
        while (!layout.isRootLayout()) {
            layout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getParentLayoutId());
            layouts.add(layout);
        }
        return layouts;
    }

    public List<Layout> getChildren() throws SystemException {
        return LayoutLocalServiceUtil.getLayouts((long)this.getGroupId(), (boolean)this.isPrivateLayout(), (long)this.getLayoutId());
    }

    public List<Layout> getChildren(PermissionChecker permissionChecker) throws PortalException, SystemException {
        List layouts = ListUtil.copy(this.getChildren());
        Iterator itr = layouts.iterator();
        while (itr.hasNext()) {
            Layout layout = (Layout)itr.next();
            if (!layout.isHidden() && LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"VIEW")) continue;
            itr.remove();
        }
        return layouts;
    }

    public ColorScheme getColorScheme() throws PortalException, SystemException {
        if (this.isInheritLookAndFeel()) {
            return this.getLayoutSet().getColorScheme();
        }
        return ThemeLocalServiceUtil.getColorScheme((long)this.getCompanyId(), (String)this.getTheme().getThemeId(), (String)this.getColorSchemeId(), (boolean)false);
    }

    public String getCssText() throws PortalException, SystemException {
        if (this.isInheritLookAndFeel()) {
            return this.getLayoutSet().getCss();
        }
        return this.getCss();
    }

    public Group getGroup() throws PortalException, SystemException {
        return GroupLocalServiceUtil.getGroup((long)this.getGroupId());
    }

    public String getHTMLTitle(Locale locale) {
        String localeLanguageId = LocaleUtil.toLanguageId((Locale)locale);
        return this.getHTMLTitle(localeLanguageId);
    }

    public String getHTMLTitle(String localeLanguageId) {
        String htmlTitle = this.getTitle(localeLanguageId);
        if (Validator.isNull((String)htmlTitle)) {
            htmlTitle = this.getName(localeLanguageId);
        }
        return htmlTitle;
    }

    public LayoutSet getLayoutSet() throws PortalException, SystemException {
        return LayoutSetLocalServiceUtil.getLayoutSet((long)this.getGroupId(), (boolean)this.isPrivateLayout());
    }

    public LayoutType getLayoutType() {
        return new LayoutTypePortletImpl(this);
    }

    public String getName(Locale locale) {
        String localeLanguageId = LocaleUtil.toLanguageId((Locale)locale);
        return this.getName(localeLanguageId);
    }

    public String getName(Locale locale, boolean useDefault) {
        String localeLanguageId = LocaleUtil.toLanguageId((Locale)locale);
        return this.getName(localeLanguageId, useDefault);
    }

    public String getName(String localeLanguageId) {
        return LocalizationUtil.getLocalization((String)this.getName(), (String)localeLanguageId);
    }

    public String getName(String localeLanguageId, boolean useDefault) {
        return LocalizationUtil.getLocalization((String)this.getName(), (String)localeLanguageId, (boolean)useDefault);
    }

    public long getParentPlid() throws PortalException, SystemException {
        if (this.getParentLayoutId() == 0L) {
            return 0L;
        }
        Layout layout = LayoutLocalServiceUtil.getLayout((long)this.getGroupId(), (boolean)this.isPrivateLayout(), (long)this.getParentLayoutId());
        return layout.getPlid();
    }

    public String getRegularURL(HttpServletRequest request) throws PortalException, SystemException {
        return this._getURL(request, false, false);
    }

    public String getResetLayoutURL(HttpServletRequest request) throws PortalException, SystemException {
        return this._getURL(request, true, true);
    }

    public String getResetMaxStateURL(HttpServletRequest request) throws PortalException, SystemException {
        return this._getURL(request, true, false);
    }

    public Group getScopeGroup() throws PortalException, SystemException {
        Group group = null;
        try {
            group = GroupLocalServiceUtil.getLayoutGroup((long)this.getCompanyId(), (long)this.getPlid());
        }
        catch (NoSuchGroupException noSuchGroupException) {}
        return group;
    }

    public String getTarget() {
        return PortalUtil.getLayoutTarget((Layout)this);
    }

    public Theme getTheme() throws PortalException, SystemException {
        if (this.isInheritLookAndFeel()) {
            return this.getLayoutSet().getTheme();
        }
        return ThemeLocalServiceUtil.getTheme((long)this.getCompanyId(), (String)this.getThemeId(), (boolean)false);
    }

    public String getTitle(Locale locale) {
        String localeLanguageId = LocaleUtil.toLanguageId((Locale)locale);
        return this.getTitle(localeLanguageId);
    }

    public String getTitle(Locale locale, boolean useDefault) {
        String localeLanguageId = LocaleUtil.toLanguageId((Locale)locale);
        return this.getTitle(localeLanguageId, useDefault);
    }

    public String getTitle(String localeLanguageId) {
        return LocalizationUtil.getLocalization((String)this.getTitle(), (String)localeLanguageId);
    }

    public String getTitle(String localeLanguageId, boolean useDefault) {
        return LocalizationUtil.getLocalization((String)this.getTitle(), (String)localeLanguageId, (boolean)useDefault);
    }

    @Override
    public String getTypeSettings() {
        if (this._typeSettingsProperties == null) {
            return super.getTypeSettings();
        }
        return this._typeSettingsProperties.toString();
    }

    public UnicodeProperties getTypeSettingsProperties() {
        if (this._typeSettingsProperties == null) {
            this._typeSettingsProperties = new UnicodeProperties(true);
            this._typeSettingsProperties.fastLoad(super.getTypeSettings());
        }
        return this._typeSettingsProperties;
    }

    public ColorScheme getWapColorScheme() throws PortalException, SystemException {
        if (this.isInheritLookAndFeel()) {
            return this.getLayoutSet().getWapColorScheme();
        }
        return ThemeLocalServiceUtil.getColorScheme((long)this.getCompanyId(), (String)this.getWapTheme().getThemeId(), (String)this.getWapColorSchemeId(), (boolean)true);
    }

    public Theme getWapTheme() throws PortalException, SystemException {
        if (this.isInheritWapLookAndFeel()) {
            return this.getLayoutSet().getWapTheme();
        }
        return ThemeLocalServiceUtil.getTheme((long)this.getCompanyId(), (String)this.getWapThemeId(), (boolean)true);
    }

    public boolean hasAncestor(long layoutId) throws PortalException, SystemException {
        long parentLayoutId = this.getParentLayoutId();
        while (this.isRootLayout()) {
            if (parentLayoutId == layoutId) {
                return true;
            }
            Layout parentLayout = LayoutLocalServiceUtil.getLayout((long)this.getGroupId(), (boolean)this.isPrivateLayout(), (long)parentLayoutId);
            parentLayoutId = parentLayout.getParentLayoutId();
        }
        return false;
    }

    public boolean hasChildren() throws SystemException {
        return LayoutLocalServiceUtil.hasLayouts((long)this.getGroupId(), (boolean)this.isPrivateLayout(), (long)this.getLayoutId());
    }

    public boolean hasScopeGroup() throws PortalException, SystemException {
        Group group = this.getScopeGroup();
        return group != null;
    }

    public boolean isChildSelected(boolean selectable, Layout layout) throws PortalException, SystemException {
        if (selectable) {
            long plid = this.getPlid();
            List ancestors = layout.getAncestors();
            for (Layout curLayout : ancestors) {
                if (plid != curLayout.getPlid()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFirstChild() {
        return this.getPriority() == 0;
    }

    public boolean isFirstParent() {
        return this.isFirstChild() && this.isRootLayout();
    }

    public boolean isInheritLookAndFeel() {
        return Validator.isNull((String)this.getThemeId()) || Validator.isNull((String)this.getColorSchemeId());
    }

    public boolean isInheritWapLookAndFeel() {
        return Validator.isNull((String)this.getWapThemeId()) || Validator.isNull((String)this.getWapColorSchemeId());
    }

    public boolean isPublicLayout() {
        return !this.isPrivateLayout();
    }

    public boolean isRootLayout() {
        return this.getParentLayoutId() == 0L;
    }

    public boolean isSelected(boolean selectable, Layout layout, long ancestorPlid) {
        long plid;
        return selectable && ((plid = this.getPlid()) == layout.getPlid() || plid == ancestorPlid);
    }

    public boolean isTypeArticle() {
        return this.getType().equals("article");
    }

    public boolean isTypeControlPanel() {
        return this.getType().equals("control_panel");
    }

    public boolean isTypeEmbedded() {
        return this.getType().equals("embedded");
    }

    public boolean isTypeLinkToLayout() {
        return this.getType().equals("link_to_layout");
    }

    public boolean isTypePanel() {
        return this.getType().equals("panel");
    }

    public boolean isTypePortlet() {
        return this.getType().equals("portlet");
    }

    public boolean isTypeURL() {
        return this.getType().equals("url");
    }

    public void setName(String name, Locale locale) {
        String localeLanguageId = LocaleUtil.toLanguageId((Locale)locale);
        if (Validator.isNotNull((String)name)) {
            this.setName(LocalizationUtil.updateLocalization((String)this.getName(), (String)"name", (String)name, (String)localeLanguageId));
        } else {
            this.setName(LocalizationUtil.removeLocalization((String)this.getName(), (String)"name", (String)localeLanguageId));
        }
    }

    public void setTitle(String title, Locale locale) {
        String localeLanguageId = LocaleUtil.toLanguageId((Locale)locale);
        if (Validator.isNotNull((String)title)) {
            this.setTitle(LocalizationUtil.updateLocalization((String)this.getTitle(), (String)"title", (String)title, (String)localeLanguageId));
        } else {
            this.setTitle(LocalizationUtil.removeLocalization((String)this.getTitle(), (String)"title", (String)localeLanguageId));
        }
    }

    @Override
    public void setTypeSettings(String typeSettings) {
        this._typeSettingsProperties = null;
        super.setTypeSettings(typeSettings);
    }

    public void setTypeSettingsProperties(UnicodeProperties typeSettingsProperties) {
        this._typeSettingsProperties = typeSettingsProperties;
        super.setTypeSettings(this._typeSettingsProperties.toString());
    }

    private LayoutTypePortlet _getLayoutTypePortletClone(HttpServletRequest request) throws IOException {
        String typeSettings;
        LayoutTypePortlet layoutTypePortlet = null;
        LayoutClone layoutClone = LayoutCloneFactory.getInstance();
        if (layoutClone != null && (typeSettings = layoutClone.get(request, this.getPlid())) != null) {
            UnicodeProperties props = new UnicodeProperties(true);
            props.load(typeSettings);
            String stateMax = props.getProperty("state-max");
            String stateMin = props.getProperty("state-min");
            Layout layout = (Layout)this.clone();
            layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            layoutTypePortlet.setStateMax(stateMax);
            layoutTypePortlet.setStateMin(stateMin);
        }
        if (layoutTypePortlet == null) {
            layoutTypePortlet = (LayoutTypePortlet)this.getLayoutType();
        }
        return layoutTypePortlet;
    }

    private String _getURL(HttpServletRequest request, boolean resetMaxState, boolean resetRenderParameters) throws PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        if (resetMaxState) {
            Layout layout = themeDisplay.getLayout();
            LayoutTypePortlet layoutTypePortlet = null;
            if (layout.equals((Object)this)) {
                layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
            } else {
                try {
                    layoutTypePortlet = this._getLayoutTypePortletClone(request);
                }
                catch (IOException ioe) {
                    _log.error((Object)"Unable to clone layout settings", (Throwable)ioe);
                    layoutTypePortlet = (LayoutTypePortlet)this.getLayoutType();
                }
            }
            if (layoutTypePortlet.hasStateMax()) {
                String portletId = StringUtil.split((String)layoutTypePortlet.getStateMax())[0];
                PortletURLImpl portletURLImpl = new PortletURLImpl(request, portletId, this.getPlid(), "ACTION_PHASE");
                try {
                    portletURLImpl.setWindowState(WindowState.NORMAL);
                    portletURLImpl.setPortletMode(PortletMode.VIEW);
                }
                catch (PortletException pe) {
                    throw new SystemException((Throwable)pe);
                }
                portletURLImpl.setAnchor(false);
                if (PropsValues.LAYOUT_DEFAULT_P_L_RESET && !resetRenderParameters) {
                    portletURLImpl.setParameter("p_l_reset", "0");
                } else if (!PropsValues.LAYOUT_DEFAULT_P_L_RESET && resetRenderParameters) {
                    portletURLImpl.setParameter("p_l_reset", "1");
                }
                return portletURLImpl.toString();
            }
        }
        String url = PortalUtil.getLayoutURL((Layout)this, (ThemeDisplay)themeDisplay);
        if (!CookieKeys.hasSessionId(request)) {
            url = PortalUtil.getURLWithSessionId((String)url, (String)request.getSession().getId());
        }
        if (!resetMaxState) {
            return url;
        }
        if (PropsValues.LAYOUT_DEFAULT_P_L_RESET && !resetRenderParameters) {
            url = HttpUtil.addParameter((String)url, (String)"p_l_reset", (int)0);
        } else if (!PropsValues.LAYOUT_DEFAULT_P_L_RESET && resetRenderParameters) {
            url = HttpUtil.addParameter((String)url, (String)"p_l_reset", (int)1);
        }
        return url;
    }
}

