/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.LayoutImportException;
import com.liferay.portal.NoSuchPortletPreferencesException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactoryUtil;
import com.liferay.portal.lar.LayoutCache;
import com.liferay.portal.lar.PermissionExporter;
import com.liferay.portal.lar.PortletDataContextImpl;
import com.liferay.portal.lar.PortletDataContextListenerImpl;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.PortletItem;
import com.liferay.portal.model.User;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PortletItemLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetCategoryProperty;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.AssetCategoryPropertyLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetCategoryServiceUtil;
import com.liferay.portlet.asset.service.persistence.AssetCategoryUtil;
import com.liferay.portlet.asset.service.persistence.AssetVocabularyUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.ratings.model.RatingsEntry;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.time.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletExporter {
    private static Log _log = LogFactoryUtil.getLog(PortletExporter.class);
    private PermissionExporter _permissionExporter = new PermissionExporter();

    public byte[] exportPortletInfo(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        File file = this.exportPortletInfoAsFile(plid, groupId, portletId, parameterMap, startDate, endDate);
        try {
            byte[] byArray = FileUtil.getBytes((File)file);
            return byArray;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        finally {
            file.delete();
        }
    }

    public File exportPortletInfoAsFile(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        Group scopeGroup;
        boolean exportCategories = MapUtil.getBoolean(parameterMap, (String)"CATEGORIES");
        boolean exportPermissions = MapUtil.getBoolean(parameterMap, (String)"PERMISSIONS");
        boolean exportPortletArchivedSetups = MapUtil.getBoolean(parameterMap, (String)"PORTLET_ARCHIVED_SETUPS");
        boolean exportPortletData = MapUtil.getBoolean(parameterMap, (String)("PORTLET_DATA_" + PortletConstants.getRootPortletId((String)portletId)));
        boolean exportPortletDataAll = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA_ALL");
        boolean exportPortletSetup = MapUtil.getBoolean(parameterMap, (String)"PORTLET_SETUP");
        boolean exportPortletUserPreferences = MapUtil.getBoolean(parameterMap, (String)"PORTLET_USER_PREFERENCES");
        boolean exportUserPermissions = MapUtil.getBoolean(parameterMap, (String)"USER_PERMISSIONS");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export categories " + exportCategories));
            _log.debug((Object)("Export permissions " + exportPermissions));
            _log.debug((Object)("Export portlet archived setups " + exportPortletArchivedSetups));
            _log.debug((Object)("Export portlet data " + exportPortletData));
            _log.debug((Object)("Export all portlet data " + exportPortletDataAll));
            _log.debug((Object)("Export portlet setup " + exportPortletSetup));
            _log.debug((Object)("Export portlet user preferences " + exportPortletUserPreferences));
            _log.debug((Object)("Export user permissions " + exportUserPermissions));
        }
        if (exportPortletDataAll) {
            exportPortletData = true;
        }
        long lastPublishDate = System.currentTimeMillis();
        if (endDate != null) {
            lastPublishDate = endDate.getTime();
        }
        StopWatch stopWatch = null;
        if (_log.isInfoEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        LayoutCache layoutCache = new LayoutCache();
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        if (!(layout.isTypeControlPanel() || layout.isTypePanel() || layout.isTypePortlet())) {
            throw new LayoutImportException("Layout type " + layout.getType() + " is not valid");
        }
        long companyId = layout.getCompanyId();
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        ZipWriter zipWriter = ZipWriterFactoryUtil.getZipWriter();
        long scopeGroupId = groupId;
        PortletPreferences jxPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
        String scopeLayoutUuid = GetterUtil.getString((String)jxPreferences.getValue("lfr-scope-layout-uuid", null));
        if (Validator.isNotNull((String)scopeLayoutUuid) && (scopeGroup = layout.getScopeGroup()) != null) {
            scopeGroupId = scopeGroup.getGroupId();
        }
        PortletDataContextImpl context = new PortletDataContextImpl(companyId, scopeGroupId, parameterMap, new HashSet<String>(), startDate, endDate, zipWriter);
        context.setPortetDataContextListener(new PortletDataContextListenerImpl(context));
        context.setPlid(plid);
        context.setOldPlid(plid);
        context.setScopeLayoutUuid(scopeLayoutUuid);
        Document doc = SAXReaderUtil.createDocument();
        Element root = doc.addElement("root");
        Element header = root.addElement("header");
        header.addAttribute("build-number", String.valueOf(ReleaseInfo.getBuildNumber()));
        header.addAttribute("export-date", Time.getRFC822());
        if (context.hasDateRange()) {
            header.addAttribute("start-date", String.valueOf(context.getStartDate()));
            header.addAttribute("end-date", String.valueOf(context.getEndDate()));
        }
        header.addAttribute("type", "portlet");
        header.addAttribute("group-id", String.valueOf(scopeGroupId));
        header.addAttribute("private-layout", String.valueOf(layout.isPrivateLayout()));
        header.addAttribute("root-portlet-id", PortletConstants.getRootPortletId((String)portletId));
        this.exportPortlet(context, layoutCache, portletId, layout, root, defaultUserId, exportPermissions, exportPortletArchivedSetups, exportPortletData, exportPortletSetup, exportPortletUserPreferences, exportUserPermissions);
        if (exportCategories) {
            this.exportCategories(context);
        }
        this.exportComments(context, root);
        this.exportLocks(context, root);
        if (exportPermissions) {
            this._permissionExporter.exportPortletDataPermissions(context);
        }
        this.exportRatings(context, root);
        this.exportTags(context, root);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Exporting portlet took " + stopWatch.getTime() + " ms"));
        }
        try {
            context.addZipEntry("/manifest.xml", doc.formattedString());
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        try {
            File file = zipWriter.getFile();
            return file;
        }
        finally {
            this.updateLastPublishDate(layout, portletId, lastPublishDate);
        }
    }

    protected void exportCategories(PortletDataContext context) throws SystemException {
        try {
            Document doc = SAXReaderUtil.createDocument();
            Element root = doc.addElement("categories-hierarchy");
            this.exportCategories(context, root);
            context.addZipEntry(String.valueOf(context.getRootPath()) + "/categories-hierarchy.xml", doc.formattedString());
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected void exportCategories(PortletDataContext context, Element root) throws SystemException {
        try {
            Element vocabulariesEl = root.element("vocabularies");
            if (vocabulariesEl == null) {
                vocabulariesEl = root.addElement("vocabularies");
            }
            Element assetsEl = root.addElement("assets");
            Element categoriesEl = root.addElement("categories");
            Map assetCategoryUuidsMap = context.getAssetCategoryUuidsMap();
            for (Map.Entry entry : assetCategoryUuidsMap.entrySet()) {
                String[] categoryEntry = ((String)entry.getKey()).split("#");
                String className = categoryEntry[0];
                long classPK = GetterUtil.getLong((String)categoryEntry[1]);
                Element asset = assetsEl.addElement("asset");
                asset.addAttribute("class-name", className);
                asset.addAttribute("class-pk", String.valueOf(classPK));
                asset.addAttribute("category-uuids", StringUtil.merge((Object[])((Object[])entry.getValue())));
                List assetCategories = AssetCategoryServiceUtil.getCategories((String)className, (long)classPK);
                for (AssetCategory assestCategory : assetCategories) {
                    this.exportCategory(context, vocabulariesEl, categoriesEl, assestCategory);
                }
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected void exportCategory(PortletDataContext context, Element vocabulariesEl, Element categoryEls, long assetCategoryId) throws Exception {
        AssetCategory assetCategory = AssetCategoryUtil.fetchByPrimaryKey((long)assetCategoryId);
        if (assetCategory != null) {
            this.exportCategory(context, vocabulariesEl, categoryEls, assetCategory);
        }
    }

    protected void exportCategory(PortletDataContext context, Element vocabulariesEl, Element categoriesEl, AssetCategory assetCategory) throws Exception {
        String path;
        this.exportVocabulary(context, vocabulariesEl, assetCategory.getVocabularyId());
        if (assetCategory.getParentCategoryId() != 0L) {
            this.exportCategory(context, vocabulariesEl, categoriesEl, assetCategory.getParentCategoryId());
        }
        if (!context.isPathNotProcessed(path = this.getCategoryPath(context, assetCategory.getCategoryId()))) {
            return;
        }
        Element categoryEl = categoriesEl.addElement("category");
        categoryEl.addAttribute("path", path);
        assetCategory.setUserUuid(assetCategory.getUserUuid());
        context.addZipEntry(path, (Object)assetCategory);
        List assetCategoryProperties = AssetCategoryPropertyLocalServiceUtil.getCategoryProperties((long)assetCategory.getCategoryId());
        for (AssetCategoryProperty assetCategoryProperty : assetCategoryProperties) {
            Element propertyEl = categoryEl.addElement("property");
            propertyEl.addAttribute("userUuid", assetCategoryProperty.getUserUuid());
            propertyEl.addAttribute("key", assetCategoryProperty.getKey());
            propertyEl.addAttribute("value", assetCategoryProperty.getValue());
        }
        context.addPermissions(AssetCategory.class, assetCategory.getCategoryId());
    }

    protected void exportComments(PortletDataContext context, Element parentEl) throws SystemException {
        try {
            Document doc = SAXReaderUtil.createDocument();
            Element root = doc.addElement("comments");
            Map commentsMap = context.getComments();
            for (Map.Entry entry : commentsMap.entrySet()) {
                String[] comment = ((String)entry.getKey()).split("#");
                String path = this.getCommentsPath(context, comment[0], comment[1]);
                Element asset = root.addElement("asset");
                asset.addAttribute("path", path);
                asset.addAttribute("class-name", comment[0]);
                asset.addAttribute("class-pk", comment[1]);
                List messages = (List)entry.getValue();
                for (MBMessage message : messages) {
                    path = this.getCommentsPath(context, comment[0], comment[1], message);
                    if (!context.isPathNotProcessed(path)) continue;
                    context.addZipEntry(path, (Object)message);
                }
            }
            context.addZipEntry(String.valueOf(context.getRootPath()) + "/comments.xml", doc.formattedString());
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    protected void exportLocks(PortletDataContext context, Element parentEl) throws SystemException {
        try {
            Document doc = SAXReaderUtil.createDocument();
            Element root = doc.addElement("locks");
            Map locksMap = context.getLocks();
            for (Map.Entry entry : locksMap.entrySet()) {
                Lock lock = (Lock)entry.getValue();
                String entryKey = (String)entry.getKey();
                int index = entryKey.indexOf(35);
                String className = entryKey.substring(0, index);
                String key = entryKey.substring(index + 1);
                String path = this.getLocksPath(context, className, key, lock);
                Element asset = root.addElement("asset");
                asset.addAttribute("class-name", className);
                asset.addAttribute("key", key);
                asset.addAttribute("path", path);
                if (!context.isPathNotProcessed(path)) continue;
                context.addZipEntry(path, (Object)lock);
            }
            context.addZipEntry(String.valueOf(context.getRootPath()) + "/locks.xml", doc.formattedString());
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    protected void exportPortlet(PortletDataContext context, LayoutCache layoutCache, String portletId, Layout layout, Element parentEl, long defaultUserId, boolean exportPermissions, boolean exportPortletArchivedSetups, boolean exportPortletData, boolean exportPortletSetup, boolean exportPortletUserPreferences, boolean exportUserPermissions) throws PortalException, SystemException {
        long companyId = context.getCompanyId();
        long groupId = context.getGroupId();
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)context.getCompanyId(), (String)portletId);
        if (portlet == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not export portlet " + portletId + " because the portlet does not exist"));
            }
            return;
        }
        if (!portlet.isInstanceable() && !portlet.isPreferencesUniquePerLayout() && context.hasNotUniquePerLayout(portletId)) {
            return;
        }
        Document doc = SAXReaderUtil.createDocument();
        Element portletEl = doc.addElement("portlet");
        portletEl.addAttribute("portlet-id", portletId);
        portletEl.addAttribute("root-portlet-id", PortletConstants.getRootPortletId((String)portletId));
        portletEl.addAttribute("old-plid", String.valueOf(layout.getPlid()));
        portletEl.addAttribute("scope-layout-uuid", context.getScopeLayoutUuid());
        PortletPreferences jxPreferences = PortletPreferencesFactoryUtil.getPortletSetup((Layout)layout, (String)portletId, (String)"");
        if (exportPortletData) {
            if (!portlet.isPreferencesUniquePerLayout()) {
                String dataKey = String.valueOf(portletId) + "@" + context.getScopeLayoutUuid();
                if (!context.hasNotUniquePerLayout(dataKey)) {
                    context.putNotUniquePerLayout(dataKey);
                    this.exportPortletData(context, portlet, layout, jxPreferences, portletEl);
                }
            } else {
                this.exportPortletData(context, portlet, layout, jxPreferences, portletEl);
            }
        }
        if (exportPortletSetup) {
            this.exportPortletPreferences(context, 0L, 3, false, layout, portletId, portletEl);
            this.exportPortletPreferences(context, groupId, 2, false, layout, portletId, portletEl);
            this.exportPortletPreferences(context, companyId, 1, false, layout, portletId, portletEl);
        }
        if (exportPortletUserPreferences) {
            this.exportPortletPreferences(context, defaultUserId, 4, true, layout, portletId, portletEl);
            try {
                com.liferay.portal.model.PortletPreferences groupPortletPreferences = PortletPreferencesLocalServiceUtil.getPortletPreferences((long)groupId, (int)2, (long)0L, (String)portletId);
                this.exportPortletPreference(context, groupId, 2, false, groupPortletPreferences, portletId, 0L, portletEl);
            }
            catch (NoSuchPortletPreferencesException noSuchPortletPreferencesException) {}
        }
        if (exportPortletArchivedSetups) {
            String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
            List portletItems = PortletItemLocalServiceUtil.getPortletItems((long)groupId, (String)rootPortletId, (String)com.liferay.portal.model.PortletPreferences.class.getName());
            for (PortletItem portletItem : portletItems) {
                long ownerId = portletItem.getPortletItemId();
                int ownerType = 5;
                this.exportPortletPreferences(context, ownerId, ownerType, false, null, portletItem.getPortletId(), portletEl);
            }
        }
        if (exportPermissions) {
            this._permissionExporter.exportPortletPermissions(context, layoutCache, portletId, layout, portletEl);
        }
        StringBundler sb = new StringBundler(4);
        sb.append(context.getPortletPath(portletId));
        sb.append("/");
        sb.append(layout.getPlid());
        sb.append("/portlet.xml");
        String path = sb.toString();
        Element el = parentEl.addElement("portlet");
        el.addAttribute("portlet-id", portletId);
        el.addAttribute("layout-id", String.valueOf(layout.getLayoutId()));
        el.addAttribute("path", path);
        if (context.isPathNotProcessed(path)) {
            block17: {
                try {
                    context.addZipEntry(path, doc.formattedString());
                }
                catch (IOException ioe) {
                    if (!_log.isWarnEnabled()) break block17;
                    _log.warn((Object)ioe.getMessage());
                }
            }
            context.addPrimaryKey(String.class, path);
        }
    }

    protected void exportPortletData(PortletDataContext context, Portlet portlet, Layout layout, PortletPreferences jxPreferences, Element parentEl) throws PortalException, SystemException {
        boolean staged;
        PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
        if (portletDataHandler == null) {
            return;
        }
        String portletId = portlet.getPortletId();
        Group liveGroup = layout.getGroup();
        if (liveGroup.isStagingGroup()) {
            liveGroup = liveGroup.getLiveGroup();
        }
        if (!(staged = liveGroup.isStagedPortlet(portlet.getRootPortletId()))) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not exporting data for " + portletId + " because it is configured not to be staged"));
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Exporting data for " + portletId));
        }
        StringBundler sb = new StringBundler(4);
        sb.append(context.getPortletPath(portletId));
        sb.append("/");
        if (portlet.isPreferencesUniquePerLayout()) {
            sb.append(layout.getPlid());
        } else {
            sb.append(context.getScopeGroupId());
        }
        sb.append("/portlet-data.xml");
        String path = sb.toString();
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        String data = null;
        long groupId = context.getGroupId();
        context.setGroupId(context.getScopeGroupId());
        try {
            try {
                data = portletDataHandler.exportData(context, portletId, jxPreferences);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }
        finally {
            context.setGroupId(groupId);
        }
        if (Validator.isNull((String)data)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not exporting data for " + portletId + " because null data was returned"));
            }
            return;
        }
        Element portletDataEl = parentEl.addElement("portlet-data");
        portletDataEl.addAttribute("path", path);
        context.addZipEntry(path, data);
    }

    protected void exportPortletPreference(PortletDataContext context, long ownerId, int ownerType, boolean defaultUser, com.liferay.portal.model.PortletPreferences portletPreferences, String portletId, long plid, Element parentEl) throws SystemException {
        try {
            Document preferencesDoc = SAXReaderUtil.read((String)portletPreferences.getPreferences());
            Element root = preferencesDoc.getRootElement();
            root.addAttribute("owner-id", String.valueOf(ownerId));
            root.addAttribute("owner-type", String.valueOf(ownerType));
            root.addAttribute("default-user", String.valueOf(defaultUser));
            root.addAttribute("plid", String.valueOf(plid));
            root.addAttribute("portlet-id", portletId);
            if (ownerType == 5) {
                PortletItem portletItem = PortletItemLocalServiceUtil.getPortletItem((long)ownerId);
                User user = UserLocalServiceUtil.getUserById((long)portletItem.getUserId());
                root.addAttribute("archive-user-uuid", user.getUuid());
                root.addAttribute("archive-name", portletItem.getName());
            }
            List nodes = preferencesDoc.selectNodes("/portlet-preferences/preference[name/text() = 'last-publish-date']");
            for (Node node : nodes) {
                preferencesDoc.remove(node);
            }
            String path = this.getPortletPreferencesPath(context, portletId, ownerId, ownerType, plid);
            parentEl.addElement("portlet-preferences").addAttribute("path", path);
            if (context.isPathNotProcessed(path)) {
                context.addZipEntry(path, preferencesDoc.formattedString());
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected void exportPortletPreferences(PortletDataContext context, long ownerId, int ownerType, boolean defaultUser, Layout layout, String portletId, Element parentEl) throws PortalException, SystemException {
        com.liferay.portal.model.PortletPreferences portletPreferences = null;
        long plid = 0L;
        if (layout != null) {
            plid = layout.getPlid();
        }
        if (ownerType == 1 || ownerType == 2 || ownerType == 5) {
            plid = 0L;
        }
        try {
            portletPreferences = PortletPreferencesLocalServiceUtil.getPortletPreferences((long)ownerId, (int)ownerType, (long)plid, (String)portletId);
            LayoutTypePortlet layoutTypePortlet = null;
            if (layout != null) {
                layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            }
            if (layoutTypePortlet == null || layoutTypePortlet.hasPortletId(portletId)) {
                this.exportPortletPreference(context, ownerId, ownerType, defaultUser, portletPreferences, portletId, plid, parentEl);
            }
        }
        catch (NoSuchPortletPreferencesException noSuchPortletPreferencesException) {}
    }

    protected void exportRatings(PortletDataContext context, Element parentEl) throws SystemException {
        try {
            Document doc = SAXReaderUtil.createDocument();
            Element root = doc.addElement("ratings");
            Map ratingsEntriesMap = context.getRatingsEntries();
            for (Map.Entry entry : ratingsEntriesMap.entrySet()) {
                String[] ratingsEntry = ((String)entry.getKey()).split("#");
                String ratingPath = this.getRatingsPath(context, ratingsEntry[0], ratingsEntry[1]);
                Element asset = root.addElement("asset");
                asset.addAttribute("path", ratingPath);
                asset.addAttribute("class-name", ratingsEntry[0]);
                asset.addAttribute("class-pk", ratingsEntry[1]);
                List ratingsEntries = (List)entry.getValue();
                for (RatingsEntry rating : ratingsEntries) {
                    ratingPath = this.getRatingsPath(context, ratingsEntry[0], ratingsEntry[1], rating);
                    context.addZipEntry(ratingPath, (Object)rating);
                }
            }
            context.addZipEntry(String.valueOf(context.getRootPath()) + "/ratings.xml", doc.formattedString());
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected void exportTags(PortletDataContext context, Element parentEl) throws SystemException {
        try {
            Document doc = SAXReaderUtil.createDocument();
            Element root = doc.addElement("tags");
            Map assetTagNamesMap = context.getAssetTagNamesMap();
            for (Map.Entry entry : assetTagNamesMap.entrySet()) {
                String[] tagsEntry = ((String)entry.getKey()).split("#");
                Element asset = root.addElement("asset");
                asset.addAttribute("class-name", tagsEntry[0]);
                asset.addAttribute("class-pk", tagsEntry[1]);
                asset.addAttribute("tags", StringUtil.merge((Object[])((Object[])entry.getValue())));
            }
            context.addZipEntry(String.valueOf(context.getRootPath()) + "/tags.xml", doc.formattedString());
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected void exportVocabulary(PortletDataContext context, Element vocabulariesEl, long assetVocabularyId) throws Exception {
        AssetVocabulary assetVocabulary = AssetVocabularyUtil.findByPrimaryKey((long)assetVocabularyId);
        this.exportVocabulary(context, vocabulariesEl, assetVocabulary);
    }

    protected void exportVocabulary(PortletDataContext context, Element vocabulariesEl, AssetVocabulary assetVocabulary) throws Exception {
        String path = this.getVocabulariesPath(context, assetVocabulary.getVocabularyId());
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        Element vocabularyEl = vocabulariesEl.addElement("vocabulary");
        vocabularyEl.addAttribute("path", path);
        assetVocabulary.setUserUuid(assetVocabulary.getUserUuid());
        context.addZipEntry(path, (Object)assetVocabulary);
        context.addPermissions(AssetVocabulary.class, assetVocabulary.getVocabularyId());
    }

    protected String getCategoryPath(PortletDataContext context, long assetCategoryId) {
        StringBundler sb = new StringBundler(6);
        sb.append(context.getRootPath());
        sb.append("/categories/");
        sb.append(assetCategoryId);
        sb.append(".xml");
        return sb.toString();
    }

    protected String getCommentsPath(PortletDataContext context, String className, String classPK) {
        StringBundler sb = new StringBundler(6);
        sb.append(context.getRootPath());
        sb.append("/comments/");
        sb.append(PortalUtil.getClassNameId((String)className));
        sb.append('/');
        sb.append(classPK);
        sb.append('/');
        return sb.toString();
    }

    protected String getCommentsPath(PortletDataContext context, String className, String classPK, MBMessage message) {
        StringBundler sb = new StringBundler(8);
        sb.append(context.getRootPath());
        sb.append("/comments/");
        sb.append(PortalUtil.getClassNameId((String)className));
        sb.append('/');
        sb.append(classPK);
        sb.append('/');
        sb.append(message.getMessageId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getLocksPath(PortletDataContext context, String className, String key, Lock lock) {
        StringBundler sb = new StringBundler(8);
        sb.append(context.getRootPath());
        sb.append("/locks/");
        sb.append(PortalUtil.getClassNameId((String)className));
        sb.append('/');
        sb.append(key);
        sb.append('/');
        sb.append(lock.getLockId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getPortletDataPath(PortletDataContext context, String portletId) {
        return String.valueOf(context.getPortletPath(portletId)) + "/portlet-data.xml";
    }

    protected String getPortletPreferencesPath(PortletDataContext context, String portletId, long ownerId, int ownerType, long plid) {
        StringBundler sb = new StringBundler(8);
        sb.append(context.getPortletPath(portletId));
        sb.append("/preferences/");
        if (ownerType == 1) {
            sb.append("company/");
        } else if (ownerType == 2) {
            sb.append("group/");
        } else if (ownerType == 3) {
            sb.append("layout/");
        } else if (ownerType == 4) {
            sb.append("user/");
        } else if (ownerType == 5) {
            sb.append("archived/");
        }
        sb.append(ownerId);
        sb.append('/');
        sb.append(plid);
        sb.append('/');
        sb.append("portlet-preferences.xml");
        return sb.toString();
    }

    protected String getRatingsPath(PortletDataContext context, String className, String classPK) {
        StringBundler sb = new StringBundler(6);
        sb.append(context.getRootPath());
        sb.append("/ratings/");
        sb.append(PortalUtil.getClassNameId((String)className));
        sb.append('/');
        sb.append(classPK);
        sb.append('/');
        return sb.toString();
    }

    protected String getRatingsPath(PortletDataContext context, String className, String classPK, RatingsEntry ratingsEntry) {
        StringBundler sb = new StringBundler(8);
        sb.append(context.getRootPath());
        sb.append("/ratings/");
        sb.append(PortalUtil.getClassNameId((String)className));
        sb.append('/');
        sb.append(classPK);
        sb.append('/');
        sb.append(ratingsEntry.getEntryId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getVocabulariesPath(PortletDataContext context, long assetVocabularyId) {
        StringBundler sb = new StringBundler(8);
        sb.append(context.getRootPath());
        sb.append("/vocabularies/");
        sb.append(assetVocabularyId);
        sb.append(".xml");
        return sb.toString();
    }

    protected void updateLastPublishDate(Layout layout, String portletId, long lastPublishDate) throws Exception {
        PortletPreferences jxPreferences = PortletPreferencesFactoryUtil.getPortletSetup((Layout)layout, (String)portletId, (String)"");
        jxPreferences.setValue("last-publish-date", String.valueOf(lastPublishDate));
        jxPreferences.store();
    }
}

