/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.common;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLTransformer {
    private static final String _LOWER_CLOSE = ")";
    private static final String _LOWER_OPEN = "lower(";
    private static Log _log = LogFactoryUtil.getLog(SQLTransformer.class);
    private static SQLTransformer _instance = new SQLTransformer();
    private static Pattern _castTextPattern = Pattern.compile("CAST_TEXT\\((.+?)\\)", 2);
    private static Pattern _integerDivisionPattern = Pattern.compile("INTEGER_DIV\\((.+?),(.+?)\\)", 2);
    private static Pattern _modPattern = Pattern.compile("MOD\\((.+?),(.+?)\\)", 2);
    private static Pattern _negativeComparisonPattern = Pattern.compile("(!= )?(-([0-9]+)?)", 2);
    private static Pattern _unionAllPattern = Pattern.compile("SELECT \\* FROM(.*)TEMP_TABLE(.*)", 2);
    private boolean _vendorDB2;
    private boolean _vendorDerby;
    private boolean _vendorMySQL;
    private boolean _vendorOracle;
    private boolean _vendorPostgreSQL;
    private boolean _vendorSQLServer;
    private boolean _vendorSybase;

    public static String transform(String sql) {
        return _instance._transform(sql);
    }

    private SQLTransformer() {
        DB db = DBFactoryUtil.getDB();
        String dbType = db.getType();
        if (dbType.equals("db2")) {
            this._vendorDB2 = true;
        } else if (dbType.equals("derby")) {
            this._vendorDerby = true;
        } else if (dbType.equals("mysql")) {
            this._vendorMySQL = true;
        } else if (db.getType().equals("oracle")) {
            this._vendorOracle = true;
        } else if (dbType.equals("postgresql")) {
            this._vendorPostgreSQL = true;
        } else if (dbType.equals("sqlserver")) {
            this._vendorSQLServer = true;
        } else if (dbType.equals("sybase")) {
            this._vendorSybase = true;
        }
    }

    private String _removeLower(String sql) {
        StringBuilder sb;
        block3: {
            int x = sql.indexOf(_LOWER_OPEN);
            if (x == -1) {
                return sql;
            }
            sb = new StringBuilder(sql.length());
            int y = 0;
            do {
                sb.append(sql.substring(y, x));
                y = sql.indexOf(_LOWER_CLOSE, x);
                if (y == -1) {
                    sb.append(sql.substring(x));
                    break block3;
                }
                sb.append(sql.substring(x + _LOWER_OPEN.length(), y));
            } while ((x = sql.indexOf(_LOWER_OPEN, ++y)) != -1);
            sb.append(sql.substring(y));
        }
        sql = sb.toString();
        return sql;
    }

    private String _replaceCastText(String sql) {
        Matcher matcher = _castTextPattern.matcher(sql);
        if (this._vendorDB2) {
            return matcher.replaceAll("CAST($1 AS VARCHAR(500))");
        }
        if (this._vendorDerby) {
            return matcher.replaceAll("CAST($1 AS CHAR(254))");
        }
        if (this._vendorPostgreSQL) {
            return matcher.replaceAll("CAST($1 AS TEXT)");
        }
        if (this._vendorSQLServer || this._vendorSybase) {
            return matcher.replaceAll("CAST($1 AS NVARCHAR)");
        }
        return matcher.replaceAll("$1");
    }

    private String _replaceIntegerDivision(String sql) {
        Matcher matcher = _integerDivisionPattern.matcher(sql);
        if (this._vendorMySQL) {
            return matcher.replaceAll("$1 DIV $2");
        }
        if (this._vendorOracle) {
            return matcher.replaceAll("TRUNC($1 / $2)");
        }
        return matcher.replaceAll("$1 / $2");
    }

    private String _replaceMod(String sql) {
        Matcher matcher = _modPattern.matcher(sql);
        return matcher.replaceAll("$1 % $2");
    }

    private String _replaceNegativeComparison(String sql) {
        Matcher matcher = _negativeComparisonPattern.matcher(sql);
        return matcher.replaceAll("$1 ($2)");
    }

    private String _replaceUnion(String sql) {
        Matcher matcher = _unionAllPattern.matcher(sql);
        return matcher.replaceAll("$1 $2");
    }

    private String _transform(String sql) {
        if (sql == null) {
            return sql;
        }
        String newSQL = sql;
        newSQL = this._replaceCastText(newSQL);
        newSQL = this._replaceIntegerDivision(newSQL);
        if (this._vendorDerby) {
            newSQL = this._replaceUnion(newSQL);
        } else if (this._vendorMySQL) {
            DB db = DBFactoryUtil.getDB();
            if (!db.isSupportsStringCaseSensitiveQuery()) {
                newSQL = this._removeLower(newSQL);
            }
        } else if (this._vendorPostgreSQL) {
            newSQL = this._replaceNegativeComparison(newSQL);
        } else if (this._vendorSQLServer || this._vendorSybase) {
            newSQL = this._replaceMod(newSQL);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Original SQL " + sql));
            _log.debug((Object)("Modified SQL " + newSQL));
        }
        return newSQL;
    }
}

