/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.memcached;

import com.liferay.portal.kernel.cache.BasePortalCache;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.MemcachedClientIF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemcachePortalCache
extends BasePortalCache {
    private static final Log _log = LogFactoryUtil.getLog(MemcachePortalCache.class);
    private MemcachedClientIF _memcachedClient;
    private String _name;
    private int _timeout;
    private TimeUnit _timeoutTimeUnit;
    private int _timeToLive;

    public MemcachePortalCache(String name, MemcachedClientIF memcachedClient, int timeout, TimeUnit timeoutTimeUnit) {
        this._name = name;
        this._memcachedClient = memcachedClient;
        this._timeout = timeout;
        this._timeoutTimeUnit = timeoutTimeUnit;
    }

    public void destroy() {
        this._memcachedClient.shutdown();
    }

    public Collection<Object> get(Collection<String> keys) {
        ArrayList<String> processedKeys = new ArrayList<String>(keys.size());
        for (String key : keys) {
            String processedKey = this.processKey(this._name.concat(key));
            processedKeys.add(processedKey);
        }
        Future future = null;
        try {
            future = this._memcachedClient.asyncGetBulk(processedKeys);
        }
        catch (IllegalArgumentException iae) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Error retrieving with keys " + keys), (Throwable)iae);
            }
            return null;
        }
        Map values = null;
        try {
            values = (Map)future.get(this._timeout, this._timeoutTimeUnit);
        }
        catch (Throwable t) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Memcache operation error", t);
            }
            future.cancel(true);
        }
        return values.values();
    }

    public Object get(String key) {
        String processedKey = this.processKey(this._name.concat(key));
        Future future = null;
        try {
            future = this._memcachedClient.asyncGet(processedKey);
        }
        catch (IllegalArgumentException iae) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Error retrieving with key " + key), (Throwable)iae);
            }
            return null;
        }
        Object value = null;
        try {
            value = future.get(this._timeout, this._timeoutTimeUnit);
        }
        catch (Throwable t) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Memcache operation error", t);
            }
            future.cancel(true);
        }
        return value;
    }

    public void put(String key, Object obj) {
        this.put(key, obj, this._timeToLive);
    }

    public void put(String key, Object obj, int timeToLive) {
        block2: {
            String processedKey = this.processKey(this._name.concat(key));
            try {
                this._memcachedClient.set(processedKey, timeToLive, obj);
            }
            catch (IllegalArgumentException iae) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Error storing value with key " + key), (Throwable)iae);
            }
        }
    }

    public void put(String key, Serializable obj) {
        this.put(key, obj, this._timeToLive);
    }

    public void put(String key, Serializable obj, int timeToLive) {
        block2: {
            String processedKey = this.processKey(this._name.concat(key));
            try {
                this._memcachedClient.set(processedKey, timeToLive, (Object)obj);
            }
            catch (IllegalArgumentException iae) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Error storing value with key " + key), (Throwable)iae);
            }
        }
    }

    public void remove(String key) {
        block2: {
            String processedKey = this.processKey(this._name.concat(key));
            try {
                this._memcachedClient.delete(processedKey);
            }
            catch (IllegalArgumentException iae) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Error removing value with key " + key), (Throwable)iae);
            }
        }
    }

    public void removeAll() {
        this._memcachedClient.flush();
    }

    public void setTimeToLive(int timeToLive) {
        this._timeToLive = timeToLive;
    }
}

