/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.DeprecatedProperty;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Streamable;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MBean(description="Failure detection based on simple heartbeat protocol")
@DeprecatedProperty(names={"shun"})
public class FD
extends Protocol {
    @Property(description="Timeout to suspect a node P if neither a heartbeat nor data were received from P. Default is 3000 msec")
    long timeout = 3000L;
    @Property(description="Number of times to send an are-you-alive message")
    int max_tries = 2;
    protected int num_heartbeats = 0;
    protected int num_suspect_events = 0;
    protected final BoundedList<Address> suspect_history = new BoundedList(20);
    protected Address local_addr = null;
    private long last_ack = System.currentTimeMillis();
    protected int num_tries = 0;
    protected final Lock lock = new ReentrantLock();
    protected Address ping_dest = null;
    protected final List<Address> members = new ArrayList<Address>();
    protected final List<Address> pingable_mbrs = new ArrayList<Address>();
    private TimeScheduler timer = null;
    private Future<?> monitor_future = null;
    protected final Broadcaster bcast_task = new Broadcaster();

    @ManagedAttribute(description="Member address")
    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    @ManagedAttribute(description="List of cluster members")
    public String getMembers() {
        return this.members != null ? this.members.toString() : "null";
    }

    @ManagedAttribute(description="List of pingable members of a cluster")
    public String getPingableMembers() {
        return this.pingable_mbrs != null ? this.pingable_mbrs.toString() : "null";
    }

    @ManagedAttribute(description="Ping destination")
    public String getPingDest() {
        return this.ping_dest != null ? this.ping_dest.toString() : "null";
    }

    @ManagedAttribute(description="Number of heartbeats sent")
    public int getNumberOfHeartbeatsSent() {
        return this.num_heartbeats;
    }

    @ManagedAttribute(description="Number of suspect events received")
    public int getNumSuspectEventsGenerated() {
        return this.num_suspect_events;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public int getMaxTries() {
        return this.max_tries;
    }

    public void setMaxTries(int max_tries) {
        this.max_tries = max_tries;
    }

    public int getCurrentNumTries() {
        return this.num_tries;
    }

    @Deprecated
    public static boolean isShun() {
        return false;
    }

    @Deprecated
    public void setShun(boolean flag) {
    }

    @ManagedOperation(description="Print suspect history")
    public String printSuspectHistory() {
        StringBuilder sb = new StringBuilder();
        for (Address addr : this.suspect_history) {
            sb.append(new Date()).append(": ").append(addr).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void resetStats() {
        this.num_suspect_events = 0;
        this.num_heartbeats = 0;
        this.suspect_history.clear();
    }

    @Override
    public void init() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer cannot be retrieved");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.lock.lock();
        try {
            this.stopMonitor();
        }
        finally {
            this.lock.unlock();
        }
    }

    private Address getPingDest(List<Address> mbrs) {
        Address retval = null;
        if (mbrs == null || mbrs.size() < 2 || this.local_addr == null) {
            return null;
        }
        for (int i = 0; i < mbrs.size(); ++i) {
            Address tmp = mbrs.get(i);
            if (!this.local_addr.equals(tmp)) continue;
            if (i + 1 >= mbrs.size()) {
                retval = mbrs.get(0);
                break;
            }
            retval = mbrs.get(i + 1);
            break;
        }
        return retval;
    }

    private void startMonitor() {
        if (this.monitor_future == null || this.monitor_future.isDone()) {
            this.last_ack = System.currentTimeMillis();
            this.monitor_future = this.timer.scheduleWithFixedDelay(new Monitor(), this.timeout, this.timeout, TimeUnit.MILLISECONDS);
            this.num_tries = 0;
        }
    }

    private void stopMonitor() {
        if (this.monitor_future != null) {
            this.monitor_future.cancel(true);
            this.monitor_future = null;
        }
    }

    private void restartMonitor() {
        block4: {
            boolean restart_monitor;
            Address tmp_dest = this.getPingDest(this.pingable_mbrs);
            boolean bl = restart_monitor = tmp_dest == null || this.ping_dest == null || !this.ping_dest.equals(tmp_dest);
            if (restart_monitor) {
                this.ping_dest = tmp_dest;
                this.stopMonitor();
                if (this.ping_dest != null) {
                    try {
                        this.startMonitor();
                    }
                    catch (Exception ex) {
                        if (!this.log.isWarnEnabled()) break block4;
                        this.log.warn("exception when calling startMonitor(): " + ex);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                FdHeader hdr = (FdHeader)msg.getHeader(this.name);
                if (hdr == null) {
                    this.updateTimestamp(msg.getSrc());
                    break;
                }
                switch (hdr.type) {
                    case 0: {
                        Address hb_sender = msg.getSrc();
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("received are-you-alive from " + hb_sender + ", sending response");
                        }
                        this.sendHeartbeatResponse(hb_sender);
                        break;
                    }
                    case 1: {
                        this.updateTimestamp(hdr.from);
                        break;
                    }
                    case 2: {
                        if (hdr.mbrs == null) break;
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("[SUSPECT] suspect hdr is " + hdr);
                        }
                        for (Address mbr : hdr.mbrs) {
                            if (this.local_addr != null && mbr.equals(this.local_addr)) {
                                if (this.log.isWarnEnabled()) {
                                    this.log.warn("I was suspected by " + msg.getSrc() + "; ignoring the SUSPECT " + "message and sending back a HEARTBEAT_ACK");
                                }
                                this.sendHeartbeatResponse(msg.getSrc());
                                continue;
                            }
                            this.lock.lock();
                            try {
                                this.pingable_mbrs.remove(mbr);
                                this.restartMonitor();
                            }
                            finally {
                                this.lock.unlock();
                            }
                            this.up_prot.up(new Event(9, mbr));
                            this.down_prot.down(new Event(9, mbr));
                        }
                        break;
                    }
                }
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.down_prot.down(evt);
                this.lock.lock();
                try {
                    View v = (View)evt.getArg();
                    this.members.clear();
                    this.members.addAll(v.getMembers());
                    this.bcast_task.adjustSuspectedMembers(this.members);
                    this.pingable_mbrs.clear();
                    this.pingable_mbrs.addAll(this.members);
                    this.restartMonitor();
                }
                finally {
                    this.lock.unlock();
                }
                return null;
            }
            case 51: {
                this.unsuspect((Address)evt.getArg());
                return this.down_prot.down(evt);
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    private void sendHeartbeatResponse(Address dest) {
        Message hb_ack = new Message(dest, null, null);
        hb_ack.setFlag((byte)1);
        FdHeader tmp_hdr = new FdHeader(1);
        tmp_hdr.from = this.local_addr;
        hb_ack.putHeader(this.name, tmp_hdr);
        this.down_prot.down(new Event(1, hb_ack));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsuspect(Address mbr) {
        this.lock.lock();
        try {
            this.bcast_task.removeSuspectedMember(mbr);
            this.pingable_mbrs.clear();
            this.pingable_mbrs.addAll(this.members);
            this.pingable_mbrs.removeAll(this.bcast_task.getSuspectedMembers());
            this.restartMonitor();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTimestamp(Address sender) {
        if (this.ping_dest != null && sender != null && this.ping_dest.equals(sender)) {
            long tmp = System.currentTimeMillis();
            this.lock.lock();
            try {
                this.last_ack = tmp;
                this.num_tries = 0;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class BroadcastTask
    implements Runnable {
        private final Vector<Address> suspected_members = new Vector();

        BroadcastTask(Vector<Address> suspected_members) {
            this.suspected_members.addAll(suspected_members);
        }

        public void stop() {
            this.suspected_members.clear();
            if (FD.this.log.isTraceEnabled()) {
                FD.this.log.trace("BroadcastTask stopped");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FdHeader hdr;
            Vector<Address> vector = this.suspected_members;
            synchronized (vector) {
                if (this.suspected_members.isEmpty()) {
                    this.stop();
                    return;
                }
                hdr = new FdHeader(2);
                hdr.mbrs = new Vector<Address>(this.suspected_members);
                hdr.from = FD.this.local_addr;
            }
            Message suspect_msg = new Message();
            suspect_msg.setFlag((byte)1);
            suspect_msg.putHeader(FD.this.name, hdr);
            if (FD.this.log.isDebugEnabled()) {
                FD.this.log.debug("broadcasting SUSPECT message [suspected_mbrs=" + this.suspected_members + "] to group");
            }
            FD.this.down_prot.down(new Event(1, suspect_msg));
        }

        public void addSuspectedMember(Address suspect) {
            if (suspect != null && !this.suspected_members.contains(suspect)) {
                this.suspected_members.add(suspect);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class Broadcaster {
        final Vector<Address> suspected_mbrs = new Vector(7);
        final Lock bcast_lock = new ReentrantLock();
        Future<?> bcast_future = null;
        BroadcastTask task;

        protected Broadcaster() {
        }

        Vector<Address> getSuspectedMembers() {
            return this.suspected_mbrs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startBroadcastTask(Address suspect) {
            this.bcast_lock.lock();
            try {
                if (this.bcast_future == null || this.bcast_future.isDone()) {
                    this.task = new BroadcastTask(this.suspected_mbrs);
                    this.task.addSuspectedMember(suspect);
                    this.bcast_future = FD.this.timer.scheduleWithFixedDelay(this.task, 0L, FD.this.timeout, TimeUnit.MILLISECONDS);
                    if (FD.this.log.isTraceEnabled()) {
                        FD.this.log.trace("BroadcastTask started");
                    }
                } else {
                    this.task.addSuspectedMember(suspect);
                }
            }
            finally {
                this.bcast_lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopBroadcastTask() {
            this.bcast_lock.lock();
            try {
                if (this.bcast_future != null) {
                    this.bcast_future.cancel(true);
                    this.bcast_future = null;
                    this.task = null;
                }
            }
            finally {
                this.bcast_lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addSuspectedMember(Address mbr) {
            if (mbr == null) {
                return;
            }
            if (!FD.this.members.contains(mbr)) {
                return;
            }
            Vector<Address> vector = this.suspected_mbrs;
            synchronized (vector) {
                if (!this.suspected_mbrs.contains(mbr)) {
                    this.suspected_mbrs.addElement(mbr);
                    this.startBroadcastTask(mbr);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeSuspectedMember(Address suspected_mbr) {
            if (suspected_mbr == null) {
                return;
            }
            if (FD.this.log.isDebugEnabled()) {
                FD.this.log.debug("member is " + suspected_mbr);
            }
            Vector<Address> vector = this.suspected_mbrs;
            synchronized (vector) {
                this.suspected_mbrs.removeElement(suspected_mbr);
                if (this.suspected_mbrs.isEmpty()) {
                    this.stopBroadcastTask();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void adjustSuspectedMembers(List<Address> new_mbrship) {
            if (new_mbrship == null || new_mbrship.isEmpty()) {
                return;
            }
            Vector<Address> vector = this.suspected_mbrs;
            synchronized (vector) {
                this.suspected_mbrs.retainAll(new_mbrship);
                if (this.suspected_mbrs.isEmpty()) {
                    this.stopBroadcastTask();
                }
            }
        }
    }

    protected class Monitor
    implements Runnable {
        protected Monitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Address dest = null;
            FD.this.lock.lock();
            try {
                if (FD.this.ping_dest == null) {
                    if (FD.this.log.isWarnEnabled()) {
                        FD.this.log.warn("ping_dest is null: members=" + FD.this.members + ", pingable_mbrs=" + FD.this.pingable_mbrs + ", local_addr=" + FD.this.local_addr);
                    }
                    return;
                }
                dest = FD.this.ping_dest;
            }
            finally {
                FD.this.lock.unlock();
            }
            Message hb_req = new Message(dest, null, null);
            hb_req.setFlag((byte)1);
            hb_req.putHeader(FD.this.name, new FdHeader(0));
            if (FD.this.log.isDebugEnabled()) {
                FD.this.log.debug("sending are-you-alive msg to " + dest + " (own address=" + FD.this.local_addr + ')');
            }
            FD.this.down_prot.down(new Event(1, hb_req));
            ++FD.this.num_heartbeats;
            long not_heard_from = System.currentTimeMillis() - FD.this.last_ack;
            if (not_heard_from > FD.this.timeout + 500L) {
                if (FD.this.num_tries >= FD.this.max_tries) {
                    if (FD.this.log.isDebugEnabled()) {
                        FD.this.log.debug("[" + FD.this.local_addr + "]: received no heartbeat ack from " + dest + " for " + (FD.this.num_tries + 1) + " times (" + (long)(FD.this.num_tries + 1) * FD.this.timeout + " milliseconds), suspecting it");
                    }
                    FD.this.bcast_task.addSuspectedMember(dest);
                    FD.this.num_tries = 0;
                    if (FD.this.stats) {
                        ++FD.this.num_suspect_events;
                        FD.this.suspect_history.add(dest);
                    }
                } else {
                    if (FD.this.log.isDebugEnabled()) {
                        FD.this.log.debug("heartbeat missing from " + dest + " (number=" + FD.this.num_tries + ')');
                    }
                    ++FD.this.num_tries;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FdHeader
    extends Header
    implements Streamable {
        public static final byte HEARTBEAT = 0;
        public static final byte HEARTBEAT_ACK = 1;
        public static final byte SUSPECT = 2;
        byte type = 0;
        Collection<Address> mbrs = null;
        Address from = null;
        private static final long serialVersionUID = -6387039473828820899L;

        public FdHeader() {
        }

        public FdHeader(byte type) {
            this.type = type;
        }

        public FdHeader(byte type, Collection<Address> mbrs, Address from) {
            this(type);
            this.mbrs = mbrs;
            this.from = from;
        }

        @Override
        public String toString() {
            switch (this.type) {
                case 0: {
                    return "heartbeat";
                }
                case 1: {
                    return "heartbeat ack";
                }
                case 2: {
                    return "SUSPECT (suspected_mbrs=" + this.mbrs + ", from=" + this.from + ")";
                }
            }
            return "unknown type (" + this.type + ")";
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            if (this.mbrs == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeInt(this.mbrs.size());
                for (Address addr : this.mbrs) {
                    out.writeObject(addr);
                }
            }
            out.writeObject(this.from);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            boolean mbrs_not_null = in.readBoolean();
            if (mbrs_not_null) {
                int len = in.readInt();
                this.mbrs = new Vector<Address>(11);
                for (int i = 0; i < len; ++i) {
                    Address addr = (Address)in.readObject();
                    this.mbrs.add(addr);
                }
            }
            this.from = (Address)in.readObject();
        }

        @Override
        public int size() {
            int retval = 1;
            retval = (int)((long)retval + Util.size(this.mbrs));
            return retval += Util.size(this.from);
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            Util.writeAddresses(this.mbrs, out);
            Util.writeAddress(this.from, out);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.mbrs = Util.readAddresses(in, Vector.class);
            this.from = Util.readAddress(in);
        }
    }
}

