/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter;

import java.sql.Clob;
import java.sql.SQLException;
import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringConverter
implements TypeConverter<String> {
    public static String valueOf(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (type == byte[].class) {
            byte[] valueArray = (byte[])value;
            return new String(valueArray, 0, valueArray.length);
        }
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            try {
                long lenght = clob.length();
                if (lenght > Integer.MAX_VALUE) {
                    throw new TypeConversionException("Clob is too big.");
                }
                return clob.getSubString(1L, (int)lenght);
            }
            catch (SQLException sex) {
                throw new TypeConversionException(value, (Throwable)sex);
            }
        }
        return value.toString();
    }

    @Override
    public String convert(Object value) {
        return StringConverter.valueOf(value);
    }
}

