/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth.acl;

import com.ecyrd.jspwiki.auth.acl.Acl;
import com.ecyrd.jspwiki.auth.acl.AclEntry;
import java.io.Serializable;
import java.security.Permission;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Vector;

public class AclImpl
implements Acl,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Vector<AclEntry> m_entries = new Vector();

    public Principal[] findPrincipals(Permission permission) {
        Vector<Principal> principals = new Vector<Principal>();
        Enumeration entries = this.entries();
        while (entries.hasMoreElements()) {
            AclEntry entry = (AclEntry)entries.nextElement();
            Enumeration permissions = entry.permissions();
            while (permissions.hasMoreElements()) {
                Permission perm = (Permission)permissions.nextElement();
                if (!perm.implies(permission)) continue;
                principals.add(entry.getPrincipal());
            }
        }
        return principals.toArray(new Principal[principals.size()]);
    }

    private boolean hasEntry(AclEntry entry) {
        if (entry == null) {
            return false;
        }
        for (AclEntry e : this.m_entries) {
            Principal ep = e.getPrincipal();
            Principal entryp = entry.getPrincipal();
            if (ep == null || entryp == null) {
                throw new IllegalArgumentException("Entry is null; check code, please (entry=" + entry + "; e=" + e + ")");
            }
            if (!ep.getName().equals(entryp.getName())) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean addEntry(AclEntry entry) {
        if (entry.getPrincipal() == null) {
            throw new IllegalArgumentException("Entry principal cannot be null");
        }
        if (this.hasEntry(entry)) {
            return false;
        }
        this.m_entries.add(entry);
        return true;
    }

    public synchronized boolean removeEntry(AclEntry entry) {
        return this.m_entries.remove(entry);
    }

    public Enumeration entries() {
        return this.m_entries.elements();
    }

    public AclEntry getEntry(Principal principal) {
        for (AclEntry entry : this.m_entries) {
            if (!entry.getPrincipal().getName().equals(principal.getName())) continue;
            return entry;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (AclEntry entry : this.m_entries) {
            Principal pal = entry.getPrincipal();
            if (pal != null) {
                sb.append("  user = " + pal.getName() + ": ");
            } else {
                sb.append("  user = null: ");
            }
            sb.append("(");
            Enumeration perms = entry.permissions();
            while (perms.hasMoreElements()) {
                Permission perm = (Permission)perms.nextElement();
                sb.append(perm.toString());
            }
            sb.append(")\n");
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.m_entries.isEmpty();
    }
}

