/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.eis.cobol.helper;

import java.io.StringWriter;
import org.eclipse.persistence.internal.eis.cobol.ByteArrayException;
import org.eclipse.persistence.internal.eis.cobol.FieldMetaData;
import org.eclipse.persistence.internal.eis.cobol.helper.Helper;

public class ByteConverter {
    private byte[] myRecordData;
    FieldMetaData myFieldMetaData;
    public static int wordSize = 2;
    private boolean isLittleEndian;

    public ByteConverter() {
        this.initialize();
    }

    public ByteConverter(FieldMetaData metaData, byte[] recordData) {
        this.initialize(metaData, recordData);
    }

    protected void initialize() {
        this.isLittleEndian = false;
    }

    protected void initialize(FieldMetaData metaData, byte[] recordData) {
        this.myFieldMetaData = metaData;
        this.myRecordData = recordData;
        this.isLittleEndian = false;
    }

    public boolean isLittleEndian() {
        return this.isLittleEndian;
    }

    public void setIsLittleEndian(boolean newValue) {
        this.isLittleEndian = newValue;
    }

    public int getWordSize() {
        return wordSize;
    }

    public void setWordSize(int newWordSize) {
        wordSize = newWordSize;
    }

    protected String insertDecimalInString(String string) {
        int decimalPosition;
        if (this.getFieldMetaData().hasDecimal() && (decimalPosition = this.getFieldMetaData().getDecimalPosition()) < string.length()) {
            StringWriter writer = new StringWriter();
            writer.write(string.substring(0, decimalPosition - 1));
            writer.write(".");
            writer.write(string.substring(decimalPosition - 1));
            return writer.toString();
        }
        return string;
    }

    protected String removeDecimalInString(String string) {
        int decimalPosition;
        if (this.getFieldMetaData().hasDecimal() && (decimalPosition = this.getFieldMetaData().getDecimalPosition()) < string.length()) {
            StringWriter writer = new StringWriter();
            writer.write(string.substring(0, decimalPosition - 1));
            writer.write(string.substring(decimalPosition));
            return writer.toString();
        }
        return string;
    }

    public String getStringValue() {
        int offset = this.getFieldMetaData().getOffset();
        String stringValue = null;
        if (this.getFieldMetaData().getType() != 5 && this.getFieldMetaData().getType() != 6 && this.getFieldMetaData().getType() != 7) {
            int length;
            for (length = 0; length < this.getFieldMetaData().getSize() && this.getRecordData()[offset + length] != 0; ++length) {
            }
            stringValue = new String(this.getRecordData(), offset, length);
        } else if (this.getFieldMetaData().getType() == 5) {
            if (this.isLittleEndian()) {
                this.swapEndians(offset, this.getFieldMetaData().getSize());
            }
            stringValue = this.getStringFromBinaryData(offset, this.getFieldMetaData().getSize());
        } else {
            stringValue = this.getFieldMetaData().getType() == 7 ? this.getStringValueFromPackedDecimal() : null;
        }
        return this.insertDecimalInString(stringValue);
    }

    public void setBytesToValue(String value) {
        value = this.removeDecimalInString(value);
        if (this.getFieldMetaData().getType() != 5 && this.getFieldMetaData().getType() != 6 && this.getFieldMetaData().getType() != 7) {
            byte[] byteValue = value.getBytes();
            int length = byteValue.length;
            if (length > this.getFieldMetaData().getSize()) {
                length = this.getFieldMetaData().getSize();
            }
            int i = 0;
            int j = this.getFieldMetaData().getOffset();
            while (i < length) {
                this.getRecordData()[j] = byteValue[i];
                ++i;
                ++j;
            }
            if (length < this.getFieldMetaData().getSize()) {
                this.getRecordData()[j] = 0;
            }
        } else if (this.getFieldMetaData().getType() == 5) {
            this.setBinaryDataToStringValue(value, this.getFieldMetaData().getOffset(), this.getFieldMetaData().getSize());
        } else if (this.getFieldMetaData().getType() == 7) {
            this.setByteArrayToPackedDecimalValue(value);
        }
    }

    public FieldMetaData getFieldMetaData() {
        return this.myFieldMetaData;
    }

    public void setFieldMetaData(FieldMetaData newFieldMetaData) {
        this.myFieldMetaData = newFieldMetaData;
    }

    public byte[] getRecordData() {
        return this.myRecordData;
    }

    public void setRecordData(byte[] newRecordData) {
        this.myRecordData = newRecordData;
    }

    protected String getStringValueFromPackedDecimal() {
        int mask = 240;
        boolean signed = this.getFieldMetaData().isSigned();
        String sign = new String();
        int offset = this.getFieldMetaData().getOffset();
        int size = this.getFieldMetaData().getSize();
        String value = new String();
        int position = 0;
        if (signed) {
            byte signBits = (byte)(this.myRecordData[offset + size - 1] | mask);
            if (signBits == 13) {
                sign = "-";
            } else if (signBits == 12) {
                sign = "+";
            }
        }
        for (int i = offset; i < offset + size; ++i) {
            String stringValue = Integer.toHexString(Helper.intFromByte(this.myRecordData[i]));
            if (stringValue.length() > 2) {
                stringValue = stringValue.substring(stringValue.length() - 2);
            }
            value = value + stringValue;
        }
        while (value.charAt(position) == '0') {
            ++position;
        }
        value = value.substring(position, value.length() - 1);
        if (signed) {
            return sign + value;
        }
        return value;
    }

    protected void setByteArrayToPackedDecimalValue(String value) {
        int size = this.getFieldMetaData().getSize();
        int offset = this.getFieldMetaData().getOffset();
        boolean signed = this.getFieldMetaData().isSigned();
        if (signed) {
            value = value.startsWith("-") ? value + "d" : value + "c";
            value = value.substring(1);
        } else {
            value = value + "f";
        }
        while (value.length() < size * 2) {
            value = "0" + value;
        }
        int i = offset;
        int j = 0;
        while (i < offset + size) {
            this.myRecordData[i] = Helper.byteFromInt(Helper.intFromHexString(value.substring(j, j + 2)));
            ++i;
            j += 2;
        }
    }

    protected void swapEndians(int offset, int end) {
        if (wordSize > 0 && wordSize % 2 == 0) {
            int length = end - offset;
            int stop = end;
            if (length % wordSize != 0) {
                int remainder = length % wordSize;
                stop = end - remainder;
            }
            int halfWord = wordSize / 2;
            for (int i = offset; i < stop; i += wordSize) {
                for (int j = 0; j < halfWord; ++j) {
                    byte lowByte;
                    byte highByte = this.myRecordData[i + j];
                    this.myRecordData[i + j] = lowByte = this.myRecordData[i + j + halfWord];
                    this.myRecordData[i + j + halfWord] = highByte;
                }
            }
        } else {
            throw ByteArrayException.unrecognizedDataType();
        }
    }

    protected void twosComplement(int offset, int length) {
        int i;
        for (i = offset; i < offset + length; ++i) {
            this.myRecordData[i] = Helper.byteFromInt(~Helper.intFromByte(this.myRecordData[i]));
        }
        --i;
        while (i >= offset && Helper.intFromByte(this.myRecordData[i]) == -1) {
            int n = i--;
            this.myRecordData[n] = (byte)(this.myRecordData[n] + 1);
        }
        if (i >= offset) {
            int n = i;
            this.myRecordData[n] = (byte)(this.myRecordData[n] + 1);
        }
    }

    protected String getStringFromBinaryData(int offset, int size) {
        boolean signed = this.getFieldMetaData().isSigned();
        String sign = new String();
        int total = 0;
        if (signed) {
            byte highestByte = this.myRecordData[offset];
            int mask = 255;
            if ((highestByte >> 3 & mask) == 255) {
                sign = "-";
                this.twosComplement(offset, size);
            } else {
                sign = "+";
            }
        }
        int i = offset + size - 1;
        int j = 0;
        while (i >= offset) {
            if (Helper.intFromByte(this.myRecordData[i]) < 0) {
                int n = i;
                this.myRecordData[n] = (byte)(this.myRecordData[n] & 0x7F);
                total += Helper.power(2, (j + 1) * 8 - 1);
            }
            total += Helper.intFromByte(this.myRecordData[i]) * Helper.power(2, j * 8);
            --i;
            ++j;
        }
        if (signed) {
            return sign + String.valueOf(total);
        }
        return String.valueOf(total);
    }

    protected void setBinaryDataToStringValue(String value, int offset, int size) {
        boolean isNegative = false;
        if (value.startsWith("-")) {
            isNegative = true;
            value = value.substring(1);
        } else if (value.startsWith("+")) {
            value = value.substring(1);
        }
        int total = Helper.integerFromString(value);
        int i = offset;
        int j = size - 1;
        while (i < size + offset) {
            this.myRecordData[i] = Helper.byteFromInt(total / Helper.power(2, j * 8));
            total %= Helper.power(2, j * 8);
            ++i;
            --j;
        }
        if (isNegative) {
            this.twosComplement(offset, size);
        }
    }
}

