/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.rmic;

import java.util.Locale;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.rmic.ForkingSunRmic;
import org.apache.tools.ant.taskdefs.rmic.KaffeRmic;
import org.apache.tools.ant.taskdefs.rmic.RmicAdapter;
import org.apache.tools.ant.taskdefs.rmic.SunRmic;
import org.apache.tools.ant.taskdefs.rmic.WLRmic;
import org.apache.tools.ant.taskdefs.rmic.XNewRmic;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.ClasspathUtils;

public final class RmicAdapterFactory {
    public static final String ERROR_UNKNOWN_COMPILER = "Class not found: ";
    public static final String ERROR_NOT_RMIC_ADAPTER = "Class of unexpected Type: ";
    public static final String DEFAULT_COMPILER = "default";
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$rmic$RmicAdapterFactory;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$rmic$RmicAdapter;

    private RmicAdapterFactory() {
    }

    public static RmicAdapter getRmic(String rmicType, Task task) throws BuildException {
        return RmicAdapterFactory.getRmic(rmicType, task, null);
    }

    public static RmicAdapter getRmic(String rmicType, Task task, Path classpath) throws BuildException {
        String compiler = rmicType.toLowerCase(Locale.ENGLISH);
        if (DEFAULT_COMPILER.equals(compiler) || compiler.length() == 0) {
            String string = compiler = KaffeRmic.isAvailable() ? "kaffe" : "sun";
        }
        if ("sun".equals(compiler)) {
            return new SunRmic();
        }
        if ("kaffe".equals(compiler)) {
            return new KaffeRmic();
        }
        if ("weblogic".equals(compiler)) {
            return new WLRmic();
        }
        if ("forking".equals(compiler)) {
            return new ForkingSunRmic();
        }
        if ("xnew".equals(compiler)) {
            return new XNewRmic();
        }
        return RmicAdapterFactory.resolveClassName(rmicType, task.getProject().createClassLoader(classpath));
    }

    private static RmicAdapter resolveClassName(String className, ClassLoader loader) throws BuildException {
        return (RmicAdapter)ClasspathUtils.newInstance(className, loader != null ? loader : (class$org$apache$tools$ant$taskdefs$rmic$RmicAdapterFactory == null ? (class$org$apache$tools$ant$taskdefs$rmic$RmicAdapterFactory = RmicAdapterFactory.class$("org.apache.tools.ant.taskdefs.rmic.RmicAdapterFactory")) : class$org$apache$tools$ant$taskdefs$rmic$RmicAdapterFactory).getClassLoader(), class$org$apache$tools$ant$taskdefs$rmic$RmicAdapter == null ? (class$org$apache$tools$ant$taskdefs$rmic$RmicAdapter = RmicAdapterFactory.class$("org.apache.tools.ant.taskdefs.rmic.RmicAdapter")) : class$org$apache$tools$ant$taskdefs$rmic$RmicAdapter);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

