/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.association.Association;
import org.openid4java.association.AssociationException;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.message.Message;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;
import org.openid4java.util.InternetDateFormat;

public class AuthSuccess
extends Message {
    private static Log _log = LogFactory.getLog(AuthSuccess.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    protected static final List requiredFields = Arrays.asList("openid.mode", "openid.return_to", "openid.assoc_handle", "openid.signed", "openid.sig");
    protected static final List optionalFields = Arrays.asList("openid.ns", "openid.op_endpoint", "openid.claimed_id", "openid.identity", "openid.response_nonce", "openid.invalidate_handle");
    protected static final String signRequired1 = "return_to,identity";
    protected static final String signRequired2 = "op_endpoint,claimed_id,identity,return_to,response_nonce,assoc_handle";
    protected static final String signRequired3 = "op_endpoint,return_to,response_nonce,assoc_handle";
    protected List _signFields = new ArrayList();
    protected List _signExtensions = new ArrayList();

    protected AuthSuccess(String opEndpoint, String claimedId, String delegate, boolean compatibility, String returnTo, String nonce, String invalidateHandle, Association assoc, boolean signNow) throws AssociationException {
        if (!compatibility) {
            this.set("openid.ns", "http://specs.openid.net/auth/2.0");
            this.setOpEndpoint(opEndpoint);
            this.setClaimed(claimedId);
            this.setNonce(nonce);
        }
        this.set("openid.mode", "id_res");
        this.setIdentity(delegate);
        this.setReturnTo(returnTo);
        if (invalidateHandle != null) {
            this.setInvalidateHandle(invalidateHandle);
        }
        this.setHandle(assoc.getHandle());
        this.buildSignedList();
        this.setSignature(signNow ? assoc.sign(this.getSignedText()) : "");
    }

    protected AuthSuccess(ParameterList params) {
        super(params);
    }

    public static AuthSuccess createAuthSuccess(String opEndpoint, String claimedId, String delegate, boolean compatibility, String returnTo, String nonce, String invalidateHandle, Association assoc, boolean signNow) throws MessageException, AssociationException {
        AuthSuccess resp = new AuthSuccess(opEndpoint, claimedId, delegate, compatibility, returnTo, nonce, invalidateHandle, assoc, signNow);
        resp.validate();
        if (DEBUG) {
            _log.debug((Object)("Created positive auth response:\n" + resp.keyValueFormEncoding()));
        }
        return resp;
    }

    public static AuthSuccess createAuthSuccess(ParameterList params) throws MessageException {
        AuthSuccess resp = new AuthSuccess(params);
        resp.validate();
        if (DEBUG) {
            _log.debug((Object)("Created positive auth response:\n" + resp.keyValueFormEncoding()));
        }
        return resp;
    }

    public List getRequiredFields() {
        return requiredFields;
    }

    public boolean isVersion2() {
        return this.hasParameter("openid.ns") && "http://specs.openid.net/auth/2.0".equals(this.getParameterValue("openid.ns"));
    }

    public void setMode(String mode) throws MessageException {
        if (!mode.equals("id_res") && !mode.equals("cancel")) {
            throw new MessageException("Unknown authentication mode: " + mode);
        }
        this.set("openid.mode", mode);
    }

    public String getMode() {
        return this.getParameterValue("openid.mode");
    }

    public void setOpEndpoint(String opEndpoint) {
        this.set("openid.op_endpoint", opEndpoint);
    }

    public String getOpEndpoint() {
        return this.getParameterValue("openid.op_endpoint");
    }

    public void setIdentity(String id) {
        this.set("openid.identity", id);
    }

    public String getIdentity() throws DiscoveryException {
        return this.getParameterValue("openid.identity");
    }

    public void setClaimed(String claimed) {
        this.set("openid.claimed_id", claimed);
    }

    public String getClaimed() {
        return this.getParameterValue("openid.claimed_id");
    }

    public void setReturnTo(String returnTo) {
        this.set("openid.return_to", returnTo);
        this._destinationUrl = returnTo;
    }

    public String getReturnTo() {
        return this.getParameterValue("openid.return_to");
    }

    public void setNonce(String nonce) {
        this.set("openid.response_nonce", nonce);
    }

    public String getNonce() {
        return this.getParameterValue("openid.response_nonce");
    }

    public void setInvalidateHandle(String handle) {
        this.set("openid.invalidate_handle", handle);
    }

    public String getInvalidateHandle() {
        return this.getParameterValue("openid.invalidate_handle");
    }

    public void setHandle(String handle) {
        this.set("openid.assoc_handle", handle);
    }

    public String getHandle() {
        return this.getParameterValue("openid.assoc_handle");
    }

    public void buildSignedList() {
        StringBuffer toSign = !this.isVersion2() ? new StringBuffer(signRequired1) : (this.hasParameter("openid.identity") ? new StringBuffer(signRequired2) : new StringBuffer(signRequired3));
        ArrayList<String> signList = new ArrayList<String>(Arrays.asList(toSign.toString().split(",")));
        for (String field : this._signFields) {
            if (signList.contains(field)) continue;
            toSign.append(",").append(field);
            signList.add(field);
        }
        ArrayList<String> extensionPrefixes = new ArrayList<String>();
        Iterator iter = this._signExtensions.iterator();
        while (iter.hasNext()) {
            String alias = this.getExtensionAlias((String)iter.next());
            if (alias == null) continue;
            extensionPrefixes.add(alias);
        }
        iter = this.getParameters().iterator();
        while (iter.hasNext()) {
            String signName;
            int dotIndex;
            String paramName = ((Parameter)iter.next()).getKey();
            if (!paramName.startsWith("openid.") || (dotIndex = (signName = paramName.substring(7)).indexOf(".")) <= 0 || !extensionPrefixes.contains(signName.substring(0, dotIndex)) || signList.contains(signName)) continue;
            toSign.append(",").append(signName);
            signList.add(signName);
        }
        if (DEBUG) {
            _log.debug((Object)("Setting fields to be signed: " + toSign));
        }
        this.set("openid.signed", toSign.toString());
    }

    public void setSignFields(String userSuppliedList) {
        if (userSuppliedList != null) {
            this._signFields = Arrays.asList(userSuppliedList.split(","));
            this.buildSignedList();
        }
    }

    public void setSignExtensions(String[] extensions) {
        if (extensions != null) {
            this._signExtensions = new ArrayList<String>(Arrays.asList(extensions));
            this.buildSignedList();
        }
    }

    public void addSignExtension(String extensionNamespace) {
        if (!this._signExtensions.contains(extensionNamespace)) {
            this._signExtensions.add(extensionNamespace);
            this.buildSignedList();
        }
    }

    public List getSignExtensions() {
        return this._signExtensions;
    }

    public void setSignature(String sig) {
        this.set("openid.sig", sig);
        if (DEBUG) {
            _log.debug((Object)("Added signature: " + sig));
        }
    }

    public String getSignature() {
        return this.getParameterValue("openid.sig");
    }

    public String getSignList() {
        return this.getParameterValue("openid.signed");
    }

    public String getSignedText() {
        StringBuffer signedText = new StringBuffer("");
        String[] signedParams = this.getParameterValue("openid.signed").split(",");
        for (int i = 0; i < signedParams.length; ++i) {
            signedText.append(signedParams[i]);
            signedText.append(':');
            String value = this.getParameterValue("openid." + signedParams[i]);
            if (value != null) {
                signedText.append(value);
            }
            signedText.append('\n');
        }
        return signedText.toString();
    }

    public void validate() throws MessageException {
        List<String> signedFields;
        boolean compatibility;
        super.validate();
        boolean bl = compatibility = !this.isVersion2();
        if (!compatibility && !this.hasParameter("openid.op_endpoint")) {
            throw new MessageException("openid.op_endpoint is required in OpenID auth responses", 768);
        }
        try {
            if (this.getReturnTo() != null) {
                new URL(this.getReturnTo());
            }
        }
        catch (MalformedURLException e) {
            throw new MessageException("Invalid return_to: " + this.getReturnTo(), 768, e);
        }
        try {
            if (this.isVersion2() && this.getOpEndpoint() != null) {
                new URL(this.getOpEndpoint());
            }
        }
        catch (MalformedURLException e) {
            throw new MessageException("Invalid op_endpoint: " + this.getOpEndpoint(), 768, e);
        }
        if (!"id_res".equals(this.getMode())) {
            throw new MessageException("Invalid openid.mode value in auth response: " + this.getMode(), 768);
        }
        if (!this.hasParameter("openid.identity")) {
            if (compatibility) {
                throw new MessageException("openid.identity is required in OpenID1 auth responses", 768);
            }
            boolean hasAuthExt = false;
            Iterator iter = this.getExtensions().iterator();
            while (iter.hasNext()) {
                String typeUri = iter.next().toString();
                try {
                    MessageExtension extension = this.getExtension(typeUri);
                    if (!extension.providesIdentifier()) continue;
                    hasAuthExt = true;
                    break;
                }
                catch (MessageException ignore) {
                }
            }
            if (!hasAuthExt) {
                throw new MessageException("no identifier specified in auth request", 768);
            }
            if (this.hasParameter("openid.claimed_id")) {
                throw new MessageException("openid.claimed_id must be present if and only if openid.identity is present.", 768);
            }
        } else if (!compatibility && !this.hasParameter("openid.claimed_id")) {
            throw new MessageException("openid.clamied_id must be present in OpenID2 auth responses", 768);
        }
        String nonce = this.getNonce();
        if (!compatibility) {
            if (nonce == null) {
                throw new MessageException("openid.response_nonce is required in OpenID2 auth responses", 768);
            }
            InternetDateFormat _dateFormat = new InternetDateFormat();
            try {
                _dateFormat.parse(nonce.substring(0, 20));
            }
            catch (ParseException e) {
                throw new MessageException("Error parsing nonce in auth response.", 768, e);
            }
            if (nonce.length() > 255) {
                throw new MessageException("nonce length must not exceed 255 characters", 768);
            }
        } else if (nonce != null) {
            _log.warn((Object)"openid.response_nonce present in OpenID1 auth response");
        }
        if (!(signedFields = Arrays.asList(this.getParameterValue("openid.signed").split(","))).contains("return_to")) {
            throw new MessageException("return_to must be signed", 768);
        }
        if (compatibility == signedFields.contains("response_nonce")) {
            _log.warn((Object)"response_nonce must be present and signed only in OpenID2 auth responses");
        }
        if (compatibility == signedFields.contains("op_endpoint")) {
            _log.warn((Object)"op_endpoint must be present and signed only in OpenID2 auth responses");
        }
        if (!compatibility && !signedFields.contains("assoc_handle")) {
            throw new MessageException("assoc_handle must be signed in OpenID2 auth responses", 768);
        }
        if (this.hasParameter("openid.identity") && !signedFields.contains("identity")) {
            throw new MessageException("openid.identity must be signed if present", 768);
        }
        if (this.hasParameter("openid.claimed_id") && !signedFields.contains("claimed_id")) {
            throw new MessageException("openid.claimed_id must be signed if present", 768);
        }
    }
}

