/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MBean(description="Simple flow control protocol based on a credit system")
public class FC
extends Protocol {
    private static final FcHeader REPLENISH_HDR = new FcHeader(1);
    private static final FcHeader CREDIT_REQUEST_HDR = new FcHeader(2);
    @Property(description="Max number of bytes to send per receiver until an ack must be received to proceed. Default is 500000 bytes")
    private long max_credits = 500000L;
    @Property(description="Max time (in milliseconds) to block. Default is 5000 msec")
    private long max_block_time = 5000L;
    private Map<Long, Long> max_block_times = null;
    private static final ThreadLocal<Long> end_time = new ThreadLocal();
    @Property(description="If credits (bytes) used so far fall below this limit, we send more credits to the sender")
    private double min_threshold = 0.25;
    @Property(description="Computed as max_credits x min_theshold unless explicitly set")
    private long min_credits = 0L;
    @Property(description="Does not block a down message if it is a result of handling an up message in thesame thread. Fixes JGRP-928")
    private boolean ignore_synchronous_response = true;
    private int num_blockings = 0;
    private int num_credit_requests_received = 0;
    private int num_credit_requests_sent = 0;
    private int num_credit_responses_sent = 0;
    private int num_credit_responses_received = 0;
    private long total_time_blocking = 0L;
    private final BoundedList<Long> last_blockings = new BoundedList(50);
    private final Map<Address, Long> sent = new HashMap<Address, Long>(11);
    private final Map<Address, Long> received = new ConcurrentHashMap<Address, Long>(11);
    private final Set<Address> creditors = new HashSet<Address>(11);
    private final Set<Address> pending_requesters = new HashSet<Address>(11);
    private volatile boolean running = true;
    private boolean frag_size_received = false;
    private long lowest_credit = this.max_credits;
    private final Lock sent_lock = new ReentrantLock();
    private final Lock received_lock = new ReentrantLock();
    private final Condition credits_available = this.sent_lock.newCondition();
    private final ThreadLocal<Boolean> ignore_thread = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private long last_credit_request = 0L;

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_blockings = 0;
        this.num_credit_requests_sent = 0;
        this.num_credit_requests_received = 0;
        this.num_credit_responses_received = 0;
        this.num_credit_responses_sent = 0;
        this.total_time_blocking = 0L;
        this.last_blockings.clear();
    }

    public long getMaxCredits() {
        return this.max_credits;
    }

    public void setMaxCredits(long max_credits) {
        this.max_credits = max_credits;
    }

    public double getMinThreshold() {
        return this.min_threshold;
    }

    public void setMinThreshold(double min_threshold) {
        this.min_threshold = min_threshold;
    }

    public long getMinCredits() {
        return this.min_credits;
    }

    public void setMinCredits(long min_credits) {
        this.min_credits = min_credits;
    }

    @ManagedAttribute(description="Number of times flow control blocks sender")
    public int getNumberOfBlockings() {
        return this.num_blockings;
    }

    public long getMaxBlockTime() {
        return this.max_block_time;
    }

    public void setMaxBlockTime(long t) {
        this.max_block_time = t;
    }

    @Property(description="Max times to block for the listed messages sizes (Message.getLength()). Example: \"1000:10,5000:30,10000:500\"")
    public void setMaxBlockTimes(String str) {
        if (str == null) {
            return;
        }
        Long prev_key = null;
        Long prev_val = null;
        List<String> vals = Util.parseCommaDelimitedStrings(str);
        if (this.max_block_times == null) {
            this.max_block_times = new TreeMap<Long, Long>();
        }
        for (String tmp : vals) {
            int index = tmp.indexOf(58);
            if (index == -1) {
                throw new IllegalArgumentException("element '" + tmp + "'  is missing a ':' separator");
            }
            Long key = Long.parseLong(tmp.substring(0, index).trim());
            Long val = Long.parseLong(tmp.substring(index + 1).trim());
            if (key < 0L || val < 0L) {
                throw new IllegalArgumentException("keys and values must be >= 0");
            }
            if (prev_key != null && key <= prev_key) {
                throw new IllegalArgumentException("keys are not sorted: " + vals);
            }
            prev_key = key;
            if (prev_val != null && val <= prev_val) {
                throw new IllegalArgumentException("values are not sorted: " + vals);
            }
            prev_val = val;
            this.max_block_times.put(key, val);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("max_block_times: " + this.max_block_times);
        }
    }

    public String getMaxBlockTimes() {
        if (this.max_block_times == null) {
            return "n/a";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<Long, Long> entry : this.max_block_times.entrySet()) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(entry.getKey()).append(":").append(entry.getValue());
        }
        return sb.toString();
    }

    @ManagedAttribute(description="Total time (ms) spent in flow control block")
    public long getTotalTimeBlocked() {
        return this.total_time_blocking;
    }

    @ManagedAttribute(description="Average time spent in a flow control block")
    public double getAverageTimeBlocked() {
        return this.num_blockings == 0 ? 0.0 : (double)this.total_time_blocking / (double)this.num_blockings;
    }

    @ManagedAttribute(description="Number of credit requests received")
    public int getNumberOfCreditRequestsReceived() {
        return this.num_credit_requests_received;
    }

    @ManagedAttribute(description="Number of credit requests sent")
    public int getNumberOfCreditRequestsSent() {
        return this.num_credit_requests_sent;
    }

    @ManagedAttribute(description="Number of credit responses received")
    public int getNumberOfCreditResponsesReceived() {
        return this.num_credit_responses_received;
    }

    @ManagedAttribute(description="Number of credit responses sent")
    public int getNumberOfCreditResponsesSent() {
        return this.num_credit_responses_sent;
    }

    @ManagedOperation(description="Print sender credits")
    public String printSenderCredits() {
        return FC.printMap(this.sent);
    }

    @ManagedOperation(description="Print receiver credits")
    public String printReceiverCredits() {
        return FC.printMap(this.received);
    }

    @ManagedOperation(description="Print credits")
    public String printCredits() {
        StringBuilder sb = new StringBuilder();
        sb.append("senders:\n").append(FC.printMap(this.sent)).append("\n\nreceivers:\n").append(FC.printMap(this.received));
        return sb.toString();
    }

    @Override
    public Map<String, Object> dumpStats() {
        Map<String, Object> retval = super.dumpStats();
        retval.put("senders", FC.printMap(this.sent));
        retval.put("receivers", FC.printMap(this.received));
        return retval;
    }

    @ManagedOperation(description="Print last blocking times")
    public String showLastBlockingTimes() {
        return this.last_blockings.toString();
    }

    private long getMaxBlockTime(long length) {
        if (this.max_block_times == null) {
            return 0L;
        }
        Long retval = null;
        for (Map.Entry<Long, Long> entry : this.max_block_times.entrySet()) {
            retval = entry.getValue();
            if (length > entry.getKey()) continue;
            break;
        }
        return retval != null ? retval : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Unblock a sender")
    public void unblock() {
        this.sent_lock.lock();
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("unblocking the sender and replenishing all members, creditors are " + this.creditors);
            }
            for (Map.Entry<Address, Long> entry : this.sent.entrySet()) {
                entry.setValue(this.max_credits);
            }
            this.lowest_credit = FC.computeLowestCredit(this.sent);
            this.creditors.clear();
            this.credits_available.signalAll();
        }
        finally {
            this.sent_lock.unlock();
        }
    }

    @Override
    public void init() throws Exception {
        boolean min_credits_set;
        boolean bl = min_credits_set = this.min_credits != 0L;
        if (!min_credits_set) {
            this.min_credits = (long)((double)this.max_credits * this.min_threshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        super.start();
        if (!this.frag_size_received) {
            this.log.warn("No fragmentation protocol was found. When flow control (e.g. FC or SFC) is used, we recommend a fragmentation protocol, due to http://jira.jboss.com/jira/browse/JGRP-590");
        }
        this.sent_lock.lock();
        try {
            this.running = true;
            this.lowest_credit = this.max_credits;
        }
        finally {
            this.sent_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        this.sent_lock.lock();
        try {
            this.running = false;
            this.ignore_thread.set(false);
            this.credits_available.signalAll();
        }
        finally {
            this.sent_lock.unlock();
        }
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                return this.handleDownMessage(evt);
            }
            case 56: {
                this.handleConfigEvent((Map)evt.getArg());
                break;
            }
            case 6: {
                this.handleViewChange(((View)evt.getArg()).getMembers());
            }
        }
        return this.down_prot.down(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                FcHeader hdr = (FcHeader)msg.getHeader(this.name);
                if (hdr != null) {
                    switch (hdr.type) {
                        case 1: {
                            ++this.num_credit_responses_received;
                            this.handleCredit(msg.getSrc(), (Number)msg.getObject());
                            break;
                        }
                        case 2: {
                            ++this.num_credit_requests_received;
                            Address sender = msg.getSrc();
                            Long sent_credits = (Long)msg.getObject();
                            this.handleCreditRequest(this.received, this.received_lock, sender, sent_credits);
                            break;
                        }
                        default: {
                            this.log.error("header type " + hdr.type + " not known");
                        }
                    }
                    return null;
                }
                Address sender = msg.getSrc();
                long new_credits = this.adjustCredit(this.received, this.received_lock, sender, msg.getLength());
                if (this.ignore_synchronous_response) {
                    this.ignore_thread.set(true);
                }
                try {
                    Object object = this.up_prot.up(evt);
                    return object;
                }
                finally {
                    if (this.ignore_synchronous_response) {
                        this.ignore_thread.set(false);
                    }
                    if (new_credits > 0L) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("sending " + new_credits + " credits to " + sender);
                        }
                        this.sendCredit(sender, new_credits);
                    }
                }
            }
            case 6: {
                this.handleViewChange(((View)evt.getArg()).getMembers());
                break;
            }
            case 56: {
                Map map = (Map)evt.getArg();
                this.handleConfigEvent(map);
            }
        }
        return this.up_prot.up(evt);
    }

    private void handleConfigEvent(Map<String, Object> info) {
        Integer frag_size;
        if (info != null && (frag_size = (Integer)info.get("frag_size")) != null) {
            if ((long)frag_size.intValue() > this.max_credits) {
                this.log.warn("The fragmentation size of the fragmentation protocol is " + frag_size + ", which is greater than the max credits. While this is not incorrect, " + "it may lead to long blockings. Frag size should be less than max_credits " + "(http://jira.jboss.com/jira/browse/JGRP-590)");
            }
            this.frag_size_received = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object handleDownMessage(Event evt) {
        long tmp;
        Message msg = (Message)evt.getArg();
        int length = msg.getLength();
        Address dest = msg.getDest();
        if (this.max_block_times != null && (tmp = this.getMaxBlockTime(length)) > 0L) {
            end_time.set(System.currentTimeMillis() + tmp);
        }
        this.sent_lock.lock();
        try {
            if ((long)length > this.lowest_credit) {
                if (this.ignore_synchronous_response && this.ignore_thread.get().booleanValue()) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("bypassing blocking to avoid deadlocking " + Thread.currentThread());
                    }
                } else {
                    long block_time;
                    this.determineCreditors(dest, length);
                    long start_blocking = System.currentTimeMillis();
                    ++this.num_blockings;
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Starting blocking. lowest_credit=" + this.lowest_credit + "; msg length =" + length);
                    }
                    while ((long)length > this.lowest_credit && this.running) {
                        try {
                            boolean rc;
                            Long tmp2;
                            block_time = this.max_block_time;
                            if (this.max_block_times != null && (tmp2 = end_time.get()) != null) {
                                block_time = tmp2 - start_blocking;
                            }
                            if ((rc = this.credits_available.await(block_time, TimeUnit.MILLISECONDS)) || (long)length <= this.lowest_credit || !this.running || !rc && this.max_block_times != null) break;
                            long wait_time = System.currentTimeMillis() - this.last_credit_request;
                            if (wait_time < this.max_block_time) continue;
                            this.last_credit_request = System.currentTimeMillis();
                            HashMap<Address, Long> sent_copy = new HashMap<Address, Long>(this.sent);
                            sent_copy.keySet().retainAll(this.creditors);
                            this.sent_lock.unlock();
                            try {
                                for (Map.Entry entry : sent_copy.entrySet()) {
                                    this.sendCreditRequest((Address)entry.getKey(), (Long)entry.getValue());
                                }
                            }
                            finally {
                                this.sent_lock.lock();
                            }
                        }
                        catch (InterruptedException e) {}
                    }
                    block_time = System.currentTimeMillis() - start_blocking;
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("total time blocked: " + block_time + " ms");
                    }
                    this.total_time_blocking += block_time;
                    this.last_blockings.add(block_time);
                }
            }
            if ((tmp = this.decrementCredit(this.sent, dest, length)) != -1L) {
                this.lowest_credit = Math.min(tmp, this.lowest_credit);
            }
        }
        finally {
            this.sent_lock.unlock();
        }
        return this.down_prot.down(evt);
    }

    private void determineCreditors(Address dest, int length) {
        boolean multicast;
        boolean bl = multicast = dest == null || dest.isMulticastAddress();
        if (multicast) {
            for (Map.Entry<Address, Long> entry : this.sent.entrySet()) {
                Address mbr = entry.getKey();
                Long credits = entry.getValue();
                if (credits > (long)length) continue;
                this.creditors.add(mbr);
            }
        } else {
            Long credits = this.sent.get(dest);
            if (credits != null && credits <= (long)length) {
                this.creditors.add(dest);
            }
        }
    }

    private long decrementCredit(Map<Address, Long> m, Address dest, long credits) {
        boolean multicast = dest == null || dest.isMulticastAddress();
        long lowest = this.max_credits;
        if (multicast) {
            if (m.isEmpty()) {
                return -1L;
            }
            for (Map.Entry<Address, Long> entry : m.entrySet()) {
                Long val = entry.getValue();
                long new_credit = val - credits;
                entry.setValue(new_credit);
                lowest = Math.min(new_credit, lowest);
            }
            return lowest;
        }
        Long val = m.get(dest);
        if (val != null) {
            lowest = val;
            m.put(dest, lowest -= credits);
            if (this.log.isTraceEnabled()) {
                this.log.trace("sender " + dest + " minus " + credits + " credits, " + lowest + " remaining");
            }
            return lowest;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCredit(Address sender, Number increase) {
        if (sender == null) {
            return;
        }
        StringBuilder sb = null;
        this.sent_lock.lock();
        try {
            Long old_credit = this.sent.get(sender);
            if (old_credit == null) {
                return;
            }
            Long new_credit = Math.min(this.max_credits, old_credit + increase.longValue());
            if (this.log.isTraceEnabled()) {
                sb = new StringBuilder();
                sb.append("received credit from ").append(sender).append(", old credit was ").append(old_credit).append(", new credits are ").append(new_credit).append(".\nCreditors before are: ").append(this.creditors);
            }
            this.sent.put(sender, new_credit);
            this.lowest_credit = FC.computeLowestCredit(this.sent);
            if (!this.creditors.isEmpty()) {
                this.creditors.remove(sender);
                if (this.log.isTraceEnabled()) {
                    sb.append("\nCreditors after removal of ").append(sender).append(" are: ").append(this.creditors);
                    this.log.trace(sb);
                }
            }
            if (this.creditors.isEmpty()) {
                this.credits_available.signalAll();
            }
        }
        finally {
            this.sent_lock.unlock();
        }
    }

    private static long computeLowestCredit(Map<Address, Long> m) {
        Collection<Long> credits = m.values();
        return Collections.min(credits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long adjustCredit(Map<Address, Long> map, Lock lock, Address sender, int length) {
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("src is null");
            }
            return 0L;
        }
        if (length == 0) {
            return 0L;
        }
        lock.lock();
        try {
            long remaining_cred = this.decrementCredit(map, sender, length);
            if (this.log.isTraceEnabled()) {
                this.log.trace("sender " + sender + " minus " + length + " credits, " + remaining_cred + " remaining");
            }
            if (remaining_cred == -1L) {
                long l = 0L;
                return l;
            }
            long credit_response = this.max_credits - remaining_cred;
            if (credit_response >= this.min_credits) {
                map.put(sender, this.max_credits);
                long l = credit_response;
                return l;
            }
        }
        finally {
            lock.unlock();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCreditRequest(Map<Address, Long> map, Lock lock, Address sender, Long left_credits) {
        if (sender == null) {
            return;
        }
        long credit_response = 0L;
        lock.lock();
        try {
            Long old_credit = map.get(sender);
            if (old_credit != null) {
                credit_response = Math.min(this.max_credits, this.max_credits - old_credit);
            }
            if (credit_response > 0L) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("received credit request from " + sender + ": sending " + credit_response + " credits");
                }
                map.put(sender, this.max_credits);
                this.pending_requesters.remove(sender);
            } else if (this.pending_requesters.contains(sender)) {
                long credits_left = Math.max(0L, left_credits);
                credit_response = this.max_credits - credits_left;
                map.put(sender, this.max_credits);
                this.pending_requesters.remove(sender);
                if (this.log.isWarnEnabled()) {
                    this.log.warn("Received two credit requests from " + sender + " without any intervening messages; sending " + credit_response + " credits");
                }
            } else {
                this.pending_requesters.add(sender);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("received credit request from " + sender + " but have no credits available");
                }
            }
        }
        finally {
            lock.unlock();
        }
        if (credit_response > 0L) {
            this.sendCredit(sender, credit_response);
        }
    }

    private void sendCredit(Address dest, long credit) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("replentished " + dest + " with " + credit + " credits");
        }
        Number number = credit < Integer.MAX_VALUE ? (Number)((int)credit) : (Number)credit;
        Message msg = new Message(dest, null, number);
        msg.setFlag((byte)1);
        msg.putHeader(this.name, REPLENISH_HDR);
        this.down_prot.down(new Event(1, msg));
        ++this.num_credit_responses_sent;
    }

    private void sendCreditRequest(Address dest, Long credits_left) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("sending credit request to " + dest);
        }
        Message msg = new Message(dest, null, credits_left);
        msg.putHeader(this.name, CREDIT_REQUEST_HDR);
        this.down_prot.down(new Event(1, msg));
        ++this.num_credit_requests_sent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleViewChange(Vector<Address> mbrs) {
        if (mbrs == null) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("new membership: " + mbrs);
        }
        this.sent_lock.lock();
        this.received_lock.lock();
        try {
            Address addr;
            for (int i = 0; i < mbrs.size(); ++i) {
                addr = mbrs.elementAt(i);
                if (!this.received.containsKey(addr)) {
                    this.received.put(addr, this.max_credits);
                }
                if (this.sent.containsKey(addr)) continue;
                this.sent.put(addr, this.max_credits);
            }
            Iterator<Address> it = this.received.keySet().iterator();
            while (it.hasNext()) {
                addr = it.next();
                if (mbrs.contains(addr)) continue;
                it.remove();
            }
            it = this.sent.keySet().iterator();
            while (it.hasNext()) {
                addr = it.next();
                if (mbrs.contains(addr)) continue;
                it.remove();
            }
            it = this.creditors.iterator();
            while (it.hasNext()) {
                Address creditor = it.next();
                if (mbrs.contains(creditor)) continue;
                it.remove();
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("creditors are " + this.creditors);
            }
            if (this.creditors.isEmpty()) {
                this.lowest_credit = FC.computeLowestCredit(this.sent);
                this.credits_available.signalAll();
            }
        }
        finally {
            this.sent_lock.unlock();
            this.received_lock.unlock();
        }
    }

    private static String printMap(Map<Address, Long> m) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Address, Long> entry : m.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    public static class FcHeader
    extends Header
    implements Streamable {
        public static final byte REPLENISH = 1;
        public static final byte CREDIT_REQUEST = 2;
        byte type = 1;
        private static final long serialVersionUID = 8226510881574318828L;

        public FcHeader() {
        }

        public FcHeader(byte type) {
            this.type = type;
        }

        public int size() {
            return 1;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "REPLENISH";
                }
                case 2: {
                    return "CREDIT_REQUEST";
                }
            }
            return "<invalid type>";
        }
    }
}

