/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.jgroups.ChannelException;
import org.jgroups.conf.ClassMap;
import org.jgroups.conf.MagicNumberReader;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.Util;

public class ClassConfigurator {
    private static final short MIN_CUSTOM_MAGIC_NUMBER = 1024;
    private static final Map<Class, Short> classMap = new ConcurrentHashMap<Class, Short>();
    private static final Map<Short, Class> magicMap = new ConcurrentHashMap<Short, Class>();
    protected static final Log log = LogFactory.getLog(ClassConfigurator.class);

    protected static void init() throws ChannelException {
        try {
            Util.loadClass("javax.xml.parsers.DocumentBuilderFactory", ClassConfigurator.class);
            MagicNumberReader reader = new MagicNumberReader();
            try {
                String mnfile = Util.getProperty(new String[]{"jgroups.conf.magic_number_file", "org.jgroups.conf.magicNumberFile"}, null, null, false, null);
                if (mnfile != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Using " + mnfile + " as magic number file");
                    }
                    reader.setFilename(mnfile);
                }
            }
            catch (SecurityException ex) {
                // empty catch block
            }
            ClassMap[] mapping = reader.readMagicNumberMapping();
            if (mapping != null) {
                for (int i = 0; i < mapping.length; ++i) {
                    Short m = new Short(mapping[i].getMagicNumber());
                    try {
                        Class clazz = mapping[i].getClassForMap();
                        if (magicMap.containsKey(m)) {
                            throw new ChannelException("magic key " + m + " (" + clazz.getName() + ')' + " is already in map; please make sure that " + "all magic keys are unique");
                        }
                        magicMap.put(m, clazz);
                        classMap.put(clazz, m);
                        continue;
                    }
                    catch (ClassNotFoundException cnf) {
                        throw new ChannelException("failed loading class", cnf);
                    }
                }
            }
        }
        catch (ChannelException ex) {
            throw ex;
        }
        catch (Throwable x) {
            throw new ChannelException("failed reading the magic number mapping file", x);
        }
    }

    public static void add(short magic, Class clazz) throws IllegalArgumentException {
        if (magic <= 1024) {
            throw new IllegalArgumentException("magic number (" + magic + ") needs to be greater than " + 1024);
        }
        if (magicMap.containsKey(magic) || classMap.containsKey(clazz)) {
            throw new IllegalArgumentException("magic number " + magic + " for class " + clazz.getName() + " is already present");
        }
        magicMap.put(magic, clazz);
        classMap.put(clazz, magic);
    }

    public static Class get(short magic) {
        return magicMap.get(magic);
    }

    public static Class get(String clazzname) {
        try {
            return Util.loadClass(clazzname, ClassConfigurator.class);
        }
        catch (Exception x) {
            if (log.isErrorEnabled()) {
                log.error("failed loading class " + clazzname, x);
            }
            return null;
        }
    }

    public static short getMagicNumber(Class clazz) {
        Short i = classMap.get(clazz);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public String toString() {
        return ClassConfigurator.printMagicMap();
    }

    public static String printMagicMap() {
        StringBuilder sb = new StringBuilder();
        TreeSet<Short> keys = new TreeSet<Short>(magicMap.keySet());
        for (Short key : keys) {
            sb.append(key).append(":\t").append(magicMap.get(key)).append('\n');
        }
        return sb.toString();
    }

    public static String printClassMap() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Class, Short> entry : classMap.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append('\n');
        }
        return sb.toString();
    }

    static {
        try {
            ClassConfigurator.init();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

