/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.AttributeName;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.internal.BiVariableMap;

public class LocalContext {
    private RubyInstanceConfig config;
    private LocalVariableBehavior behavior;
    private Ruby runtime = null;
    private BiVariableMap varMap = null;
    private HashMap attribute;
    boolean initialized = false;

    public LocalContext(RubyInstanceConfig config, LocalVariableBehavior behavior) {
        this.initialize(config, behavior);
    }

    private void initialize(RubyInstanceConfig config, LocalVariableBehavior behavior) {
        this.config = config;
        this.behavior = behavior;
        this.attribute = new HashMap();
        this.attribute.put(AttributeName.READER, new InputStreamReader(System.in));
        this.attribute.put(AttributeName.WRITER, new PrintWriter(System.out, true));
        this.attribute.put(AttributeName.ERROR_WRITER, new PrintWriter(System.err, true));
    }

    public Ruby getRuntime() {
        if (this.runtime == null) {
            this.runtime = Ruby.newInstance(this.config);
            this.initialized = true;
        }
        return this.runtime;
    }

    public BiVariableMap getVarMap() {
        if (this.varMap == null) {
            this.varMap = new BiVariableMap(this.getRuntime(), this.behavior);
        }
        return this.varMap;
    }

    public HashMap getAttributeMap() {
        return this.attribute;
    }
}

