/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.WeakHashMap;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.apache.jackrabbit.api.jsr283.observation.EventJournal;
import org.apache.jackrabbit.core.cluster.ChangeLogRecord;
import org.apache.jackrabbit.core.cluster.ClusterRecord;
import org.apache.jackrabbit.core.cluster.ClusterRecordDeserializer;
import org.apache.jackrabbit.core.cluster.ClusterRecordProcessor;
import org.apache.jackrabbit.core.cluster.LockRecord;
import org.apache.jackrabbit.core.cluster.NamespaceRecord;
import org.apache.jackrabbit.core.cluster.NodeTypeRecord;
import org.apache.jackrabbit.core.cluster.WorkspaceRecord;
import org.apache.jackrabbit.core.journal.Journal;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;
import org.apache.jackrabbit.core.journal.RecordIterator;
import org.apache.jackrabbit.core.observation.EventFilter;
import org.apache.jackrabbit.core.observation.FilteredEventIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventJournalImpl
implements EventJournal {
    private static final Logger log;
    private static final int MIN_BUFFER_SIZE = 1024;
    private static final Map REVISION_SKIP_MAPS;
    private Long lastRevision;
    private final EventFilter filter;
    private final Journal journal;
    private final String producerId;
    private final String wspName;
    private final List eventBundleBuffer = new LinkedList();
    private long position;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EventJournalImpl(EventFilter filter, Journal journal, String producerId) {
        this.filter = filter;
        this.journal = journal;
        this.producerId = producerId;
        this.wspName = filter.getSession().getWorkspace().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipTo(long date) {
        SortedMap skipMap;
        long time = System.currentTimeMillis();
        SortedMap sortedMap = skipMap = this.getSkipMap();
        synchronized (sortedMap) {
            SortedMap head = skipMap.headMap(new Long(time));
            if (!head.isEmpty()) {
                this.eventBundleBuffer.clear();
                this.lastRevision = (Long)head.get(head.lastKey());
            }
        }
        try {
            while (this.hasNext()) {
                EventBundle bundle = this.getCurrentBundle();
                if (bundle.timestamp <= date) {
                    this.eventBundleBuffer.remove(0);
                    continue;
                }
                break;
            }
        }
        finally {
            time = System.currentTimeMillis() - time;
            log.debug("Skipped event bundles in {} ms.", (Object)new Long(time));
        }
    }

    public Event nextEvent() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        EventBundle bundle = this.getCurrentBundle();
        if (!($assertionsDisabled || bundle != null && bundle.events.hasNext())) {
            throw new AssertionError();
        }
        Event next = (Event)bundle.events.next();
        if (!bundle.events.hasNext()) {
            this.eventBundleBuffer.remove(0);
        }
        ++this.position;
        return next;
    }

    public Calendar getDate() {
        throw new RuntimeException("Not implemented yet, see JCR-2086");
    }

    public void skip(long skipNum) {
        while (skipNum-- > 0L) {
            this.nextEvent();
        }
    }

    public long getSize() {
        return -1L;
    }

    public long getPosition() {
        return this.position;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext() {
        if (!this.eventBundleBuffer.isEmpty()) {
            return true;
        }
        this.refill();
        return !this.eventBundleBuffer.isEmpty();
    }

    public Object next() {
        return this.nextEvent();
    }

    private EventBundle getCurrentBundle() {
        while (!this.eventBundleBuffer.isEmpty()) {
            EventBundle bundle = (EventBundle)this.eventBundleBuffer.get(0);
            if (bundle.events.hasNext()) {
                return bundle;
            }
            this.eventBundleBuffer.remove(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refill() {
        block13: {
            if (!$assertionsDisabled && !this.eventBundleBuffer.isEmpty()) {
                throw new AssertionError();
            }
            try {
                RecordIterator records;
                RecordProcessor processor = new RecordProcessor();
                ClusterRecordDeserializer deserializer = new ClusterRecordDeserializer();
                if (this.lastRevision != null) {
                    log.debug("refilling event bundle buffer starting at revision {}", (Object)this.lastRevision);
                    records = this.journal.getRecords(this.lastRevision);
                } else {
                    log.debug("refilling event bundle buffer starting at journal beginning");
                    records = this.journal.getRecords();
                }
                try {
                    while (processor.getNumEvents() < 1024 && records.hasNext()) {
                        ClusterRecord cr;
                        Record record = records.nextRecord();
                        if (!record.getProducerId().equals(this.producerId) || !this.wspName.equals((cr = deserializer.deserialize(record)).getWorkspace())) continue;
                        cr.process(processor);
                        this.lastRevision = new Long(cr.getRevision());
                    }
                    if (processor.getNumEvents() < 1024) break block13;
                    SortedMap skipMap = this.getSkipMap();
                    Long timestamp = new Long(processor.getLastTimestamp());
                    SortedMap sortedMap = skipMap;
                    synchronized (sortedMap) {
                        if (log.isDebugEnabled()) {
                            DateFormat df = DateFormat.getDateTimeInstance();
                            log.debug("remember record in skip map: {} -> {}", (Object)df.format(new Date(timestamp)), (Object)this.lastRevision);
                        }
                        skipMap.put(timestamp, this.lastRevision);
                    }
                }
                finally {
                    records.close();
                }
            }
            catch (JournalException e) {
                log.warn("Unable to read journal records", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedMap getSkipMap() {
        Map map = REVISION_SKIP_MAPS;
        synchronized (map) {
            TreeMap map2 = (TreeMap)REVISION_SKIP_MAPS.get(this.journal);
            if (map2 == null) {
                map2 = new TreeMap();
                REVISION_SKIP_MAPS.put(this.journal, map2);
            }
            return map2;
        }
    }

    static {
        $assertionsDisabled = !EventJournalImpl.class.desiredAssertionStatus();
        log = LoggerFactory.getLogger((Class)EventJournalImpl.class);
        REVISION_SKIP_MAPS = new WeakHashMap();
    }

    private static final class EventBundle {
        final EventIterator events;
        final long timestamp;

        private EventBundle(List eventStates, long timestamp, String userData, EventFilter filter) {
            this.events = new FilteredEventIterator(eventStates.iterator(), timestamp, userData, filter, Collections.EMPTY_SET);
            this.timestamp = timestamp;
        }
    }

    private class RecordProcessor
    implements ClusterRecordProcessor {
        private int numEvents;
        private long lastTimestamp;

        private RecordProcessor() {
        }

        private int getNumEvents() {
            return this.numEvents;
        }

        private long getLastTimestamp() {
            return this.lastTimestamp;
        }

        public void process(ChangeLogRecord record) {
            List events = record.getEvents();
            if (!events.isEmpty()) {
                EventBundle bundle = new EventBundle(events, record.getTimestamp(), record.getUserData(), EventJournalImpl.this.filter);
                if (bundle.events.hasNext()) {
                    EventJournalImpl.this.eventBundleBuffer.add(bundle);
                    this.numEvents += events.size();
                    this.lastTimestamp = record.getTimestamp();
                }
            }
        }

        public void process(LockRecord record) {
        }

        public void process(NamespaceRecord record) {
        }

        public void process(NodeTypeRecord record) {
        }

        public void process(WorkspaceRecord record) {
        }
    }
}

