/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data.db;

import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.db.DbDataStore;
import org.apache.jackrabbit.core.persistence.bundle.util.ConnectionRecoveryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbyDataStore
extends DbDataStore {
    private static Logger log = LoggerFactory.getLogger((Class)DerbyDataStore.class);

    public synchronized void close() throws DataStoreException {
        super.close();
        if (!"org.apache.derby.jdbc.EmbeddedDriver".equals(this.getDriver())) {
            return;
        }
        try {
            ConnectionRecoveryManager connectionManager = this.getConnection();
            String url = connectionManager.getConnection().getMetaData().getURL();
            int pos = url.lastIndexOf(59);
            if (pos != -1) {
                url = url.substring(0, pos);
            }
            url = url + ";shutdown=true";
            connectionManager.getConnection().setAutoCommit(true);
            super.close();
            try {
                DriverManager.getConnection(url);
            }
            catch (SQLException e) {
                log.info(e.getMessage());
            }
        }
        catch (Exception e) {
            throw new DataStoreException(e);
        }
    }
}

