/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyModule$PyExposer;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.PyType;
import org.python.core.imp;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="module")
public class PyModule
extends PyObject {
    private final PyObject moduleDoc = new PyString("module(name[, doc])\n\nCreate a module object.\nThe name must be a string; the optional doc argument can have any type.");
    public PyObject __dict__;

    public PyModule() {
    }

    public PyModule(PyType subType) {
        super(subType);
    }

    public PyModule(PyType subType, String name) {
        super(subType);
        this.module___init__(new PyString(name), Py.None);
    }

    public PyModule(String name) {
        this(name, null);
    }

    public PyModule(String name, PyObject dict) {
        this.__dict__ = dict;
        this.module___init__(new PyString(name), Py.None);
    }

    @ExposedNew
    final void module___init__(PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("__init__", args, keywords, new String[]{"name", "doc"});
        PyObject name = ap.getPyObject(0);
        PyObject docs = ap.getPyObject(1, Py.None);
        this.module___init__(name, docs);
    }

    private void module___init__(PyObject name, PyObject doc) {
        this.ensureDict();
        this.__dict__.__setitem__("__name__", name);
        this.__dict__.__setitem__("__doc__", doc);
    }

    public PyObject fastGetDict() {
        return this.__dict__;
    }

    public PyObject getDict() {
        return this.__dict__;
    }

    public void setDict(PyObject newDict) {
        throw Py.TypeError("readonly attribute");
    }

    public void delDict() {
        throw Py.TypeError("readonly attribute");
    }

    public PyObject getDoc() {
        PyObject doc;
        PyObject dict = this.fastGetDict();
        if (dict != null && (doc = dict.__finditem__("__doc__")) != null) {
            return doc;
        }
        return this.moduleDoc;
    }

    protected PyObject impAttr(String name) {
        PyObject path = this.__dict__.__finditem__("__path__");
        PyObject pyName = this.__dict__.__finditem__("__name__");
        if (path == null || pyName == null) {
            return null;
        }
        PyObject attr = null;
        String fullName = (pyName.__str__().toString() + '.' + name).intern();
        if (path != Py.None) {
            if (path instanceof PyList) {
                attr = imp.find_module(name, fullName, (PyList)path);
            } else {
                throw Py.TypeError("__path__ must be list or None");
            }
        }
        if (attr == null) {
            attr = PySystemState.packageManager.lookupName(fullName);
        }
        if (attr != null) {
            PyObject found = Py.getSystemState().modules.__finditem__(fullName);
            if (found != null) {
                attr = found;
            }
            this.__dict__.__setitem__(name, attr);
            return attr;
        }
        return null;
    }

    public void __setattr__(String name, PyObject value) {
        this.module___setattr__(name, value);
    }

    final void module___setattr__(String name, PyObject value) {
        if (name != "__dict__") {
            this.ensureDict();
        }
        super.__setattr__(name, value);
    }

    public void __delattr__(String name) {
        this.module___delattr__(name);
    }

    final void module___delattr__(String name) {
        super.__delattr__(name);
    }

    public String toString() {
        return this.module_toString();
    }

    final String module_toString() {
        PyObject name = null;
        PyObject filename = null;
        if (this.__dict__ != null) {
            name = this.__dict__.__finditem__("__name__");
            filename = this.__dict__.__finditem__("__file__");
        }
        if (name == null) {
            name = new PyString("?");
        }
        if (filename == null) {
            return String.format("<module '%s' (built-in)>", name);
        }
        return String.format("<module '%s' from '%s'>", name, filename);
    }

    public PyObject __dir__() {
        if (this.__dict__ == null) {
            throw Py.TypeError("module.__dict__ is not a dictionary");
        }
        return this.__dict__.invoke("keys");
    }

    private void ensureDict() {
        if (this.__dict__ == null) {
            this.__dict__ = new PyStringMap();
        }
    }

    static {
        PyType.addBuilder(PyModule.class, new PyModule$PyExposer());
    }
}

