/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.extractor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.util.ClassUtils;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.extractor.GlassfishNativeHibernateJpaExtractor;
import org.compass.gps.device.jpa.extractor.JBossNativeJpaExtractor;
import org.compass.gps.device.jpa.extractor.NativeJpaExtractor;
import org.compass.gps.device.jpa.extractor.OpenEjbNativeJpaExtractor;
import org.compass.gps.device.jpa.extractor.SpringNativeJpaExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NativeJpaHelper {
    private static final Log log = LogFactory.getLog(NativeJpaHelper.class);
    private static final NativeJpaExtractor[] extractors;

    public static <T> T detectNativeJpa(EntityManagerFactory emf, NativeJpaCallback<T> callback) throws JpaGpsDeviceException {
        EntityManagerFactory nativeEmf = NativeJpaHelper.extractNativeJpa(emf);
        Set interfaces = ClassUtils.getAllInterfacesAsSet(nativeEmf);
        HashSet<String> interfacesAsStrings = new HashSet<String>();
        for (Object anInterface : interfaces) {
            interfacesAsStrings.add(((Class)anInterface).getName());
        }
        interfacesAsStrings.add(nativeEmf.getClass().getName());
        T retVal = interfacesAsStrings.contains("org.hibernate.ejb.HibernateEntityManagerFactory") ? callback.onHibernate() : (interfacesAsStrings.contains("oracle.toplink.essentials.internal.ejb.cmp3.EntityManagerFactoryImpl") ? callback.onTopLinkEssentials() : (interfacesAsStrings.contains("org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl") ? callback.onEclipseLink() : (interfacesAsStrings.contains("org.apache.openjpa.persistence.OpenJPAEntityManagerFactory") ? callback.onOpenJPA() : callback.onUnknown())));
        return retVal;
    }

    public static EntityManagerFactory extractNativeJpa(EntityManagerFactory emf) {
        if (extractors.length == 0) {
            return emf;
        }
        EntityManagerFactory nativeEmf = emf;
        do {
            emf = nativeEmf;
            for (NativeJpaExtractor extractor : extractors) {
                nativeEmf = extractor.extractNative(nativeEmf);
            }
        } while (nativeEmf != emf);
        return nativeEmf;
    }

    public static EntityManager extractNativeJpa(EntityManager em) {
        if (extractors.length == 0) {
            return em;
        }
        EntityManager nativeEm = em;
        while (true) {
            Object delegate;
            if ((delegate = nativeEm.getDelegate()) != nativeEm && delegate instanceof EntityManager) {
                nativeEm = (EntityManager)delegate;
                continue;
            }
            em = nativeEm;
            for (NativeJpaExtractor extractor : extractors) {
                nativeEm = extractor.extractNative(nativeEm);
            }
            if (nativeEm == em) break;
        }
        return nativeEm;
    }

    static {
        ArrayList<NativeJpaExtractor> extractorsList = new ArrayList<NativeJpaExtractor>();
        try {
            ClassUtils.forName("org.springframework.orm.jpa.EntityManagerFactoryInfo", NativeJpaHelper.class.getClassLoader());
            extractorsList.add(new SpringNativeJpaExtractor());
        }
        catch (ClassNotFoundException e) {
        }
        catch (Throwable t) {
            log.warn((Object)"Faiiled to regsiter Spring native JPA extractor", t);
        }
        try {
            ClassUtils.forName("org.apache.openejb.persistence.JtaEntityManager", NativeJpaHelper.class.getClassLoader());
            extractorsList.add(new OpenEjbNativeJpaExtractor());
        }
        catch (ClassNotFoundException e) {
        }
        catch (Throwable t) {
            log.warn((Object)"Faiiled to regsiter OpenEJB native JPA extractor", t);
        }
        try {
            ClassUtils.forName("org.jboss.ejb3.entity.InjectedEntityManagerFactory", NativeJpaHelper.class.getClassLoader());
            extractorsList.add(new JBossNativeJpaExtractor());
        }
        catch (ClassNotFoundException e) {
        }
        catch (Throwable t) {
            log.warn((Object)"Faiiled to regsiter JBoss native JPA extractor", t);
        }
        try {
            ClassUtils.forName("com.sun.enterprise.util.EntityManagerFactoryWrapper", NativeJpaHelper.class.getClassLoader());
            extractorsList.add(new GlassfishNativeHibernateJpaExtractor());
        }
        catch (ClassNotFoundException e) {
        }
        catch (Throwable t) {
            log.warn((Object)"Faiiled to regsiter Glassfish native JPA extractor", t);
        }
        extractors = extractorsList.toArray(new NativeJpaExtractor[extractorsList.size()]);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using native JPA extractors " + Arrays.toString(extractors)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface NativeJpaCallback<T> {
        public T onHibernate();

        public T onTopLinkEssentials();

        public T onOpenJPA();

        public T onEclipseLink();

        public T onUnknown();
    }
}

