/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jdbc.dialect;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.sql.DataSource;
import org.apache.lucene.store.jdbc.JdbcStoreException;
import org.compass.gps.device.jdbc.JdbcUtils;
import org.compass.gps.device.jdbc.dialect.DefaultJdbcDialect;
import org.compass.gps.device.jdbc.dialect.JdbcDialect;
import org.compass.gps.device.jdbc.dialect.OracleJdbcDialect;

public class DialectResolver {
    private LinkedList<DatabaseMetaDataToDialectMapper> mappers = new LinkedList();

    public DialectResolver() {
        this(true);
    }

    public DialectResolver(boolean useDefaultMappers) {
        if (!useDefaultMappers) {
            return;
        }
        this.mappers.add(new DatabaseNameToDialectMapper("HSQL Database Engine", DefaultJdbcDialect.class));
        this.mappers.add(new DatabaseNameToDialectMapper("DB2/NT", DefaultJdbcDialect.class));
        this.mappers.add(new DatabaseNameToDialectMapper("MySQL", DefaultJdbcDialect.class));
        this.mappers.add(new DatabaseNameToDialectMapper("PostgreSQL", DefaultJdbcDialect.class));
        this.mappers.add(new DatabaseNameStartsWithToDialectMapper("Microsoft SQL Server", DefaultJdbcDialect.class));
        this.mappers.add(new DatabaseNameToDialectMapper("Sybase SQL Server", DefaultJdbcDialect.class));
        this.mappers.add(new DatabaseNameAndVersionToDialectMapper("Oracle", 8, OracleJdbcDialect.class));
        this.mappers.add(new DatabaseNameAndVersionToDialectMapper("Oracle", 9, OracleJdbcDialect.class));
        this.mappers.add(new DatabaseNameToDialectMapper("Oracle", OracleJdbcDialect.class));
    }

    public void addFirstMapper(DatabaseMetaDataToDialectMapper mapper) {
        this.mappers.addFirst(mapper);
    }

    public void addLastMapper(DatabaseMetaDataToDialectMapper mapper) {
        this.mappers.addLast(mapper);
    }

    public JdbcDialect getDialect(DataSource dataSource) throws JdbcStoreException {
        String driverName;
        int databaseMinorVersion;
        int databaseMajorVersion;
        String databaseName;
        Connection conn = JdbcUtils.getConnection(dataSource);
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            databaseName = metaData.getDatabaseProductName();
            databaseMajorVersion = metaData.getDatabaseMajorVersion();
            databaseMinorVersion = metaData.getDatabaseMinorVersion();
            driverName = metaData.getDriverName();
            for (DatabaseMetaDataToDialectMapper mapper : this.mappers) {
                Class<? extends JdbcDialect> dialectClass = mapper.getDialect(metaData);
                if (dialectClass == null) continue;
                JdbcDialect jdbcDialect = dialectClass.newInstance();
                return jdbcDialect;
            }
        }
        catch (Exception e) {
            throw new JdbcStoreException("Failed to auto detect dialect", e);
        }
        finally {
            JdbcUtils.closeConnection(conn);
        }
        throw new JdbcStoreException("Failed to auto detect dialect, no match found for database [" + databaseName + "] version [" + databaseMajorVersion + "/" + databaseMinorVersion + "] driver [" + driverName + "]");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DatabaseNameAndVersionToDialectMapper
    implements DatabaseMetaDataToDialectMapper {
        private String databaseName;
        private Class<? extends JdbcDialect> dialect;
        private int version;

        public DatabaseNameAndVersionToDialectMapper(String databaseName, int version, Class<? extends JdbcDialect> dialect) {
            this.databaseName = databaseName;
            this.dialect = dialect;
            this.version = version;
        }

        @Override
        public Class<? extends JdbcDialect> getDialect(DatabaseMetaData metaData) throws SQLException {
            if (metaData.getDatabaseProductName().equals(this.databaseName) && metaData.getDatabaseMajorVersion() == this.version) {
                return this.dialect;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DatabaseNameStartsWithToDialectMapper
    implements DatabaseMetaDataToDialectMapper {
        private String databaseName;
        private Class<? extends JdbcDialect> dialect;

        public DatabaseNameStartsWithToDialectMapper(String databaseName, Class<? extends JdbcDialect> dialect) {
            this.databaseName = databaseName;
            this.dialect = dialect;
        }

        @Override
        public Class<? extends JdbcDialect> getDialect(DatabaseMetaData metaData) throws SQLException {
            if (metaData.getDatabaseProductName().startsWith(this.databaseName)) {
                return this.dialect;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DatabaseNameToDialectMapper
    implements DatabaseMetaDataToDialectMapper {
        private String databaseName;
        private Class<? extends JdbcDialect> dialect;

        public DatabaseNameToDialectMapper(String databaseName, Class<? extends JdbcDialect> dialect) {
            this.databaseName = databaseName;
            this.dialect = dialect;
        }

        @Override
        public Class<? extends JdbcDialect> getDialect(DatabaseMetaData metaData) throws SQLException {
            if (metaData.getDatabaseProductName().equals(this.databaseName)) {
                return this.dialect;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DatabaseMetaDataToDialectMapper {
        public Class<? extends JdbcDialect> getDialect(DatabaseMetaData var1) throws SQLException;
    }
}

