/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.xml.dom4j.converter;

import java.io.Reader;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.xsem.SupportsXmlContentWrapper;
import org.compass.core.util.StringBuilderWriter;
import org.compass.core.xml.AliasedXmlObject;
import org.compass.core.xml.XmlObject;
import org.compass.core.xml.dom4j.Dom4jAliasedXmlObject;
import org.compass.core.xml.dom4j.Dom4jXmlObject;
import org.compass.core.xml.dom4j.converter.AbstractXmlWriterXmlContentConverter;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.STAXEventReader;
import org.dom4j.io.STAXEventWriter;

public class STAXReaderXmlContentConverter
extends AbstractXmlWriterXmlContentConverter
implements SupportsXmlContentWrapper,
CompassConfigurable {
    private STAXEventReader staxEventReader;

    public void configure(CompassSettings settings) throws CompassException {
        super.configure(settings);
        this.staxEventReader = this.doCreateStaxReader(settings);
    }

    protected STAXEventReader doCreateStaxReader(CompassSettings settings) {
        return new STAXEventReader();
    }

    public boolean supports(String wrapper) {
        return !"singleton".equals(wrapper);
    }

    public AliasedXmlObject fromXml(String alias, Reader xml) throws ConversionException {
        Document doc;
        try {
            doc = this.staxEventReader.readDocument(xml);
        }
        catch (Exception e) {
            throw new ConversionException("Failed to parse alias[" + alias + "] xml[" + xml + "]", e);
        }
        return new Dom4jAliasedXmlObject(alias, (Node)doc.getRootElement());
    }

    public String toXml1(XmlObject xmlObject) throws ConversionException {
        Dom4jXmlObject dom4jXmlObject = (Dom4jXmlObject)xmlObject;
        StringBuilderWriter stringWriter = StringBuilderWriter.Cached.cached();
        try {
            STAXEventWriter xmlWriter = new STAXEventWriter((Writer)stringWriter);
            xmlWriter.writeNode(dom4jXmlObject.getNode());
        }
        catch (XMLStreamException e) {
            throw new ConversionException("Failed to write xml", e);
        }
        return stringWriter.toString();
    }
}

