/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.manager;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.compass.core.CompassException;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.manager.LuceneIndexHolder;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.transaction.context.TransactionContextCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexHoldersCache {
    private static final Log logger = LogFactory.getLog(IndexHoldersCache.class);
    public static final String CLEAR_CACHE_NAME = "clearcache";
    private final LuceneSearchEngineIndexManager indexManager;
    private final Map<String, LuceneIndexHolder> indexHolders = new ConcurrentHashMap<String, LuceneIndexHolder>();
    private volatile ScheduledFuture scheduledRefreshCacheFuture;
    private boolean cacheAsyncInvalidation;
    private long[] lastModifiled;
    private Map<String, IndexHolderCacheLock> subIndexCacheLocks = new HashMap<String, IndexHolderCacheLock>();
    private final ConcurrentMap<String, AtomicInteger> debugOpenHoldersCount;
    private final boolean debug;

    public IndexHoldersCache(LuceneSearchEngineIndexManager indexManager) {
        this.indexManager = indexManager;
        for (String subIndex : indexManager.getSubIndexes()) {
            this.subIndexCacheLocks.put(subIndex, new IndexHolderCacheLock());
        }
        this.debug = indexManager.getSearchEngineFactory().isDebug();
        this.debugOpenHoldersCount = this.debug ? new ConcurrentHashMap<String, AtomicInteger>() : null;
    }

    public void start() {
        this.cacheAsyncInvalidation = this.indexManager.getSettings().getSettings().getSettingAsBoolean("compass.engine.cacheAsyncInvalidation", true);
        long cacheInvalidationInterval = this.indexManager.getSettings().getCacheInvalidationInterval();
        if (cacheInvalidationInterval > 0L && this.cacheAsyncInvalidation) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Starting scheduled refresh cache with period [" + cacheInvalidationInterval + "ms]"));
            }
            ScheduledRefreshCacheRunnable scheduledRefreshCacheRunnable = new ScheduledRefreshCacheRunnable();
            this.scheduledRefreshCacheFuture = this.indexManager.getExecutorManager().scheduleWithFixedDelay(scheduledRefreshCacheRunnable, cacheInvalidationInterval, cacheInvalidationInterval, TimeUnit.MILLISECONDS);
        } else {
            logger.info((Object)"Not starting scheduled refresh cache");
        }
    }

    public void stop() {
        if (this.scheduledRefreshCacheFuture != null) {
            this.scheduledRefreshCacheFuture.cancel(true);
            this.scheduledRefreshCacheFuture = null;
        }
    }

    public void close() {
        if (this.indexManager.getSearchEngineFactory().isDebug()) {
            for (Map.Entry entry : this.debugOpenHoldersCount.entrySet()) {
                if (((AtomicInteger)entry.getValue()).get() <= 0) continue;
                logger.error((Object)("[CACHE HOLDER] Sub Index [" + (String)entry.getKey() + "] has [" + entry.getValue() + "] holder(s) open"));
            }
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public ConcurrentMap<String, AtomicInteger> getDebugHoldersCount() {
        return this.debugOpenHoldersCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUnderCacheLock(String subIndex, Runnable task) {
        IndexHolderCacheLock indexHolderCacheLock = this.subIndexCacheLocks.get(subIndex);
        synchronized (indexHolderCacheLock) {
            task.run();
        }
    }

    public boolean isCached(String subIndex) throws SearchEngineException {
        return this.indexHolders.containsKey(subIndex);
    }

    public boolean isCached() throws SearchEngineException {
        String[] subIndexes;
        for (String subIndex : subIndexes = this.indexManager.getSubIndexes()) {
            if (!this.isCached(subIndex)) continue;
            return true;
        }
        return false;
    }

    public void clearCache() throws SearchEngineException {
        for (String subIndex : this.indexManager.getSubIndexes()) {
            this.clearCache(subIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache(String subIndex) throws SearchEngineException {
        IndexHolderCacheLock indexHolderCacheLock = this.subIndexCacheLocks.get(subIndex);
        synchronized (indexHolderCacheLock) {
            LuceneIndexHolder indexHolder = this.indexHolders.remove(subIndex);
            if (indexHolder != null) {
                indexHolder.markForClose();
            }
        }
    }

    public void refreshCache() throws SearchEngineException {
        for (String subIndex : this.indexManager.getSubIndexes()) {
            this.refreshCache(subIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshCache(String subIndex) throws SearchEngineException {
        IndexHolderCacheLock indexHolderCacheLock = this.subIndexCacheLocks.get(subIndex);
        synchronized (indexHolderCacheLock) {
            this.internalRefreshCache(subIndex);
        }
    }

    public void invalidateCache() throws SearchEngineException {
        for (String subIndex : this.indexManager.getSubIndexes()) {
            this.invalidateCache(subIndex);
        }
    }

    public void invalidateCache(String subIndex) throws SearchEngineException {
        LuceneIndexHolder indexHolder = this.indexHolders.get(subIndex);
        if (indexHolder != null) {
            indexHolder.setInvalidated(true);
        }
    }

    public synchronized void checkAndClearIfNotifiedAllToClearCache() throws SearchEngineException {
        int i;
        String[] subIndexes;
        if (this.lastModifiled == null) {
            for (String subIndex : subIndexes = this.indexManager.getSubIndexes()) {
                Directory dir = this.indexManager.getDirectory(subIndex);
                try {
                    if (dir.fileExists(CLEAR_CACHE_NAME)) {
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new SearchEngineException("Failed to check if global clear cache exists", e);
                }
                try {
                    dir.createOutput(CLEAR_CACHE_NAME).close();
                }
                catch (IOException e) {
                    throw new SearchEngineException("Failed to update/generate global invalidation cahce", e);
                }
            }
            this.lastModifiled = new long[subIndexes.length];
            for (i = 0; i < subIndexes.length; ++i) {
                Directory dir = this.indexManager.getDirectory(subIndexes[i]);
                try {
                    this.lastModifiled[i] = dir.fileModified(CLEAR_CACHE_NAME);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        subIndexes = this.indexManager.getSubIndexes();
        for (i = 0; i < subIndexes.length; ++i) {
            long lastMod;
            Directory dir = this.indexManager.getDirectory(subIndexes[i]);
            try {
                lastMod = dir.fileModified(CLEAR_CACHE_NAME);
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to check last modified on global index chache on sub index [" + subIndexes[i] + "]", e);
            }
            if (this.lastModifiled[i] >= lastMod) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Global notification to clear cache detected on sub index [" + subIndexes[i] + "]"));
            }
            this.lastModifiled[i] = lastMod;
            this.clearCache(subIndexes[i]);
        }
    }

    public void notifyAllToClearCache() throws SearchEngineException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Global notification to clear cache");
        }
        for (String subIndex : this.indexManager.getSubIndexes()) {
            Directory dir = this.indexManager.getDirectory(subIndex);
            try {
                if (!dir.fileExists(CLEAR_CACHE_NAME)) {
                    dir.createOutput(CLEAR_CACHE_NAME).close();
                    continue;
                }
                dir.touchFile(CLEAR_CACHE_NAME);
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to update/generate global invalidation cahce", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LuceneIndexHolder getHolder(String subIndex) throws SearchEngineException {
        try {
            IndexHolderCacheLock indexHolderCacheLock;
            LuceneIndexHolder indexHolder = this.indexHolders.get(subIndex);
            if (this.cacheAsyncInvalidation) {
                if (indexHolder == null || indexHolder.isInvalidated()) {
                    indexHolderCacheLock = this.subIndexCacheLocks.get(subIndex);
                    synchronized (indexHolderCacheLock) {
                        indexHolder = this.indexHolders.get(subIndex);
                        if (indexHolder == null || indexHolder.isInvalidated()) {
                            indexHolder = this.internalRefreshCache(subIndex);
                        }
                    }
                }
            } else if (this.shouldInvalidateCache(indexHolder)) {
                indexHolderCacheLock = this.subIndexCacheLocks.get(subIndex);
                synchronized (indexHolderCacheLock) {
                    indexHolder = this.internalRefreshCache(subIndex);
                }
            }
            while (!indexHolder.acquire()) {
                indexHolder = this.indexHolders.get(subIndex);
                if (indexHolder != null) continue;
                indexHolderCacheLock = this.subIndexCacheLocks.get(subIndex);
                synchronized (indexHolderCacheLock) {
                    indexHolder = this.indexHolders.get(subIndex);
                    if (indexHolder == null) {
                        indexHolder = this.internalRefreshCache(subIndex);
                    }
                }
            }
            return indexHolder;
        }
        catch (Exception e) {
            throw new SearchEngineException("Failed to open index searcher for sub-index [" + subIndex + "]", e);
        }
    }

    private LuceneIndexHolder internalRefreshCache(String subIndex) throws SearchEngineException {
        LuceneIndexHolder indexHolder;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Refreshing cache for sub index [" + subIndex + "]"));
        }
        if ((indexHolder = this.indexHolders.get(subIndex)) != null) {
            IndexReader reader;
            try {
                reader = indexHolder.getIndexReader().reopen();
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to refresh sub index cache [" + subIndex + "]", e);
            }
            if (reader != indexHolder.getIndexReader()) {
                LuceneIndexHolder origHolder = indexHolder;
                indexHolder = new LuceneIndexHolder(this, subIndex, this.indexManager.openIndexSearcher(reader));
                LuceneIndexHolder oldHolder = this.indexHolders.put(subIndex, indexHolder);
                if (oldHolder != null) {
                    oldHolder.markForClose();
                }
                origHolder.markForClose();
            } else {
                indexHolder.setInvalidated(false);
                indexHolder.markLastCacheInvalidation();
            }
        } else {
            try {
                IndexReader reader = IndexReader.open((Directory)this.indexManager.getDirectory(subIndex), (boolean)true);
                indexHolder = new LuceneIndexHolder(this, subIndex, this.indexManager.openIndexSearcher(reader));
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to open sub index cache [" + subIndex + "]", e);
            }
            LuceneIndexHolder oldHolder = this.indexHolders.put(subIndex, indexHolder);
            if (oldHolder != null) {
                oldHolder.markForClose();
            }
        }
        return indexHolder;
    }

    protected boolean shouldInvalidateCache(LuceneIndexHolder indexHolder) throws IOException {
        if (indexHolder == null) {
            return true;
        }
        if (indexHolder.isInvalidated()) {
            return true;
        }
        if (this.indexManager.getSettings().getCacheInvalidationInterval() == -1L) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - indexHolder.getLastCacheInvalidation() > this.indexManager.getSettings().getCacheInvalidationInterval()) {
            indexHolder.markLastCacheInvalidation();
            try {
                if (!indexHolder.getIndexReader().isCurrent()) {
                    return true;
                }
            }
            catch (AlreadyClosedException e) {
                return false;
            }
            catch (FileNotFoundException e) {
                return false;
            }
        }
        return false;
    }

    private static class IndexHolderCacheLock {
        private IndexHolderCacheLock() {
        }
    }

    private class ScheduledRefreshCacheRunnable
    implements Runnable {
        private ScheduledRefreshCacheRunnable() {
        }

        public void run() {
            IndexHoldersCache.this.indexManager.getTransactionContext().execute(new TransactionContextCallback<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object doInTransaction() throws CompassException {
                    for (String subIndex : IndexHoldersCache.this.indexManager.getSubIndexes()) {
                        try {
                            if (IndexHoldersCache.this.indexManager.getStore().indexExists(subIndex)) {
                                LuceneIndexHolder indexHolder = (LuceneIndexHolder)IndexHoldersCache.this.indexHolders.get(subIndex);
                                if (!IndexHoldersCache.this.shouldInvalidateCache(indexHolder)) continue;
                                IndexHolderCacheLock indexHolderCacheLock = (IndexHolderCacheLock)IndexHoldersCache.this.subIndexCacheLocks.get(subIndex);
                                synchronized (indexHolderCacheLock) {
                                    IndexHoldersCache.this.internalRefreshCache(subIndex);
                                    continue;
                                }
                            }
                            logger.trace((Object)("Sub index [" + subIndex + "] does not exists, no refresh perfomed"));
                        }
                        catch (Exception e) {
                            logger.warn((Object)("Failed to perform background refresh of cache for for sub-index [" + subIndex + "]"), (Throwable)e);
                        }
                    }
                    return null;
                }
            });
        }
    }
}

