/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.Resource;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.RuntimeCompassSettings;
import org.compass.core.engine.SearchEngine;
import org.compass.core.engine.SearchEngineAnalyzerHelper;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineHits;
import org.compass.core.engine.SearchEngineInternalSearch;
import org.compass.core.engine.SearchEngineQuery;
import org.compass.core.engine.SearchEngineQueryBuilder;
import org.compass.core.engine.SearchEngineQueryFilterBuilder;
import org.compass.core.engine.SearchEngineTermFrequencies;
import org.compass.core.engine.event.SearchEngineEventManager;
import org.compass.core.lucene.engine.LuceneDelegatedClose;
import org.compass.core.lucene.engine.LuceneSearchEngineAnalyzerHelper;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.LuceneSearchEngineHits;
import org.compass.core.lucene.engine.LuceneSearchEngineInternalSearch;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.engine.LuceneSearchEngineTermFrequencies;
import org.compass.core.lucene.engine.transaction.TransactionProcessor;
import org.compass.core.lucene.engine.transaction.TransactionProcessorFactory;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.spi.InternalResource;
import org.compass.core.spi.MultiResource;
import org.compass.core.spi.ResourceKey;
import org.compass.core.util.StringUtils;

public class LuceneSearchEngine
implements SearchEngine {
    protected static final Log log = LogFactory.getLog(LuceneSearchEngine.class);
    private static final int NOT_STARTED = -1;
    private static final int STARTED = 0;
    private static final int COMMIT = 1;
    private static final int ROLLBACK = 2;
    private volatile int transactionState;
    private final LuceneSearchEngineFactory searchEngineFactory;
    private final RuntimeCompassSettings runtimeSettings;
    private final SearchEngineEventManager eventManager = new SearchEngineEventManager();
    private TransactionProcessor transactionProcessor;
    private boolean onlyReadOnlyOperations;
    private boolean readOnly;
    private final ArrayList<LuceneDelegatedClose> delegateClose = new ArrayList();

    public LuceneSearchEngine(RuntimeCompassSettings runtimeSettings, LuceneSearchEngineFactory searchEngineFactory) {
        this.runtimeSettings = runtimeSettings;
        this.onlyReadOnlyOperations = true;
        this.searchEngineFactory = searchEngineFactory;
        this.transactionState = -1;
        this.eventManager.registerLifecycleListener(searchEngineFactory.getEventManager());
        searchEngineFactory.getLuceneIndexManager().getStore().registerEventListeners(this, this.eventManager);
    }

    public SearchEngineQueryBuilder queryBuilder() throws SearchEngineException {
        return this.searchEngineFactory.queryBuilder();
    }

    public SearchEngineQueryFilterBuilder queryFilterBuilder() throws SearchEngineException {
        return this.searchEngineFactory.queryFilterBuilder();
    }

    public SearchEngineAnalyzerHelper analyzerHelper() {
        return new LuceneSearchEngineAnalyzerHelper(this);
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void begin() throws SearchEngineException {
        this.onlyReadOnlyOperations = true;
        if (this.transactionState == 0) {
            throw new SearchEngineException("Transaction already started, why start it again?");
        }
        this.closeDelegateClosed();
        String defaultProcessorFactory = "read_committed";
        if (this.readOnly) {
            defaultProcessorFactory = "search";
        }
        TransactionProcessorFactory transactionProcessorFactory = this.searchEngineFactory.getTransactionProcessorManager().getProcessorFactory(this.runtimeSettings.getSetting("compass.transaction.processor", defaultProcessorFactory));
        this.transactionProcessor = transactionProcessorFactory.create(this);
        this.eventManager.beforeBeginTransaction();
        this.transactionProcessor.begin();
        this.eventManager.afterBeginTransaction();
        this.transactionState = 0;
    }

    public void verifyNotReadOnly() throws SearchEngineException {
        if (this.readOnly) {
            throw new SearchEngineException("Transaction is set as read only");
        }
    }

    public void verifyWithinTransaction() throws SearchEngineException {
        if (this.transactionState != 0) {
            if (this.transactionState == 1) {
                throw new SearchEngineException("Search engine transactionProcessor already committed while trying to perform an operation");
            }
            if (this.transactionState == 2) {
                throw new SearchEngineException("Search engine transactionProcessor already rolled back while trying to perform an operation");
            }
            if (this.transactionState == -1) {
                throw new SearchEngineException("Search engine transactionProcessor not stated, please call begin transactionProcessor in order to perform operations");
            }
        }
    }

    public boolean isWithinTransaction() throws SearchEngineException {
        return this.transactionState == 0;
    }

    public void prepare() throws SearchEngineException {
        this.verifyWithinTransaction();
        this.closeDelegateClosed();
        if (this.transactionProcessor != null) {
            this.transactionProcessor.prepare();
        }
        this.eventManager.afterPrepare();
    }

    public void commit(boolean onePhase) throws SearchEngineException {
        this.verifyWithinTransaction();
        this.closeDelegateClosed();
        if (this.transactionProcessor != null) {
            this.transactionProcessor.commit(onePhase);
            this.eventManager.afterCommit(onePhase);
        }
        this.transactionProcessor = null;
        this.transactionState = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SearchEngineException {
        block6: {
            this.verifyWithinTransaction();
            this.closeDelegateClosed();
            try {
                if (this.transactionProcessor == null) break block6;
                try {
                    this.transactionProcessor.rollback();
                }
                finally {
                    this.eventManager.afterRollback();
                }
            }
            finally {
                this.transactionProcessor = null;
                this.transactionState = 2;
            }
        }
    }

    public void flush() throws SearchEngineException {
        this.verifyWithinTransaction();
        if (this.transactionProcessor != null) {
            this.transactionProcessor.flush();
        }
    }

    public void flushCommit(String ... aliases) throws SearchEngineException {
        this.verifyWithinTransaction();
        if (this.transactionProcessor != null) {
            this.transactionProcessor.flushCommit(aliases);
        }
    }

    public boolean wasRolledBack() throws SearchEngineException {
        return this.transactionState == 2;
    }

    public boolean wasCommitted() throws SearchEngineException {
        return this.transactionState == 1;
    }

    public void close() throws SearchEngineException {
        this.eventManager.close();
        if (this.transactionState == 0) {
            log.warn((Object)"Transaction not committed/rolledback, rolling back");
            try {
                this.rollback();
            }
            catch (Exception e) {
                log.warn((Object)"Failed to rollback transcation, ignoring", (Throwable)e);
            }
        }
    }

    public void delete(Resource resource) throws SearchEngineException {
        this.verifyWithinTransaction();
        this.verifyNotReadOnly();
        this.onlyReadOnlyOperations = false;
        if (resource instanceof MultiResource) {
            MultiResource multiResource = (MultiResource)resource;
            for (int i = 0; i < multiResource.size(); ++i) {
                this.delete(((InternalResource)multiResource.resource(i)).getResourceKey());
            }
        } else {
            this.delete(((InternalResource)resource).getResourceKey());
        }
    }

    private void delete(ResourceKey resourceKey) throws SearchEngineException {
        String[] extendingAliases;
        if (resourceKey.getIds().length == 0) {
            throw new SearchEngineException("Cannot delete a resource with no ids and alias [" + resourceKey.getAlias() + "]");
        }
        this.transactionProcessor.delete(resourceKey);
        for (String extendingAlias : extendingAliases = resourceKey.getResourceMapping().getExtendingAliases()) {
            ResourceMapping extendingMapping = this.getSearchEngineFactory().getMapping().getMappingByAlias(extendingAlias);
            ResourceKey key = new ResourceKey(extendingMapping, resourceKey.getIds());
            this.transactionProcessor.delete(key);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("RESOURCE DELETE {" + resourceKey.getAlias() + "} " + StringUtils.arrayToCommaDelimitedString(resourceKey.getIds())));
        }
    }

    public void delete(SearchEngineQuery query) throws SearchEngineException {
        this.verifyWithinTransaction();
        this.verifyNotReadOnly();
        this.onlyReadOnlyOperations = false;
        this.transactionProcessor.delete((LuceneSearchEngineQuery)query);
        if (log.isTraceEnabled()) {
            log.trace((Object)("QUERY DELETE [" + query + "]"));
        }
    }

    public void save(Resource resource) throws SearchEngineException {
        this.onlyReadOnlyOperations = false;
        this.createOrUpdate(resource, true);
    }

    public void create(Resource resource) throws SearchEngineException {
        this.onlyReadOnlyOperations = false;
        this.createOrUpdate(resource, false);
    }

    private void createOrUpdate(Resource resource, boolean update) throws SearchEngineException {
        this.verifyWithinTransaction();
        this.verifyNotReadOnly();
        this.onlyReadOnlyOperations = false;
        String alias = resource.getAlias();
        ResourceMapping resourceMapping = this.searchEngineFactory.getMapping().getRootMappingByAlias(alias);
        if (resourceMapping == null) {
            throw new SearchEngineException("Failed to find mapping for alias [" + alias + "]");
        }
        if (resource instanceof MultiResource) {
            MultiResource multiResource = (MultiResource)resource;
            for (int i = 0; i < multiResource.size(); ++i) {
                InternalResource resource1 = (InternalResource)multiResource.resource(i);
                if (update) {
                    this.transactionProcessor.update(resource1);
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("RESOURCE SAVE " + resource1));
                    continue;
                }
                this.transactionProcessor.create(resource1);
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("RESOURCE CREATE " + resource1));
            }
        } else {
            InternalResource resource1 = (InternalResource)resource;
            if (update) {
                this.transactionProcessor.update(resource1);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("RESOURCE SAVE " + resource1));
                }
            } else {
                this.transactionProcessor.create(resource1);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("RESOURCE CREATE " + resource1));
                }
            }
        }
    }

    public Resource get(Resource idResource) throws SearchEngineException {
        this.verifyWithinTransaction();
        ResourceKey resourceKey = ((InternalResource)idResource).getResourceKey();
        if (resourceKey.getIds().length == 0) {
            throw new SearchEngineException("Cannot load a resource with no ids and alias [" + resourceKey.getAlias() + "]");
        }
        Resource[] result = this.transactionProcessor.get(resourceKey);
        if (result.length == 0) {
            String[] extendingAliases;
            for (String extendingAlias : extendingAliases = resourceKey.getResourceMapping().getExtendingAliases()) {
                ResourceMapping extendingMapping = this.getSearchEngineFactory().getMapping().getMappingByAlias(extendingAlias);
                ResourceKey key = new ResourceKey(extendingMapping, resourceKey.getIds());
                result = this.transactionProcessor.get(key);
                if (result.length <= 0) continue;
                return result[result.length - 1];
            }
            return null;
        }
        if (result.length > 1) {
            log.warn((Object)("Found several matches in get/load operation for resource alias [" + resourceKey.getAlias() + "] and ids [" + StringUtils.arrayToCommaDelimitedString(resourceKey.getIds()) + "]"));
            return result[result.length - 1];
        }
        return result[0];
    }

    public Resource load(Resource idResource) throws SearchEngineException {
        String alias = idResource.getAlias();
        Resource resource = this.get(idResource);
        if (resource == null) {
            throw new SearchEngineException("Failed to find resource with alias [" + alias + "] and ids [" + StringUtils.arrayToCommaDelimitedString(idResource.getIds()) + "]");
        }
        return resource;
    }

    public SearchEngineHits find(SearchEngineQuery query) throws SearchEngineException {
        this.verifyWithinTransaction();
        LuceneSearchEngineHits hits = this.transactionProcessor.find((LuceneSearchEngineQuery)query);
        if (log.isTraceEnabled()) {
            log.trace((Object)("RESOURCE QUERY [" + query + "] HITS [" + hits.getLength() + "]"));
        }
        this.delegateClose.add(hits);
        return hits;
    }

    public SearchEngineTermFrequencies termFreq(String[] propertyNames, int size, SearchEngineInternalSearch internalSearch) {
        return new LuceneSearchEngineTermFrequencies(propertyNames, size, (LuceneSearchEngineInternalSearch)internalSearch);
    }

    public SearchEngineInternalSearch internalSearch(String[] subIndexes, String[] aliases) throws SearchEngineException {
        this.verifyWithinTransaction();
        LuceneSearchEngineInternalSearch internalSearch = this.transactionProcessor.internalSearch(subIndexes, aliases);
        this.delegateClose.add(internalSearch);
        return internalSearch;
    }

    public void removeDelegatedClose(LuceneDelegatedClose closable) {
        this.delegateClose.remove(closable);
    }

    protected void closeDelegateClosed() throws SearchEngineException {
        LuceneDelegatedClose[] closeables = this.delegateClose.toArray(new LuceneDelegatedClose[this.delegateClose.size()]);
        this.delegateClose.clear();
        for (LuceneDelegatedClose delegatedClose : closeables) {
            try {
                delegatedClose.closeDelegate();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public LuceneSearchEngineFactory getSearchEngineFactory() {
        return this.searchEngineFactory;
    }

    public TransactionProcessor getTransactionProcessor() {
        return this.transactionProcessor;
    }

    public CompassSettings getSettings() {
        return this.runtimeSettings;
    }

    public boolean onlyReadOperations() {
        return this.onlyReadOnlyOperations;
    }
}

