/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.json.impl;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.compass.core.json.JsonObject;
import org.compass.core.json.impl.DefaultJSONArray;
import org.compass.core.json.impl.DefaultJSONException;
import org.compass.core.json.impl.DefaultJSONString;
import org.compass.core.json.impl.DefaultJSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJSONObject
implements JsonObject {
    private HashMap<String, Object> myHashMap;
    public static final Object NULL = new Null();

    public Map<String, Object> entries() {
        return this.myHashMap;
    }

    @Override
    public boolean isNullValue(Object value) {
        return NULL.equals(value);
    }

    public DefaultJSONObject() {
        this.myHashMap = new HashMap();
    }

    public DefaultJSONObject(DefaultJSONObject jo, String[] names) throws DefaultJSONException {
        this();
        for (int i = 0; i < names.length; ++i) {
            this.putOpt(names[i], jo.opt(names[i]));
        }
    }

    public DefaultJSONObject(DefaultJSONTokener x) throws DefaultJSONException {
        this();
        if (x.nextClean() != '{') {
            throw x.syntaxError("A DefaultJSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A DefaultJSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            c = x.nextClean();
            if (c == '=') {
                if (x.next() != '>') {
                    x.back();
                }
            } else if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            this.put(key, x.nextValue());
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}'");
    }

    public DefaultJSONObject(Map<String, Object> map) {
        this.myHashMap = map == null ? new HashMap() : new HashMap<String, Object>(map);
    }

    public DefaultJSONObject(Object bean) {
        this();
        Class<?> klass = bean.getClass();
        Method[] methods = klass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            try {
                Method method = methods[i];
                String name = method.getName();
                String key = "";
                if (name.startsWith("get")) {
                    key = name.substring(3);
                } else if (name.startsWith("is")) {
                    key = name.substring(2);
                }
                if (key.length() <= 0 || !Character.isUpperCase(key.charAt(0)) || method.getParameterTypes().length != 0) continue;
                if (key.length() == 1) {
                    key = key.toLowerCase();
                } else if (!Character.isUpperCase(key.charAt(1))) {
                    key = key.substring(0, 1).toLowerCase() + key.substring(1);
                }
                this.put(key, method.invoke(bean, (Object[])null));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public DefaultJSONObject(Object object, String[] names) {
        this();
        Class<?> c = object.getClass();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            try {
                Field field = c.getField(name);
                Object value = field.get(object);
                this.put(name, value);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public DefaultJSONObject(String source) throws DefaultJSONException {
        this(new DefaultJSONTokener(source));
    }

    public DefaultJSONObject accumulate(String key, Object value) throws DefaultJSONException {
        DefaultJSONObject.testValidity(value);
        Object o = this.opt(key);
        if (o == null) {
            this.put(key, value instanceof DefaultJSONArray ? new DefaultJSONArray().put(value) : value);
        } else if (o instanceof DefaultJSONArray) {
            ((DefaultJSONArray)o).put(value);
        } else {
            this.put(key, new DefaultJSONArray().put(o).put(value));
        }
        return this;
    }

    public DefaultJSONObject append(String key, Object value) throws DefaultJSONException {
        DefaultJSONObject.testValidity(value);
        Object o = this.opt(key);
        if (o == null) {
            this.put(key, new DefaultJSONArray().put(value));
        } else if (o instanceof DefaultJSONArray) {
            this.put(key, ((DefaultJSONArray)o).put(value));
        } else {
            throw new DefaultJSONException("DefaultJSONObject[" + key + "] is not a DefaultJSONArray.");
        }
        return this;
    }

    public static String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "null";
        }
        String s = Double.toString(d);
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public Object get(String key) throws DefaultJSONException {
        Object o = this.opt(key);
        if (o == null) {
            throw new DefaultJSONException("DefaultJSONObject[" + DefaultJSONObject.quote(key) + "] not found.");
        }
        return o;
    }

    public boolean getBoolean(String key) throws DefaultJSONException {
        Object o = this.get(key);
        if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
            return false;
        }
        if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
            return true;
        }
        throw new DefaultJSONException("DefaultJSONObject[" + DefaultJSONObject.quote(key) + "] is not a Boolean.");
    }

    public double getDouble(String key) throws DefaultJSONException {
        Object o = this.get(key);
        try {
            return o instanceof Number ? ((Number)o).doubleValue() : Double.valueOf((String)o).doubleValue();
        }
        catch (Exception e) {
            throw new DefaultJSONException("DefaultJSONObject[" + DefaultJSONObject.quote(key) + "] is not a number.");
        }
    }

    public int getInt(String key) throws DefaultJSONException {
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(key);
    }

    public DefaultJSONArray getJSONArray(String key) throws DefaultJSONException {
        Object o = this.get(key);
        if (o instanceof DefaultJSONArray) {
            return (DefaultJSONArray)o;
        }
        throw new DefaultJSONException("DefaultJSONObject[" + DefaultJSONObject.quote(key) + "] is not a DefaultJSONArray.");
    }

    public DefaultJSONObject getJSONObject(String key) throws DefaultJSONException {
        Object o = this.get(key);
        if (o instanceof DefaultJSONObject) {
            return (DefaultJSONObject)o;
        }
        throw new DefaultJSONException("DefaultJSONObject[" + DefaultJSONObject.quote(key) + "] is not a DefaultJSONObject.");
    }

    public long getLong(String key) throws DefaultJSONException {
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).longValue() : (long)this.getDouble(key);
    }

    public static String[] getNames(DefaultJSONObject jo) {
        int length = jo.length();
        if (length == 0) {
            return null;
        }
        Iterator i = jo.keys();
        String[] names = new String[length];
        int j = 0;
        while (i.hasNext()) {
            names[j] = (String)i.next();
            ++j;
        }
        return names;
    }

    public static String[] getNames(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> klass = object.getClass();
        Field[] fields = klass.getFields();
        int length = fields.length;
        if (length == 0) {
            return null;
        }
        String[] names = new String[length];
        for (int i = 0; i < length; ++i) {
            names[i] = fields[i].getName();
        }
        return names;
    }

    public String getString(String key) throws DefaultJSONException {
        return this.get(key).toString();
    }

    public boolean has(String key) {
        return this.myHashMap.containsKey(key);
    }

    public boolean isNull(String key) {
        return NULL.equals(this.opt(key));
    }

    public Iterator keys() {
        return this.myHashMap.keySet().iterator();
    }

    public int length() {
        return this.myHashMap.size();
    }

    public DefaultJSONArray names() {
        DefaultJSONArray ja = new DefaultJSONArray();
        Iterator keys = this.keys();
        while (keys.hasNext()) {
            ja.put(keys.next());
        }
        return ja.length() == 0 ? null : ja;
    }

    public static String numberToString(Number n) throws DefaultJSONException {
        if (n == null) {
            throw new DefaultJSONException("Null pointer");
        }
        DefaultJSONObject.testValidity(n);
        String s = n.toString();
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    @Override
    public Object opt(String key) {
        return key == null ? null : this.myHashMap.get(key);
    }

    public boolean optBoolean(String key) {
        return this.optBoolean(key, false);
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        try {
            return this.getBoolean(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public DefaultJSONObject put(String key, Collection value) throws DefaultJSONException {
        this.put(key, new DefaultJSONArray(value));
        return this;
    }

    public double optDouble(String key) {
        return this.optDouble(key, Double.NaN);
    }

    public double optDouble(String key, double defaultValue) {
        try {
            Object o = this.opt(key);
            return o instanceof Number ? ((Number)o).doubleValue() : new Double((String)o).doubleValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int optInt(String key) {
        return this.optInt(key, 0);
    }

    public int optInt(String key, int defaultValue) {
        try {
            return this.getInt(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public DefaultJSONArray optJSONArray(String key) {
        Object o = this.opt(key);
        return o instanceof DefaultJSONArray ? (DefaultJSONArray)o : null;
    }

    public DefaultJSONObject optJSONObject(String key) {
        Object o = this.opt(key);
        return o instanceof DefaultJSONObject ? (DefaultJSONObject)o : null;
    }

    public long optLong(String key) {
        return this.optLong(key, 0L);
    }

    public long optLong(String key, long defaultValue) {
        try {
            return this.getLong(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(String key) {
        return this.optString(key, "");
    }

    public String optString(String key, String defaultValue) {
        Object o = this.opt(key);
        return o != null ? o.toString() : defaultValue;
    }

    public DefaultJSONObject put(String key, boolean value) throws DefaultJSONException {
        this.put(key, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public DefaultJSONObject put(String key, double value) throws DefaultJSONException {
        this.put(key, new Double(value));
        return this;
    }

    public DefaultJSONObject put(String key, int value) throws DefaultJSONException {
        this.put(key, new Integer(value));
        return this;
    }

    public DefaultJSONObject put(String key, long value) throws DefaultJSONException {
        this.put(key, new Long(value));
        return this;
    }

    public DefaultJSONObject put(String key, Map<String, Object> value) throws DefaultJSONException {
        this.put(key, new DefaultJSONObject(value));
        return this;
    }

    public DefaultJSONObject put(String key, Object value) throws DefaultJSONException {
        if (key == null) {
            throw new DefaultJSONException("Null key.");
        }
        if (value != null) {
            DefaultJSONObject.testValidity(value);
            this.myHashMap.put(key, value);
        } else {
            this.remove(key);
        }
        return this;
    }

    public DefaultJSONObject putOpt(String key, Object value) throws DefaultJSONException {
        if (key != null && value != null) {
            this.put(key, value);
        }
        return this;
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public Object remove(String key) {
        return this.myHashMap.remove(key);
    }

    public Iterator sortedKeys() {
        return new TreeSet<String>(this.myHashMap.keySet()).iterator();
    }

    static void testValidity(Object o) throws DefaultJSONException {
        if (o != null && (o instanceof Double ? ((Double)o).isInfinite() || ((Double)o).isNaN() : o instanceof Float && (((Float)o).isInfinite() || ((Float)o).isNaN()))) {
            throw new DefaultJSONException("JSON does not allow non-finite numbers.");
        }
    }

    public DefaultJSONArray toJSONArray(DefaultJSONArray names) throws DefaultJSONException {
        if (names == null || names.length() == 0) {
            return null;
        }
        DefaultJSONArray ja = new DefaultJSONArray();
        for (int i = 0; i < names.length(); ++i) {
            ja.put(this.opt(names.getString(i)));
        }
        return ja;
    }

    public String toString() {
        try {
            Iterator keys = this.keys();
            StringBuffer sb = new StringBuffer("{");
            while (keys.hasNext()) {
                if (sb.length() > 1) {
                    sb.append(',');
                }
                Object o = keys.next();
                sb.append(DefaultJSONObject.quote(o.toString()));
                sb.append(':');
                sb.append(DefaultJSONObject.valueToString(this.myHashMap.get(o)));
            }
            sb.append('}');
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString(int indentFactor) throws DefaultJSONException {
        return this.toString(indentFactor, 0);
    }

    String toString(int indentFactor, int indent) throws DefaultJSONException {
        int n = this.length();
        if (n == 0) {
            return "{}";
        }
        Iterator keys = this.sortedKeys();
        StringBuffer sb = new StringBuffer("{");
        int newindent = indent + indentFactor;
        if (n == 1) {
            Object o = keys.next();
            sb.append(DefaultJSONObject.quote(o.toString()));
            sb.append(": ");
            sb.append(DefaultJSONObject.valueToString(this.myHashMap.get(o), indentFactor, indent));
        } else {
            int j;
            while (keys.hasNext()) {
                Object o = keys.next();
                if (sb.length() > 1) {
                    sb.append(",\n");
                } else {
                    sb.append('\n');
                }
                for (j = 0; j < newindent; ++j) {
                    sb.append(' ');
                }
                sb.append(DefaultJSONObject.quote(o.toString()));
                sb.append(": ");
                sb.append(DefaultJSONObject.valueToString(this.myHashMap.get(o), indentFactor, newindent));
            }
            if (sb.length() > 1) {
                sb.append('\n');
                for (j = 0; j < indent; ++j) {
                    sb.append(' ');
                }
            }
        }
        sb.append('}');
        return sb.toString();
    }

    static String valueToString(Object value) throws DefaultJSONException {
        if (value == null || value.equals(null)) {
            return "null";
        }
        if (value instanceof DefaultJSONString) {
            String o;
            try {
                o = ((DefaultJSONString)value).toJSONString();
            }
            catch (Exception e) {
                throw new DefaultJSONException(e);
            }
            if (o instanceof String) {
                return o;
            }
            throw new DefaultJSONException("Bad value from toJSONString: " + o);
        }
        if (value instanceof Number) {
            return DefaultJSONObject.numberToString((Number)value);
        }
        if (value instanceof Boolean || value instanceof DefaultJSONObject || value instanceof DefaultJSONArray) {
            return value.toString();
        }
        if (value instanceof Map) {
            return new DefaultJSONObject((Map)value).toString();
        }
        if (value instanceof Collection) {
            return new DefaultJSONArray((Collection)value).toString();
        }
        if (value instanceof Object[]) {
            return new DefaultJSONArray(value).toString();
        }
        return DefaultJSONObject.quote(value.toString());
    }

    static String valueToString(Object value, int indentFactor, int indent) throws DefaultJSONException {
        if (value == null || value.equals(null)) {
            return "null";
        }
        try {
            String o;
            if (value instanceof DefaultJSONString && (o = ((DefaultJSONString)value).toJSONString()) instanceof String) {
                return o;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value instanceof Number) {
            return DefaultJSONObject.numberToString((Number)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof DefaultJSONObject) {
            return ((DefaultJSONObject)value).toString(indentFactor, indent);
        }
        if (value instanceof DefaultJSONArray) {
            return ((DefaultJSONArray)value).toString(indentFactor, indent);
        }
        if (value instanceof Map) {
            return new DefaultJSONObject((Map)value).toString(indentFactor, indent);
        }
        if (value instanceof Collection) {
            return new DefaultJSONArray((Collection)value).toString(indentFactor, indent);
        }
        if (value.getClass().isArray()) {
            return new DefaultJSONArray(value).toString(indentFactor, indent);
        }
        return DefaultJSONObject.quote(value.toString());
    }

    public Writer write(Writer writer) throws DefaultJSONException {
        try {
            boolean b = false;
            Iterator keys = this.keys();
            writer.write(123);
            while (keys.hasNext()) {
                if (b) {
                    writer.write(44);
                }
                Object k = keys.next();
                writer.write(DefaultJSONObject.quote(k.toString()));
                writer.write(58);
                Object v = this.myHashMap.get(k);
                if (v instanceof DefaultJSONObject) {
                    ((DefaultJSONObject)v).write(writer);
                } else if (v instanceof DefaultJSONArray) {
                    ((DefaultJSONArray)v).write(writer);
                } else {
                    writer.write(DefaultJSONObject.valueToString(v));
                }
                b = true;
            }
            writer.write(125);
            return writer;
        }
        catch (IOException e) {
            throw new DefaultJSONException(e);
        }
    }

    private static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return "null";
        }
    }
}

