/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.basic;

import java.text.ParseException;
import org.compass.core.converter.basic.AbstractNumberConverter;
import org.compass.core.converter.basic.format.Formatter;
import org.compass.core.converter.basic.format.NumberUtils;
import org.compass.core.mapping.ResourcePropertyMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortConverter
extends AbstractNumberConverter<Short> {
    @Override
    protected Short defaultFromString(String str, ResourcePropertyMapping resourcePropertyMapping) {
        return Short.valueOf(str);
    }

    @Override
    protected Short fromNumber(Number number) {
        return number.shortValue();
    }

    @Override
    protected Formatter createSortableFormatter() {
        return new Formatter(){

            public String format(Object obj) {
                int val = ((Number)obj).intValue();
                return NumberUtils.int2sortableStr(val);
            }

            public Object parse(String str) throws ParseException {
                return NumberUtils.SortableStr2int(str);
            }

            public boolean isThreadSafe() {
                return true;
            }
        };
    }
}

