/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.impl;

import com.liferay.documentlibrary.DuplicateDirectoryException;
import com.liferay.documentlibrary.NoSuchDirectoryException;
import com.liferay.documentlibrary.NoSuchFileException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MathUtil;
import com.liferay.portal.kernel.util.NotificationThreadLocal;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.CompanyConstants;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.NoSuchEntryException;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.wiki.DuplicatePageException;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.NoSuchPageResourceException;
import com.liferay.portlet.wiki.PageContentException;
import com.liferay.portlet.wiki.PageTitleException;
import com.liferay.portlet.wiki.PageVersionException;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.WikiPageConstants;
import com.liferay.portlet.wiki.model.WikiPageDisplay;
import com.liferay.portlet.wiki.model.WikiPageResource;
import com.liferay.portlet.wiki.model.impl.WikiPageDisplayImpl;
import com.liferay.portlet.wiki.model.impl.WikiPageImpl;
import com.liferay.portlet.wiki.service.base.WikiPageLocalServiceBaseImpl;
import com.liferay.portlet.wiki.util.WikiCacheThreadLocal;
import com.liferay.portlet.wiki.util.WikiCacheUtil;
import com.liferay.portlet.wiki.util.WikiUtil;
import com.liferay.portlet.wiki.util.comparator.PageCreateDateComparator;
import com.liferay.portlet.wiki.util.comparator.PageVersionComparator;
import com.liferay.util.UniqueList;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiPageLocalServiceImpl
extends WikiPageLocalServiceBaseImpl {
    public WikiPage addPage(long userId, long nodeId, String title, double version, String content, String summary, boolean minorEdit, String format, boolean head, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        Date now = new Date();
        this.validate(title, nodeId, content, format);
        long pageId = this.counterLocalService.increment();
        long resourcePrimKey = this.wikiPageResourceLocalService.getPageResourcePrimKey(nodeId, title);
        WikiPage page = this.wikiPagePersistence.create(pageId);
        page.setUuid(serviceContext.getUuid());
        page.setResourcePrimKey(resourcePrimKey);
        page.setGroupId(node.getGroupId());
        page.setCompanyId(user.getCompanyId());
        page.setUserId(user.getUserId());
        page.setUserName(user.getFullName());
        page.setCreateDate(serviceContext.getCreateDate(now));
        page.setModifiedDate(serviceContext.getModifiedDate(now));
        page.setNodeId(nodeId);
        page.setTitle(title);
        page.setVersion(version);
        page.setMinorEdit(minorEdit);
        page.setContent(content);
        page.setStatus(2);
        page.setSummary(summary);
        page.setFormat(format);
        page.setHead(head);
        page.setParentTitle(parentTitle);
        page.setRedirectTitle(redirectTitle);
        this.wikiPagePersistence.update((BaseModel)page, false);
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addPageResources(page, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addPageResources(page, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        node.setLastPostDate(serviceContext.getModifiedDate(now));
        this.wikiNodePersistence.update((BaseModel)node, false);
        this.updateAsset(userId, page, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        ExpandoBridge expandoBridge = page.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        if (PropsValues.WIKI_PAGE_COMMENTS_ENABLED) {
            this.mbMessageLocalService.addDiscussionMessage(userId, page.getUserName(), page.getGroupId(), WikiPage.class.getName(), resourcePrimKey, 1);
        }
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)page.getGroupId(), (long)userId, (String)WikiPage.class.getName(), (long)page.getResourcePrimKey(), (Object)page, (ServiceContext)serviceContext);
        return page;
    }

    public WikiPage addPage(long userId, long nodeId, String title, String content, String summary, boolean minorEdit, ServiceContext serviceContext) throws PortalException, SystemException {
        double version = 1.0;
        String format = WikiPageConstants.DEFAULT_FORMAT;
        boolean head = false;
        String parentTitle = null;
        String redirectTitle = null;
        return this.addPage(userId, nodeId, title, version, content, summary, minorEdit, format, head, parentTitle, redirectTitle, serviceContext);
    }

    public void addPageAttachment(long companyId, String dirName, Date modifiedDate, String fileName, InputStream inputStream) throws PortalException, SystemException {
        if (inputStream == null) {
            return;
        }
        String portletId = CompanyConstants.SYSTEM_STRING;
        long groupId = 0L;
        long repositoryId = 0L;
        try {
            this.dlService.addDirectory(companyId, repositoryId, dirName);
        }
        catch (DuplicateDirectoryException duplicateDirectoryException) {}
        this.dlLocalService.addFile(companyId, portletId, groupId, repositoryId, String.valueOf(dirName) + "/" + fileName, false, 0L, "", modifiedDate, new ServiceContext(), inputStream);
    }

    public void addPageAttachments(long nodeId, String title, List<ObjectValuePair<String, byte[]>> files) throws PortalException, SystemException {
        if (files.size() == 0) {
            return;
        }
        WikiPage page = this.getPage(nodeId, title);
        long companyId = page.getCompanyId();
        String portletId = CompanyConstants.SYSTEM_STRING;
        long groupId = 0L;
        long repositoryId = 0L;
        String dirName = page.getAttachmentsDir();
        try {
            this.dlService.addDirectory(companyId, repositoryId, dirName);
        }
        catch (DuplicateDirectoryException duplicateDirectoryException) {}
        int i = 0;
        while (i < files.size()) {
            ObjectValuePair<String, byte[]> ovp = files.get(i);
            String fileName = (String)ovp.getKey();
            byte[] bytes = (byte[])ovp.getValue();
            if (!Validator.isNull((String)fileName)) {
                this.dlService.addFile(companyId, portletId, groupId, repositoryId, String.valueOf(dirName) + "/" + fileName, 0L, "", page.getModifiedDate(), new ServiceContext(), bytes);
            }
            ++i;
        }
    }

    public void addPageResources(long nodeId, String title, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        WikiPage page = this.getPage(nodeId, title);
        this.addPageResources(page, addCommunityPermissions, addGuestPermissions);
    }

    public void addPageResources(long nodeId, String title, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        WikiPage page = this.getPage(nodeId, title);
        this.addPageResources(page, communityPermissions, guestPermissions);
    }

    public void addPageResources(WikiPage page, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(page.getCompanyId(), page.getGroupId(), page.getUserId(), WikiPage.class.getName(), page.getResourcePrimKey(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addPageResources(WikiPage page, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(page.getCompanyId(), page.getGroupId(), page.getUserId(), WikiPage.class.getName(), page.getResourcePrimKey(), communityPermissions, guestPermissions);
    }

    public void changeParent(long userId, long nodeId, String title, String newParentTitle, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiPage parentPage;
        if (Validator.isNotNull((String)newParentTitle) && Validator.isNotNull((String)(parentPage = this.getPage(nodeId, newParentTitle)).getRedirectTitle())) {
            newParentTitle = parentPage.getRedirectTitle();
        }
        WikiPage page = this.getPage(nodeId, title);
        String originalParentTitle = page.getParentTitle();
        double version = page.getVersion();
        String content = page.getContent();
        String summary = LanguageUtil.format((Locale)ServiceContextUtil.getLocale((ServiceContext)serviceContext), (String)"changed-parent-from-x", (Object)originalParentTitle);
        boolean minorEdit = false;
        String format = page.getFormat();
        String redirectTitle = page.getRedirectTitle();
        long[] assetCategoryIds = this.assetCategoryLocalService.getCategoryIds(WikiPage.class.getName(), page.getResourcePrimKey());
        String[] assetTagNames = this.assetTagLocalService.getTagNames(WikiPage.class.getName(), page.getResourcePrimKey());
        serviceContext.setAssetCategoryIds(assetCategoryIds);
        serviceContext.setAssetTagNames(assetTagNames);
        this.updatePage(userId, nodeId, title, version, content, summary, minorEdit, format, newParentTitle, redirectTitle, serviceContext);
        List oldPages = this.wikiPagePersistence.findByN_T_H(nodeId, title, false);
        for (WikiPage oldPage : oldPages) {
            oldPage.setParentTitle(originalParentTitle);
            this.wikiPagePersistence.update((BaseModel)oldPage, false);
        }
    }

    public void deletePage(long nodeId, String title) throws PortalException, SystemException {
        List pages = this.wikiPagePersistence.findByN_T_H(nodeId, title, true, 0, 1);
        if (!pages.isEmpty()) {
            WikiPage page = (WikiPage)pages.iterator().next();
            this.deletePage(page);
        }
    }

    public void deletePage(long nodeId, String title, double version) throws PortalException, SystemException {
        this.wikiPagePersistence.removeByN_T_V(nodeId, title, version);
    }

    public void deletePage(WikiPage page) throws PortalException, SystemException {
        List children = this.wikiPagePersistence.findByN_H_P(page.getNodeId(), true, page.getTitle());
        for (WikiPage curPage : children) {
            this.deletePage(curPage);
        }
        Indexer indexer = IndexerRegistryUtil.getIndexer(WikiPage.class);
        indexer.delete((Object)page);
        long companyId = page.getCompanyId();
        String portletId = CompanyConstants.SYSTEM_STRING;
        long repositoryId = 0L;
        String dirName = page.getAttachmentsDir();
        try {
            this.dlService.deleteDirectory(companyId, portletId, repositoryId, dirName);
        }
        catch (NoSuchDirectoryException noSuchDirectoryException) {}
        this.subscriptionLocalService.deleteSubscriptions(page.getCompanyId(), WikiPage.class.getName(), page.getResourcePrimKey());
        this.socialActivityLocalService.deleteActivities(WikiPage.class.getName(), page.getResourcePrimKey());
        this.mbMessageLocalService.deleteDiscussionMessages(WikiPage.class.getName(), page.getResourcePrimKey());
        this.expandoValueLocalService.deleteValues(WikiPage.class.getName(), page.getResourcePrimKey());
        this.assetEntryLocalService.deleteEntry(WikiPage.class.getName(), page.getPrimaryKey());
        this.assetEntryLocalService.deleteEntry(WikiPage.class.getName(), page.getResourcePrimKey());
        this.resourceLocalService.deleteResource(page.getCompanyId(), WikiPage.class.getName(), 4, page.getResourcePrimKey());
        try {
            this.wikiPageResourceLocalService.deletePageResource(page.getNodeId(), page.getTitle());
        }
        catch (NoSuchPageResourceException noSuchPageResourceException) {}
        this.wikiPagePersistence.removeByN_T(page.getNodeId(), page.getTitle());
        this.wikiPagePersistence.removeByN_R(page.getNodeId(), page.getTitle());
        this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(page.getCompanyId(), page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey());
        this.clearPageCache(page);
        this.clearReferralsCache(page);
    }

    public void deletePageAttachment(long nodeId, String title, String fileName) throws PortalException, SystemException {
        if (Validator.isNull((String)fileName)) {
            return;
        }
        WikiPage page = this.getPage(nodeId, title);
        long companyId = page.getCompanyId();
        String portletId = CompanyConstants.SYSTEM_STRING;
        long repositoryId = 0L;
        try {
            this.dlService.deleteFile(companyId, portletId, repositoryId, fileName);
        }
        catch (NoSuchFileException noSuchFileException) {}
    }

    public void deletePages(long nodeId) throws PortalException, SystemException {
        for (WikiPage page : this.wikiPagePersistence.findByN_H_P(nodeId, true, "")) {
            this.deletePage(page);
        }
    }

    public List<WikiPage> getChildren(long nodeId, boolean head, String parentTitle) throws SystemException {
        return this.wikiPagePersistence.findByN_H_P_S(nodeId, head, parentTitle, 0);
    }

    public WikiPage getDraftPage(long nodeId, String title) throws PortalException, SystemException {
        List pages = this.wikiPagePersistence.findByN_T_S(nodeId, title, 2, 0, 1);
        if (!pages.isEmpty()) {
            return (WikiPage)pages.get(0);
        }
        pages = this.wikiPagePersistence.findByN_T_S(nodeId, title, 1, 0, 1);
        if (!pages.isEmpty()) {
            return (WikiPage)pages.get(0);
        }
        throw new NoSuchPageException();
    }

    public List<WikiPage> getIncomingLinks(long nodeId, String title) throws PortalException, SystemException {
        UniqueList links = new UniqueList();
        List pages = this.wikiPagePersistence.findByN_H(nodeId, true);
        for (WikiPage page : pages) {
            if (!this.isLinkedTo(page, title)) continue;
            links.add(page);
        }
        List referrals = this.wikiPagePersistence.findByN_R(nodeId, title);
        for (WikiPage referral : referrals) {
            for (WikiPage page : pages) {
                if (!this.isLinkedTo(page, referral.getTitle())) continue;
                links.add(page);
            }
        }
        return ListUtil.sort((List)links);
    }

    public List<WikiPage> getNoAssetPages() throws SystemException {
        return this.wikiPageFinder.findByNoAssets();
    }

    public List<WikiPage> getOrphans(long nodeId) throws PortalException, SystemException {
        ArrayList<Map<String, Boolean>> pageTitles = new ArrayList<Map<String, Boolean>>();
        List pages = this.wikiPagePersistence.findByN_H_S(nodeId, true, 0);
        for (WikiPage page : pages) {
            pageTitles.add(WikiCacheUtil.getOutgoingLinks(page));
        }
        HashSet<WikiPage> notOrphans = new HashSet<WikiPage>();
        block1: for (WikiPage page : pages) {
            for (Map map : pageTitles) {
                if (map.get(page.getTitle().toLowerCase()) == null) continue;
                notOrphans.add(page);
                continue block1;
            }
        }
        ArrayList<WikiPage> orphans = new ArrayList();
        for (WikiPage page : pages) {
            if (notOrphans.contains(page)) continue;
            orphans.add(page);
        }
        orphans = ListUtil.sort(orphans);
        return orphans;
    }

    public List<WikiPage> getOutgoingLinks(long nodeId, String title) throws PortalException, SystemException {
        WikiPage page = this.getPage(nodeId, title);
        LinkedHashMap<String, WikiPage> pages = new LinkedHashMap<String, WikiPage>();
        Map<String, Boolean> links = WikiCacheUtil.getOutgoingLinks(page);
        for (Map.Entry<String, Boolean> entry : links.entrySet()) {
            String curTitle = entry.getKey();
            Boolean exists = entry.getValue();
            if (exists.booleanValue()) {
                if (pages.containsKey(curTitle)) continue;
                pages.put(curTitle, this.getPage(nodeId, curTitle));
                continue;
            }
            WikiPageImpl newPage = new WikiPageImpl();
            newPage.setNew(true);
            newPage.setNodeId(nodeId);
            newPage.setTitle(curTitle);
            if (pages.containsKey(curTitle)) continue;
            pages.put(curTitle, newPage);
        }
        return ListUtil.fromCollection(pages.values());
    }

    public WikiPage getPage(long resourcePrimKey) throws PortalException, SystemException {
        return this.getPage(resourcePrimKey, Boolean.TRUE);
    }

    public WikiPage getPage(long resourcePrimKey, Boolean head) throws PortalException, SystemException {
        WikiPageResource wikiPageResource = this.wikiPageResourceLocalService.getPageResource(resourcePrimKey);
        return this.getPage(wikiPageResource.getNodeId(), wikiPageResource.getTitle(), head);
    }

    public WikiPage getPage(long nodeId, String title) throws PortalException, SystemException {
        List pages = this.wikiPagePersistence.findByN_T_H(nodeId, title, true, 0, 1);
        if (!pages.isEmpty()) {
            return (WikiPage)pages.get(0);
        }
        throw new NoSuchPageException();
    }

    public WikiPage getPage(long nodeId, String title, Boolean head) throws PortalException, SystemException {
        List pages = head == null ? this.wikiPagePersistence.findByN_T(nodeId, title, 0, 1) : this.wikiPagePersistence.findByN_T_H(nodeId, title, head.booleanValue(), 0, 1);
        if (!pages.isEmpty()) {
            return (WikiPage)pages.get(0);
        }
        throw new NoSuchPageException();
    }

    public WikiPage getPage(long nodeId, String title, double version) throws PortalException, SystemException {
        WikiPage page = null;
        page = version == 0.0 ? this.getPage(nodeId, title) : this.wikiPagePersistence.findByN_T_V(nodeId, title, version);
        return page;
    }

    public WikiPageDisplay getPageDisplay(long nodeId, String title, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) throws PortalException, SystemException {
        WikiPage page = this.getPage(nodeId, title);
        return this.getPageDisplay(page, viewPageURL, editPageURL, attachmentURLPrefix);
    }

    public WikiPageDisplay getPageDisplay(WikiPage page, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) throws PortalException, SystemException {
        String formattedContent = WikiUtil.convert(page, viewPageURL, editPageURL, attachmentURLPrefix);
        return new WikiPageDisplayImpl(page.getUserId(), page.getNodeId(), page.getTitle(), page.getVersion(), page.getContent(), formattedContent, page.getFormat(), page.getHead(), page.getAttachmentsFiles());
    }

    public List<WikiPage> getPages(long nodeId, boolean head, int start, int end) throws SystemException {
        return this.getPages(nodeId, head, start, end, (OrderByComparator)new PageCreateDateComparator(false));
    }

    public List<WikiPage> getPages(long nodeId, boolean head, int start, int end, OrderByComparator obc) throws SystemException {
        return this.wikiPagePersistence.findByN_H_S(nodeId, head, 0, start, end, obc);
    }

    public List<WikiPage> getPages(long nodeId, int start, int end) throws SystemException {
        return this.getPages(nodeId, start, end, (OrderByComparator)new PageCreateDateComparator(false));
    }

    public List<WikiPage> getPages(long nodeId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.wikiPagePersistence.findByNodeId(nodeId, start, end, obc);
    }

    public List<WikiPage> getPages(long resourcePrimKey, long nodeId, int status) throws SystemException {
        return this.wikiPagePersistence.findByR_N_S(resourcePrimKey, nodeId, status);
    }

    public List<WikiPage> getPages(long userId, long nodeId, int status, int start, int end) throws SystemException {
        if (userId > 0L) {
            return this.wikiPagePersistence.findByU_N_S(userId, nodeId, status, start, end, (OrderByComparator)new PageCreateDateComparator(false));
        }
        return this.wikiPagePersistence.findByN_S(nodeId, status, start, end, (OrderByComparator)new PageCreateDateComparator(false));
    }

    public List<WikiPage> getPages(long nodeId, String title, boolean head, int start, int end) throws SystemException {
        return this.wikiPagePersistence.findByN_T_H(nodeId, title, head, start, end, (OrderByComparator)new PageCreateDateComparator(false));
    }

    public List<WikiPage> getPages(long nodeId, String title, int start, int end) throws SystemException {
        return this.wikiPagePersistence.findByN_T(nodeId, title, start, end, (OrderByComparator)new PageCreateDateComparator(false));
    }

    public List<WikiPage> getPages(long nodeId, String title, int start, int end, OrderByComparator obc) throws SystemException {
        return this.wikiPagePersistence.findByN_T(nodeId, title, start, end, obc);
    }

    public List<WikiPage> getPages(String format) throws SystemException {
        return this.wikiPagePersistence.findByFormat(format);
    }

    public int getPagesCount(long nodeId) throws SystemException {
        return this.wikiPagePersistence.countByNodeId(nodeId);
    }

    public int getPagesCount(long nodeId, boolean head) throws SystemException {
        return this.wikiPagePersistence.countByN_H_S(nodeId, head, 0);
    }

    public int getPagesCount(long userId, long nodeId, int status) throws SystemException {
        if (userId > 0L) {
            return this.wikiPagePersistence.countByU_N_S(userId, nodeId, status);
        }
        return this.wikiPagePersistence.countByN_S(nodeId, status);
    }

    public int getPagesCount(long nodeId, String title) throws SystemException {
        return this.wikiPagePersistence.countByN_T(nodeId, title);
    }

    public int getPagesCount(long nodeId, String title, boolean head) throws SystemException {
        return this.wikiPagePersistence.countByN_T_H(nodeId, title, head);
    }

    public int getPagesCount(String format) throws SystemException {
        return this.wikiPagePersistence.countByFormat(format);
    }

    public List<WikiPage> getRecentChanges(long nodeId, int start, int end) throws SystemException {
        Calendar cal = CalendarFactoryUtil.getCalendar();
        cal.add(3, -1);
        return this.wikiPageFinder.findByCreateDate(nodeId, cal.getTime(), false, start, end);
    }

    public int getRecentChangesCount(long nodeId) throws SystemException {
        Calendar cal = CalendarFactoryUtil.getCalendar();
        cal.add(3, -1);
        return this.wikiPageFinder.countByCreateDate(nodeId, cal.getTime(), false);
    }

    public boolean hasDraftPage(long nodeId, String title) throws SystemException {
        int count = this.wikiPagePersistence.countByN_T_S(nodeId, title, 2);
        return count > 0;
    }

    public void movePage(long userId, long nodeId, String title, String newTitle, boolean strict, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiPage page4;
        List pageVersions;
        this.validateTitle(newTitle);
        if (title.equalsIgnoreCase(newTitle)) {
            throw new DuplicatePageException(newTitle);
        }
        if (this.isUsedTitle(nodeId, newTitle)) {
            WikiPage page2 = this.getPage(nodeId, newTitle);
            if (page2.getVersion() == 1.0 && page2.getContent().length() < 200 || !strict) {
                this.deletePage(nodeId, newTitle);
            } else {
                throw new DuplicatePageException(newTitle);
            }
        }
        if ((pageVersions = this.wikiPagePersistence.findByN_T(nodeId, title)).size() == 0) {
            return;
        }
        for (WikiPage page3 : pageVersions) {
            page3.setTitle(newTitle);
            this.wikiPagePersistence.update((BaseModel)page3, false);
        }
        List children = this.wikiPagePersistence.findByN_P(nodeId, title);
        for (WikiPage page4 : children) {
            page4.setParentTitle(newTitle);
            this.wikiPagePersistence.update((BaseModel)page4, false);
        }
        page4 = (WikiPage)pageVersions.get(pageVersions.size() - 1);
        long resourcePrimKey = page4.getResourcePrimKey();
        WikiPageResource wikiPageResource = this.wikiPageResourcePersistence.findByPrimaryKey(resourcePrimKey);
        wikiPageResource.setTitle(newTitle);
        this.wikiPageResourcePersistence.update((BaseModel)wikiPageResource, false);
        double version = 1.0;
        String summary = "Moved to " + title;
        String format = page4.getFormat();
        boolean head = true;
        String parentTitle = page4.getParentTitle();
        String redirectTitle = page4.getTitle();
        String content = "[[" + redirectTitle + "]]";
        this.addPage(userId, nodeId, title, version, content, summary, false, format, head, parentTitle, redirectTitle, serviceContext);
        List redirectedPages = this.wikiPagePersistence.findByN_R(nodeId, title);
        for (WikiPage redirectedPage : redirectedPages) {
            redirectedPage.setRedirectTitle(newTitle);
            this.wikiPagePersistence.update((BaseModel)redirectedPage, false);
        }
        this.updateAsset(userId, page4, null, null);
        Indexer indexer = IndexerRegistryUtil.getIndexer(WikiPage.class);
        indexer.delete((Object)new Object[]{page4.getCompanyId(), page4.getNodeId(), title});
        indexer.reindex((Object)page4);
    }

    public void movePage(long userId, long nodeId, String title, String newTitle, ServiceContext serviceContext) throws PortalException, SystemException {
        this.movePage(userId, nodeId, title, newTitle, true, serviceContext);
    }

    public WikiPage revertPage(long userId, long nodeId, String title, double version, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiPage oldPage = this.getPage(nodeId, title, version);
        return this.updatePage(userId, nodeId, title, 0.0, oldPage.getContent(), "Reverted to " + version, false, oldPage.getFormat(), this.getParentPageTitle(oldPage), oldPage.getRedirectTitle(), serviceContext);
    }

    public void subscribePage(long userId, long nodeId, String title) throws PortalException, SystemException {
        WikiPage page = this.getPage(nodeId, title);
        this.subscriptionLocalService.addSubscription(userId, WikiPage.class.getName(), page.getResourcePrimKey());
    }

    public void unsubscribePage(long userId, long nodeId, String title) throws PortalException, SystemException {
        WikiPage page = this.getPage(nodeId, title);
        this.subscriptionLocalService.deleteSubscription(userId, WikiPage.class.getName(), page.getResourcePrimKey());
    }

    public void updateAsset(long userId, WikiPage page, long[] assetCategoryIds, String[] assetTagNames) throws PortalException, SystemException {
        int approvedPagesCount;
        boolean visible = page.isApproved();
        if (!page.isApproved()) {
            visible = true;
        }
        boolean addDraftAssetEntry = false;
        if (!page.isApproved() && page.getVersion() != 1.0 && (approvedPagesCount = this.wikiPagePersistence.countByN_T_S(page.getNodeId(), page.getTitle(), 0)) > 0) {
            addDraftAssetEntry = true;
        }
        if (addDraftAssetEntry) {
            this.assetEntryLocalService.updateEntry(userId, page.getGroupId(), WikiPage.class.getName(), page.getPrimaryKey(), page.getUuid(), assetCategoryIds, assetTagNames, false, null, null, null, null, "text/html", page.getTitle(), null, null, null, 0, 0, null, false);
        } else {
            this.assetEntryLocalService.updateEntry(userId, page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), page.getUuid(), assetCategoryIds, assetTagNames, visible, null, null, null, null, "text/html", page.getTitle(), null, null, null, 0, 0, null, false);
        }
    }

    public WikiPage updatePage(long userId, long nodeId, String title, double version, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        this.validate(nodeId, content, format);
        WikiPage oldPage = null;
        try {
            oldPage = this.wikiPagePersistence.findByN_T_First(nodeId, title, null);
        }
        catch (NoSuchPageException noSuchPageException) {
            return this.addPage(userId, nodeId, title, 1.0, content, summary, minorEdit, format, true, parentTitle, redirectTitle, serviceContext);
        }
        double oldVersion = oldPage.getVersion();
        if (version > 0.0 && version != oldVersion) {
            throw new PageVersionException();
        }
        long resourcePrimKey = this.wikiPageResourceLocalService.getPageResourcePrimKey(nodeId, title);
        long groupId = oldPage.getGroupId();
        WikiPage page = oldPage;
        double newVersion = oldVersion;
        if (oldPage.isApproved()) {
            newVersion = MathUtil.format((double)(oldVersion + 0.1), (int)1, (int)1);
            long pageId = this.counterLocalService.increment();
            page = this.wikiPagePersistence.create(pageId);
        }
        page.setResourcePrimKey(resourcePrimKey);
        page.setGroupId(groupId);
        page.setCompanyId(user.getCompanyId());
        page.setUserId(user.getUserId());
        page.setUserName(user.getFullName());
        page.setCreateDate(serviceContext.getModifiedDate(now));
        page.setModifiedDate(serviceContext.getModifiedDate(now));
        page.setNodeId(nodeId);
        page.setTitle(title);
        page.setVersion(newVersion);
        page.setMinorEdit(minorEdit);
        page.setContent(content);
        if (oldPage.isPending()) {
            page.setStatus(oldPage.getStatus());
        } else {
            page.setStatus(2);
        }
        page.setSummary(summary);
        page.setFormat(format);
        if (Validator.isNotNull((String)parentTitle)) {
            page.setParentTitle(parentTitle);
        }
        if (Validator.isNotNull((String)redirectTitle)) {
            page.setRedirectTitle(redirectTitle);
        }
        this.wikiPagePersistence.update((BaseModel)page, false);
        ExpandoBridge expandoBridge = page.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        node.setLastPostDate(serviceContext.getModifiedDate(now));
        this.wikiNodePersistence.update((BaseModel)node, false);
        this.updateAsset(userId, page, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)page.getGroupId(), (long)userId, (String)WikiPage.class.getName(), (long)page.getResourcePrimKey(), (Object)page, (ServiceContext)serviceContext);
        return page;
    }

    public WikiPage updateStatus(long userId, long resourcePrimKey, int status, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiPageResource wikiPageResource = this.wikiPageResourceLocalService.getPageResource(resourcePrimKey);
        List pages = this.wikiPagePersistence.findByN_T(wikiPageResource.getNodeId(), wikiPageResource.getTitle(), 0, 1, (OrderByComparator)new PageVersionComparator());
        WikiPage page = null;
        if (pages.isEmpty()) {
            throw new NoSuchPageException();
        }
        page = (WikiPage)pages.get(0);
        return this.updateStatus(userId, page, status, serviceContext);
    }

    public WikiPage updateStatus(long userId, WikiPage page, int status, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(page.getNodeId());
        Date now = new Date();
        int oldStatus = page.getStatus();
        page.setStatus(status);
        page.setStatusByUserId(userId);
        page.setStatusByUserName(user.getFullName());
        page.setStatusDate(now);
        if (status == 0) {
            if (oldStatus != 0 && page.getVersion() != 1.0) {
                try {
                    AssetEntry draftAssetEntry = this.assetEntryLocalService.getEntry(WikiPage.class.getName(), page.getPrimaryKey());
                    long[] assetCategoryIds = draftAssetEntry.getCategoryIds();
                    String[] assetTagNames = draftAssetEntry.getTagNames();
                    this.assetEntryLocalService.updateEntry(userId, page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), page.getUuid(), assetCategoryIds, assetTagNames, true, null, null, null, null, "text/html", page.getTitle(), null, null, null, 0, 0, null, false);
                }
                catch (NoSuchEntryException noSuchEntryException) {}
            }
            this.assetEntryLocalService.updateVisible(WikiPage.class.getName(), page.getResourcePrimKey(), true);
            int activity = 1;
            String actionId = "ADD_PAGE";
            if (page.getVersion() > 1.1) {
                activity = 2;
                actionId = "UPDATE";
            }
            this.socialActivityLocalService.addActivity(userId, page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), activity, "", 0L);
            this.socialEquityLogLocalService.addEquityLogs(userId, WikiPage.class.getName(), page.getResourcePrimKey(), actionId);
            if (!page.isMinorEdit() && NotificationThreadLocal.isEnabled()) {
                boolean update = false;
                if (page.getVersion() > 1.1) {
                    update = true;
                }
                this.notifySubscribers(node, page, serviceContext, update);
            }
            Indexer indexer = IndexerRegistryUtil.getIndexer(WikiPage.class);
            indexer.reindex((Object)page);
            this.clearPageCache(page);
            this.clearReferralsCache(page);
            page.setHead(true);
            List pages = this.wikiPagePersistence.findByN_T_H(page.getNodeId(), page.getTitle(), true);
            for (WikiPage curPage : pages) {
                if (curPage.equals(page)) continue;
                curPage.setHead(false);
                this.wikiPagePersistence.update((BaseModel)curPage, false);
            }
        } else {
            page.setHead(false);
            List pages = this.wikiPagePersistence.findByN_T_S(page.getNodeId(), page.getTitle(), 0);
            for (WikiPage curPage : pages) {
                if (curPage.equals(page)) continue;
                curPage.setHead(true);
                this.wikiPagePersistence.update((BaseModel)curPage, false);
                break;
            }
        }
        return (WikiPage)this.wikiPagePersistence.update((BaseModel)page, false);
    }

    public void validateTitle(String title) throws PortalException {
        Pattern pattern;
        Matcher matcher;
        if (title.equals("all_pages") || title.equals("orphan_pages") || title.equals("recent_changes")) {
            throw new PageTitleException(String.valueOf(title) + " is reserved");
        }
        if (Validator.isNotNull((String)PropsValues.WIKI_PAGE_TITLES_REGEXP) && !(matcher = (pattern = Pattern.compile(PropsValues.WIKI_PAGE_TITLES_REGEXP)).matcher(title)).matches()) {
            throw new PageTitleException();
        }
    }

    protected void clearPageCache(WikiPage page) {
        if (!WikiCacheThreadLocal.isClearCache()) {
            return;
        }
        WikiCacheUtil.clearCache(page.getNodeId(), page.getTitle());
    }

    protected void clearReferralsCache(WikiPage page) throws PortalException, SystemException {
        if (!WikiCacheThreadLocal.isClearCache()) {
            return;
        }
        List<WikiPage> links = this.getIncomingLinks(page.getNodeId(), page.getTitle());
        for (WikiPage curPage : links) {
            WikiCacheUtil.clearCache(curPage.getNodeId(), curPage.getTitle());
        }
    }

    protected String getParentPageTitle(WikiPage page) {
        try {
            WikiPage parentPage = this.getPage(page.getNodeId(), page.getParentTitle());
            return parentPage.getTitle();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected WikiPage getPreviousVersionPage(WikiPage page) throws PortalException, SystemException {
        double previousVersion = MathUtil.format((double)(page.getVersion() - 0.1), (int)1, (int)1);
        if (previousVersion < 1.0) {
            return null;
        }
        return this.getPage(page.getNodeId(), page.getTitle(), previousVersion);
    }

    protected boolean isLinkedTo(WikiPage page, String targetTitle) throws PortalException {
        Map<String, Boolean> links = WikiCacheUtil.getOutgoingLinks(page);
        Boolean link = links.get(targetTitle.toLowerCase());
        return link != null;
    }

    protected boolean isUsedTitle(long nodeId, String title) throws SystemException {
        return this.getPagesCount(nodeId, title, true) > 0;
    }

    protected void notifySubscribers(WikiNode node, WikiPage page, ServiceContext serviceContext, boolean update) throws PortalException, SystemException {
        String fromAddress;
        PortletPreferences preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
        if (preferences == null) {
            long ownerId = node.getGroupId();
            int ownerType = 2;
            long plid = 0L;
            String portletId = "36";
            String defaultPreferences = null;
            preferences = this.portletPreferencesLocalService.getPreferences(node.getCompanyId(), ownerId, ownerType, plid, portletId, defaultPreferences);
        }
        if (!(!update && WikiUtil.getEmailPageAddedEnabled(preferences) || update && WikiUtil.getEmailPageUpdatedEnabled(preferences))) {
            return;
        }
        Company company = this.companyPersistence.findByPrimaryKey(page.getCompanyId());
        Group group = this.groupPersistence.findByPrimaryKey(node.getGroupId());
        User user = this.userPersistence.findByPrimaryKey(page.getUserId());
        String portalURL = serviceContext.getPortalURL();
        String layoutFullURL = serviceContext.getLayoutFullURL();
        WikiPage previousVersionPage = this.getPreviousVersionPage(page);
        String attachmentURLPrefix = String.valueOf(portalURL) + serviceContext.getPathMain() + "/wiki/get_page_attachment?p_l_id=" + serviceContext.getPlid() + "&nodeId=" + page.getNodeId() + "&title=" + HttpUtil.encodeURL((String)page.getTitle()) + "&fileName=";
        String pageDiffs = "";
        try {
            pageDiffs = WikiUtil.diffHtml(previousVersionPage, page, null, null, attachmentURLPrefix);
        }
        catch (Exception exception) {}
        String pageContent = null;
        if (Validator.equals((Object)page.getFormat(), (Object)"creole")) {
            pageContent = WikiUtil.convert(page, null, null, attachmentURLPrefix);
        } else {
            pageContent = page.getContent();
            pageContent = WikiUtil.processContent(pageContent);
        }
        String pageURL = "";
        String diffsURL = "";
        if (Validator.isNotNull((String)layoutFullURL)) {
            pageURL = String.valueOf(layoutFullURL) + "/-/" + "wiki/" + node.getNodeId() + "/" + HttpUtil.encodeURL((String)page.getTitle());
            if (previousVersionPage != null) {
                StringBundler sb = new StringBundler(16);
                sb.append(layoutFullURL);
                sb.append("?p_p_id=");
                sb.append("36");
                sb.append("&p_p_state=");
                sb.append((Object)WindowState.MAXIMIZED);
                sb.append("&struts_action=");
                sb.append(HttpUtil.encodeURL((String)"/wiki/compare_versions"));
                sb.append("&nodeId=");
                sb.append(node.getNodeId());
                sb.append("&title=");
                sb.append(HttpUtil.encodeURL((String)page.getTitle()));
                sb.append("&sourceVersion=");
                sb.append(previousVersionPage.getVersion());
                sb.append("&targetVersion=");
                sb.append(page.getVersion());
                sb.append("&type=html");
                diffsURL = sb.toString();
            }
        }
        String portletName = PortalUtil.getPortletTitle((String)"36", (User)user);
        String fromName = WikiUtil.getEmailFromName(preferences);
        String replyToAddress = fromAddress = WikiUtil.getEmailFromAddress(preferences);
        String mailId = WikiUtil.getMailId(company.getMx(), page.getNodeId(), page.getPageId());
        fromName = StringUtil.replace((String)fromName, (String[])new String[]{"[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$COMMUNITY_NAME$]", "[$PAGE_USER_ADDRESS$]", "[$PAGE_USER_NAME$]", "[$PORTLET_NAME$]"}, (String[])new String[]{String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), group.getName(), user.getEmailAddress(), user.getFullName(), portletName});
        fromAddress = StringUtil.replace((String)fromAddress, (String[])new String[]{"[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$COMMUNITY_NAME$]", "[$PAGE_USER_ADDRESS$]", "[$PAGE_USER_NAME$]", "[$PORTLET_NAME$]"}, (String[])new String[]{String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), group.getName(), user.getEmailAddress(), user.getFullName(), portletName});
        String subjectPrefix = null;
        String body = null;
        String signature = null;
        if (update) {
            subjectPrefix = WikiUtil.getEmailPageUpdatedSubjectPrefix(preferences);
            body = WikiUtil.getEmailPageUpdatedBody(preferences);
            signature = WikiUtil.getEmailPageUpdatedSignature(preferences);
        } else {
            subjectPrefix = WikiUtil.getEmailPageAddedSubjectPrefix(preferences);
            body = WikiUtil.getEmailPageAddedBody(preferences);
            signature = WikiUtil.getEmailPageAddedSignature(preferences);
        }
        if (Validator.isNotNull((String)signature)) {
            body = String.valueOf(body) + "\n" + signature;
        }
        subjectPrefix = StringUtil.replace((String)subjectPrefix, (String[])new String[]{"[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$COMMUNITY_NAME$]", "[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$NODE_NAME$]", "[$PAGE_CONTENT$]", "[$PAGE_ID$]", "[$PAGE_TITLE$]", "[$PAGE_USER_ADDRESS$]", "[$PAGE_USER_NAME$]", "[$PORTAL_URL$]", "[$PORTLET_NAME$]"}, (String[])new String[]{String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), group.getName(), fromAddress, fromName, node.getName(), pageContent, String.valueOf(page.getPageId()), page.getTitle(), user.getEmailAddress(), user.getFullName(), company.getVirtualHost(), portletName});
        body = StringUtil.replace((String)body, (String[])new String[]{"[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$COMMUNITY_NAME$]", "[$DIFFS_URL$]", "[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$NODE_NAME$]", "[$PAGE_CONTENT$]", "[$PAGE_DATE_UPDATE$]", "[$PAGE_DIFFS$]", "[$PAGE_ID$]", "[$PAGE_SUMMARY$]", "[$PAGE_TITLE$]", "[$PAGE_URL$]", "[$PAGE_USER_ADDRESS$]", "[$PAGE_USER_NAME$]", "[$PORTAL_URL$]", "[$PORTLET_NAME$]"}, (String[])new String[]{String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), group.getName(), diffsURL, fromAddress, fromName, node.getName(), pageContent, String.valueOf(page.getModifiedDate()), this.replaceStyles(pageDiffs), String.valueOf(page.getPageId()), page.getSummary(), page.getTitle(), pageURL, user.getEmailAddress(), user.getFullName(), company.getVirtualHost(), portletName});
        String subject = page.getTitle();
        if (subject.indexOf(subjectPrefix) == -1) {
            subject = String.valueOf(subjectPrefix) + " " + subject;
        }
        Message message = new Message();
        message.put("companyId", (Object)node.getCompanyId());
        message.put("userId", (Object)node.getUserId());
        message.put("groupId", (Object)node.getGroupId());
        message.put("nodeId", (Object)node.getNodeId());
        message.put("pageResourcePrimKey", (Object)page.getResourcePrimKey());
        message.put("fromName", (Object)fromName);
        message.put("fromAddress", (Object)fromAddress);
        message.put("subject", (Object)subject);
        message.put("body", (Object)body);
        message.put("replyToAddress", (Object)replyToAddress);
        message.put("mailId", (Object)mailId);
        message.put("htmlFormat", (Object)Boolean.TRUE);
        MessageBusUtil.sendMessage((String)"liferay/wiki", (Message)message);
    }

    protected String replaceStyles(String html) {
        return StringUtil.replace((String)html, (String[])new String[]{"class=\"diff-html-added\"", "class=\"diff-html-removed\"", "class=\"diff-html-changed\"", "changeType=\"diff-added-image\"", "changeType=\"diff-removed-image\"", "changeType=\"diff-changed-image\""}, (String[])new String[]{"style=\"background-color: #CFC;\"", "style=\"background-color: #FDC6C6; text-decoration: line-through;\"", "style=\"border-bottom: 2px dotted blue;\"", "style=\"border: 10px solid #CFC;\"", "style=\"border: 10px solid #FDC6C6;\"", "style=\"border: 10px solid blue;\""});
    }

    protected void validate(long nodeId, String content, String format) throws PortalException {
        if (!WikiUtil.validate(nodeId, content, format)) {
            throw new PageContentException();
        }
    }

    protected void validate(String title, long nodeId, String content, String format) throws PortalException, SystemException {
        if (Validator.isNull((String)title)) {
            throw new PageTitleException();
        }
        if (this.isUsedTitle(nodeId, title)) {
            throw new DuplicatePageException();
        }
        this.validateTitle(title);
        this.validate(nodeId, content, format);
    }
}

