/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.impl;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.wiki.DuplicateNodeNameException;
import com.liferay.portlet.wiki.NodeNameException;
import com.liferay.portlet.wiki.importers.WikiImporter;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.base.WikiNodeLocalServiceBaseImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiNodeLocalServiceImpl
extends WikiNodeLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(WikiNodeLocalServiceImpl.class);
    private Map<String, WikiImporter> _wikiImporters = new HashMap<String, WikiImporter>();

    public WikiNode addDefaultNode(long userId, ServiceContext serviceContext) throws PortalException, SystemException {
        String nodeName = PropsUtil.get("wiki.initial.node.name");
        return this.addNode(userId, nodeName, "", serviceContext);
    }

    public WikiNode addNode(long userId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        Date now = new Date();
        this.validate(groupId, name);
        long nodeId = this.counterLocalService.increment();
        WikiNode node = this.wikiNodePersistence.create(nodeId);
        node.setUuid(serviceContext.getUuid());
        node.setGroupId(groupId);
        node.setCompanyId(user.getCompanyId());
        node.setUserId(user.getUserId());
        node.setUserName(user.getFullName());
        node.setCreateDate(serviceContext.getCreateDate(now));
        node.setModifiedDate(serviceContext.getModifiedDate(now));
        node.setName(name);
        node.setDescription(description);
        try {
            this.wikiNodePersistence.update((BaseModel)node, false);
        }
        catch (SystemException se) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Add failed, fetch {groupId=" + groupId + ", name=" + name + "}"));
            }
            if ((node = this.wikiNodePersistence.fetchByG_N(groupId, name, false)) == null) {
                throw se;
            }
            return node;
        }
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addNodeResources(node, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addNodeResources(node, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        return node;
    }

    public void addNodeResources(long nodeId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this.addNodeResources(node, addCommunityPermissions, addGuestPermissions);
    }

    public void addNodeResources(WikiNode node, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(node.getCompanyId(), node.getGroupId(), node.getUserId(), WikiNode.class.getName(), node.getNodeId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addNodeResources(long nodeId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this.addNodeResources(node, communityPermissions, guestPermissions);
    }

    public void addNodeResources(WikiNode node, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(node.getCompanyId(), node.getGroupId(), node.getUserId(), WikiNode.class.getName(), node.getNodeId(), communityPermissions, guestPermissions);
    }

    public void deleteNode(long nodeId) throws PortalException, SystemException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this.deleteNode(node);
    }

    public void deleteNode(WikiNode node) throws PortalException, SystemException {
        Indexer indexer = IndexerRegistryUtil.getIndexer(WikiPage.class);
        indexer.delete((Object)node);
        this.subscriptionLocalService.deleteSubscriptions(node.getCompanyId(), WikiNode.class.getName(), node.getNodeId());
        this.wikiPageLocalService.deletePages(node.getNodeId());
        this.resourceLocalService.deleteResource(node.getCompanyId(), WikiNode.class.getName(), 4, node.getNodeId());
        this.wikiNodePersistence.remove((BaseModel)node);
    }

    public void deleteNodes(long groupId) throws PortalException, SystemException {
        for (WikiNode node : this.wikiNodePersistence.findByGroupId(groupId)) {
            this.deleteNode(node);
        }
    }

    public List<WikiNode> getCompanyNodes(long companyId, int start, int end) throws SystemException {
        return this.wikiNodePersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyNodesCount(long companyId) throws SystemException {
        return this.wikiNodePersistence.countByCompanyId(companyId);
    }

    public WikiNode getNode(long nodeId) throws PortalException, SystemException {
        return this.wikiNodePersistence.findByPrimaryKey(nodeId);
    }

    public WikiNode getNode(long groupId, String nodeName) throws PortalException, SystemException {
        return this.wikiNodePersistence.findByG_N(groupId, nodeName);
    }

    public List<WikiNode> getNodes(long groupId) throws PortalException, SystemException {
        List<WikiNode> nodes = this.wikiNodePersistence.findByGroupId(groupId);
        if (nodes.isEmpty()) {
            nodes = this.addDefaultNode(groupId);
        }
        return nodes;
    }

    public List<WikiNode> getNodes(long groupId, int start, int end) throws PortalException, SystemException {
        List<WikiNode> nodes = this.wikiNodePersistence.findByGroupId(groupId, start, end);
        if (nodes.isEmpty()) {
            nodes = this.addDefaultNode(groupId);
        }
        return nodes;
    }

    public int getNodesCount(long groupId) throws SystemException {
        return this.wikiNodePersistence.countByGroupId(groupId);
    }

    public void importPages(long userId, long nodeId, String importer, File[] files, Map<String, String[]> options) throws PortalException, SystemException {
        WikiNode node = this.getNode(nodeId);
        WikiImporter wikiImporter = this.getWikiImporter(importer);
        wikiImporter.importPages(userId, node, files, options);
    }

    public void subscribeNode(long userId, long nodeId) throws PortalException, SystemException {
        this.subscriptionLocalService.addSubscription(userId, WikiNode.class.getName(), nodeId);
    }

    public void unsubscribeNode(long userId, long nodeId) throws PortalException, SystemException {
        this.subscriptionLocalService.deleteSubscription(userId, WikiNode.class.getName(), nodeId);
    }

    public WikiNode updateNode(long nodeId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this.validate(nodeId, node.getGroupId(), name);
        node.setModifiedDate(serviceContext.getModifiedDate(null));
        node.setName(name);
        node.setDescription(description);
        this.wikiNodePersistence.update((BaseModel)node, false);
        return node;
    }

    protected List<WikiNode> addDefaultNode(long groupId) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        long defaultUserId = this.userLocalService.getDefaultUserId(group.getCompanyId());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(groupId);
        WikiNode node = this.addDefaultNode(defaultUserId, serviceContext);
        ArrayList<WikiNode> nodes = new ArrayList<WikiNode>(1);
        nodes.add(node);
        return nodes;
    }

    protected WikiImporter getWikiImporter(String importer) throws SystemException {
        WikiImporter wikiImporter = this._wikiImporters.get(importer);
        if (wikiImporter == null) {
            String importerClass = PropsUtil.get("wiki.importers.class", new Filter(importer));
            if (importerClass != null) {
                wikiImporter = (WikiImporter)InstancePool.get((String)importerClass);
                this._wikiImporters.put(importer, wikiImporter);
            }
            if (importer == null) {
                throw new SystemException("Unable to instantiate wiki importer class " + importerClass);
            }
        }
        return wikiImporter;
    }

    protected void validate(long groupId, String name) throws PortalException, SystemException {
        this.validate(0L, groupId, name);
    }

    protected void validate(long nodeId, long groupId, String name) throws PortalException, SystemException {
        if (name.equalsIgnoreCase("tag")) {
            throw new NodeNameException(String.valueOf(name) + " is reserved");
        }
        if (!Validator.isName((String)name)) {
            throw new NodeNameException();
        }
        WikiNode node = this.wikiNodePersistence.fetchByG_N(groupId, name);
        if (node != null && node.getNodeId() != nodeId) {
            throw new DuplicateNodeNameException();
        }
    }
}

