/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.asset;

import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.model.BaseAssetRenderer;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.permission.WikiPagePermission;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class WikiPageAssetRenderer
extends BaseAssetRenderer {
    private WikiPage _page;

    public WikiPageAssetRenderer(WikiPage page) {
        this._page = page;
    }

    public long getClassPK() {
        if (!this._page.isApproved() && this._page.getVersion() != 1.0) {
            return this._page.getPageId();
        }
        return this._page.getResourcePrimKey();
    }

    public String getDiscussionPath() {
        if (PropsValues.WIKI_PAGE_COMMENTS_ENABLED) {
            return "edit_page_discussion";
        }
        return null;
    }

    public long getGroupId() {
        return this._page.getGroupId();
    }

    public String getSummary() {
        String content = this._page.getContent();
        if (this._page.getFormat().equals("html")) {
            content = HtmlUtil.stripHtml((String)content);
        }
        return content;
    }

    public String getTitle() {
        return this._page.getTitle();
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        LiferayPortletURL editPortletURL = liferayPortletResponse.createRenderURL("36");
        editPortletURL.setParameter("struts_action", "/wiki/edit_page");
        editPortletURL.setParameter("nodeId", String.valueOf(this._page.getNodeId()));
        editPortletURL.setParameter("title", this._page.getTitle());
        return editPortletURL;
    }

    public PortletURL getURLExport(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        PortletURL exportPortletURL = liferayPortletResponse.createActionURL();
        exportPortletURL.setParameter("struts_action", "/asset_publisher/export_wiki_page");
        exportPortletURL.setParameter("nodeId", String.valueOf(this._page.getNodeId()));
        exportPortletURL.setParameter("title", this._page.getTitle());
        return exportPortletURL;
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("THEME_DISPLAY");
        return String.valueOf(themeDisplay.getPathMain()) + "/wiki/find_page?pageResourcePrimKey=" + this._page.getResourcePrimKey();
    }

    public long getUserId() {
        return this._page.getUserId();
    }

    public String getUuid() {
        return this._page.getUuid();
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) {
        return WikiPagePermission.contains(permissionChecker, this._page, "UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) {
        return WikiPagePermission.contains(permissionChecker, this._page, "VIEW");
    }

    public boolean isConvertible() {
        return true;
    }

    public boolean isPrintable() {
        return true;
    }

    public String render(RenderRequest renderRequest, RenderResponse renderResponse, String template) throws Exception {
        if (template.equals("full_content")) {
            renderRequest.setAttribute("WIKI_PAGE", (Object)this._page);
            return "/html/portlet/wiki/asset/" + template + ".jsp";
        }
        return null;
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/pages.png";
    }
}

