/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.rss.action;

import com.liferay.portal.kernel.portlet.BaseConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ValidatorException;

public class ConfigurationActionImpl
extends BaseConfigurationAction {
    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)actionRequest, (String)portletResource);
        if (cmd.equals("remove-footer-article")) {
            this.removeFooterArticle(actionRequest, preferences);
        } else if (cmd.equals("remove-header-article")) {
            this.removeHeaderArticle(actionRequest, preferences);
        } else if (cmd.equals("set-footer-article")) {
            this.setFooterArticle(actionRequest, preferences);
        } else if (cmd.equals("set-header-article")) {
            this.setHeaderArticle(actionRequest, preferences);
        } else if (cmd.equals("update")) {
            this.updateConfiguration(actionRequest, preferences);
        }
        if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            try {
                preferences.store();
            }
            catch (ValidatorException ve) {
                SessionErrors.add((PortletRequest)actionRequest, (String)ValidatorException.class.getName(), (Object)((Object)ve));
                return;
            }
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(portletConfig.getPortletName()) + ".doConfigure"));
        }
    }

    public String render(PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        return "/html/portlet/rss/configuration.jsp";
    }

    protected void removeFooterArticle(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        preferences.setValues("footer-article-values", new String[]{"0", ""});
    }

    protected void removeHeaderArticle(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        preferences.setValues("header-article-values", new String[]{"0", ""});
    }

    protected void setFooterArticle(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        long articleGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"articleGroupId");
        String articleId = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleId");
        preferences.setValues("footer-article-values", new String[]{String.valueOf(articleGroupId), articleId});
    }

    protected void setHeaderArticle(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        long articleGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"articleGroupId");
        String articleId = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleId");
        preferences.setValues("header-article-values", new String[]{String.valueOf(articleGroupId), articleId});
    }

    protected void updateConfiguration(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        int[] subscriptionIndexes = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"subscriptionIndexes"), (int)0);
        HashMap<Object, String> subscriptions = new HashMap<Object, String>();
        int[] nArray = subscriptionIndexes;
        int n = subscriptionIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int subscriptionIndex = nArray[n2];
            String url = ParamUtil.getString((PortletRequest)actionRequest, (String)("url" + subscriptionIndex));
            String title = ParamUtil.getString((PortletRequest)actionRequest, (String)("title" + subscriptionIndex));
            if (!Validator.isNull((String)url)) {
                subscriptions.put(url, title);
            }
            ++n2;
        }
        String[] urls = new String[subscriptions.size()];
        String[] titles = new String[subscriptions.size()];
        int i = 0;
        for (Map.Entry entry : subscriptions.entrySet()) {
            urls[i] = (String)entry.getKey();
            titles[i] = (String)entry.getValue();
            ++i;
        }
        int n3 = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"entriesPerFeed", (int)4);
        int expandedEntriesPerFeed = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expandedEntriesPerFeed", (int)1);
        boolean showFeedTitle = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"showFeedTitle");
        boolean showFeedPublishedDate = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"showFeedPublishedDate");
        boolean showFeedDescription = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"showFeedDescription");
        boolean showFeedImage = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"showFeedImage");
        String feedImageAlignment = ParamUtil.getString((PortletRequest)actionRequest, (String)"feedImageAlignment");
        boolean showFeedItemAuthor = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"showFeedItemAuthor");
        preferences.setValues("urls", urls);
        preferences.setValues("titles", titles);
        preferences.setValue("items-per-channel", String.valueOf(n3));
        preferences.setValue("expanded-items-per-channel", String.valueOf(expandedEntriesPerFeed));
        preferences.setValue("show-feed-title", String.valueOf(showFeedTitle));
        preferences.setValue("show-feed-published-date", String.valueOf(showFeedPublishedDate));
        preferences.setValue("show-feed-description", String.valueOf(showFeedDescription));
        preferences.setValue("show-feed-image", String.valueOf(showFeedImage));
        preferences.setValue("feed-image-alignment", String.valueOf(feedImageAlignment));
        preferences.setValue("show-feed-item-author", String.valueOf(showFeedItemAuthor));
    }
}

