/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.polls.lar;

import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.polls.model.PollsChoice;
import com.liferay.portlet.polls.model.PollsQuestion;
import com.liferay.portlet.polls.model.PollsVote;
import com.liferay.portlet.polls.service.PollsChoiceLocalServiceUtil;
import com.liferay.portlet.polls.service.PollsQuestionLocalServiceUtil;
import com.liferay.portlet.polls.service.PollsVoteLocalServiceUtil;
import com.liferay.portlet.polls.service.persistence.PollsChoiceFinderUtil;
import com.liferay.portlet.polls.service.persistence.PollsChoiceUtil;
import com.liferay.portlet.polls.service.persistence.PollsQuestionUtil;
import com.liferay.portlet.polls.service.persistence.PollsVoteUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class PollsPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final boolean _ALWAYS_EXPORTABLE = true;
    private static final String _NAMESPACE = "polls";
    private static PortletDataHandlerBoolean _questions = new PortletDataHandlerBoolean("polls", "questions", true, true);
    private static PortletDataHandlerBoolean _votes = new PortletDataHandlerBoolean("polls", "votes");

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_questions, _votes};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_questions, _votes};
    }

    public boolean isAlwaysExportable() {
        return true;
    }

    protected static void exportChoice(PortletDataContext context, Element questionsElement, PollsChoice choice) throws Exception {
        String path = PollsPortletDataHandlerImpl.getChoicePath(context, choice);
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        Element choiceElement = questionsElement.addElement("choice");
        choiceElement.addAttribute("path", path);
        context.addZipEntry(path, (Object)choice);
    }

    protected static void exportQuestion(PortletDataContext context, Element questionsElement, Element choicesElement, Element votesElement, PollsQuestion question) throws Exception {
        if (!context.isWithinDateRange(question.getModifiedDate())) {
            return;
        }
        String path = PollsPortletDataHandlerImpl.getQuestionPath(context, question);
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        Element questionElement = questionsElement.addElement("question");
        questionElement.addAttribute("path", path);
        question.setUserUuid(question.getUserUuid());
        List choices = PollsChoiceUtil.findByQuestionId((long)question.getQuestionId());
        for (PollsChoice choice : choices) {
            PollsPortletDataHandlerImpl.exportChoice(context, choicesElement, choice);
        }
        if (context.getBooleanParameter(_NAMESPACE, "votes")) {
            List votes = PollsVoteUtil.findByQuestionId((long)question.getQuestionId());
            for (PollsVote vote : votes) {
                PollsPortletDataHandlerImpl.exportVote(context, votesElement, vote);
            }
        }
        context.addPermissions(PollsQuestion.class, question.getQuestionId());
        context.addZipEntry(path, (Object)question);
    }

    protected static void exportVote(PortletDataContext context, Element questionsElement, PollsVote vote) throws Exception {
        String path = PollsPortletDataHandlerImpl.getVotePath(context, vote);
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        Element voteEl = questionsElement.addElement("vote");
        voteEl.addAttribute("path", path);
        context.addZipEntry(path, (Object)vote);
    }

    protected static String getChoicePath(PortletDataContext context, PollsChoice choice) {
        StringBundler sb = new StringBundler(6);
        sb.append(context.getPortletPath("25"));
        sb.append("/questions/");
        sb.append(choice.getQuestionId());
        sb.append("/choices/");
        sb.append(choice.getChoiceId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getQuestionPath(PortletDataContext context, PollsQuestion question) {
        StringBundler sb = new StringBundler(4);
        sb.append(context.getPortletPath("25"));
        sb.append("/questions/");
        sb.append(question.getQuestionId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getVotePath(PortletDataContext context, PollsVote vote) {
        StringBundler sb = new StringBundler(6);
        sb.append(context.getPortletPath("25"));
        sb.append("/questions/");
        sb.append(vote.getQuestionId());
        sb.append("/votes/");
        sb.append(vote.getVoteId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static void importChoice(PortletDataContext context, PollsChoice choice) throws Exception {
        Map questionPKs = context.getNewPrimaryKeysMap(PollsQuestion.class);
        long questionId = MapUtil.getLong((Map)questionPKs, (long)choice.getQuestionId(), (long)choice.getQuestionId());
        PollsChoice importedChoice = null;
        if (context.isDataStrategyMirror()) {
            PollsChoice existingChoice = PollsChoiceFinderUtil.fetchByUUID_G((String)choice.getUuid(), (long)context.getScopeGroupId());
            if (existingChoice == null) {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setUuid(choice.getUuid());
                importedChoice = PollsChoiceLocalServiceUtil.addChoice((long)questionId, (String)choice.getName(), (String)choice.getDescription(), (ServiceContext)serviceContext);
            } else {
                importedChoice = PollsChoiceLocalServiceUtil.updateChoice((long)existingChoice.getChoiceId(), (long)questionId, (String)choice.getName(), (String)choice.getDescription());
            }
        } else {
            importedChoice = PollsChoiceLocalServiceUtil.addChoice((long)questionId, (String)choice.getName(), (String)choice.getDescription(), (ServiceContext)new ServiceContext());
        }
        Map choicePKs = context.getNewPrimaryKeysMap(PollsChoice.class);
        choicePKs.put(choice.getChoiceId(), importedChoice.getChoiceId());
        context.importPermissions(PollsChoice.class, choice.getChoiceId(), importedChoice.getChoiceId());
    }

    protected static void importQuestion(PortletDataContext context, PollsQuestion question) throws Exception {
        long userId = context.getUserId(question.getUserUuid());
        Date expirationDate = question.getExpirationDate();
        int expirationMonth = 0;
        int expirationDay = 0;
        int expirationYear = 0;
        int expirationHour = 0;
        int expirationMinute = 0;
        boolean neverExpire = true;
        if (expirationDate != null) {
            Calendar expirationCal = CalendarFactoryUtil.getCalendar();
            expirationCal.setTime(expirationDate);
            expirationMonth = expirationCal.get(2);
            expirationDay = expirationCal.get(5);
            expirationYear = expirationCal.get(1);
            expirationHour = expirationCal.get(10);
            expirationMinute = expirationCal.get(12);
            neverExpire = false;
            if (expirationCal.get(9) == 1) {
                expirationHour += 12;
            }
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setCreateDate(question.getCreateDate());
        serviceContext.setModifiedDate(question.getModifiedDate());
        serviceContext.setScopeGroupId(context.getScopeGroupId());
        PollsQuestion importedQuestion = null;
        if (context.isDataStrategyMirror()) {
            PollsQuestion existingQuestion = PollsQuestionUtil.fetchByUUID_G((String)question.getUuid(), (long)context.getScopeGroupId());
            if (existingQuestion == null) {
                serviceContext.setUuid(question.getUuid());
                importedQuestion = PollsQuestionLocalServiceUtil.addQuestion((long)userId, (Map)question.getTitleMap(), (Map)question.getDescriptionMap(), (int)expirationMonth, (int)expirationDay, (int)expirationYear, (int)expirationHour, (int)expirationMinute, (boolean)neverExpire, null, (ServiceContext)serviceContext);
            } else {
                importedQuestion = PollsQuestionLocalServiceUtil.updateQuestion((long)userId, (long)existingQuestion.getQuestionId(), (Map)question.getTitleMap(), (Map)question.getDescriptionMap(), (int)expirationMonth, (int)expirationDay, (int)expirationYear, (int)expirationHour, (int)expirationMinute, (boolean)neverExpire, null, (ServiceContext)serviceContext);
            }
        } else {
            importedQuestion = PollsQuestionLocalServiceUtil.addQuestion((long)userId, (Map)question.getTitleMap(), (Map)question.getDescriptionMap(), (int)expirationMonth, (int)expirationDay, (int)expirationYear, (int)expirationHour, (int)expirationMinute, (boolean)neverExpire, null, (ServiceContext)serviceContext);
        }
        Map questionPKs = context.getNewPrimaryKeysMap(PollsQuestion.class);
        questionPKs.put(question.getQuestionId(), importedQuestion.getQuestionId());
        context.importPermissions(PollsQuestion.class, question.getQuestionId(), importedQuestion.getQuestionId());
    }

    protected static void importVote(PortletDataContext context, PollsVote vote) throws Exception {
        long userId = context.getUserId(vote.getUserUuid());
        Map questionPKs = context.getNewPrimaryKeysMap(PollsQuestion.class);
        long questionId = MapUtil.getLong((Map)questionPKs, (long)vote.getQuestionId(), (long)vote.getQuestionId());
        Map choicePKs = context.getNewPrimaryKeysMap(PollsChoice.class);
        long choiceId = MapUtil.getLong((Map)choicePKs, (long)vote.getChoiceId(), (long)vote.getChoiceId());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCreateDate(vote.getVoteDate());
        PollsVoteLocalServiceUtil.addVote((long)userId, (long)questionId, (long)choiceId, (ServiceContext)serviceContext);
    }

    protected PortletPreferences doDeleteData(PortletDataContext context, String portletId, PortletPreferences preferences) throws Exception {
        if (!context.addPrimaryKey(PollsPortletDataHandlerImpl.class, "deleteData")) {
            PollsQuestionLocalServiceUtil.deleteQuestions((long)context.getScopeGroupId());
        }
        return null;
    }

    protected String doExportData(PortletDataContext context, String portletId, PortletPreferences preferences) throws Exception {
        context.addPermissions("com.liferay.portlet.polls", context.getScopeGroupId());
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("polls-data");
        rootElement.addAttribute("group-id", String.valueOf(context.getScopeGroupId()));
        Element questionsElement = rootElement.addElement("questions");
        Element choicesElement = rootElement.addElement("choices");
        Element votesElement = rootElement.addElement("votes");
        List questions = PollsQuestionUtil.findByGroupId((long)context.getScopeGroupId());
        for (PollsQuestion question : questions) {
            PollsPortletDataHandlerImpl.exportQuestion(context, questionsElement, choicesElement, votesElement, question);
        }
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws Exception {
        context.importPermissions("com.liferay.portlet.polls", context.getSourceGroupId(), context.getScopeGroupId());
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        Element questionsElement = rootElement.element("questions");
        for (Element questionElement : questionsElement.elements("question")) {
            String path = questionElement.attributeValue("path");
            if (!context.isPathNotProcessed(path)) continue;
            PollsQuestion question = (PollsQuestion)context.getZipEntryAsObject(path);
            PollsPortletDataHandlerImpl.importQuestion(context, question);
        }
        Element choicesElement = rootElement.element("choices");
        for (Element choiceElement : choicesElement.elements("choice")) {
            String path = choiceElement.attributeValue("path");
            if (!context.isPathNotProcessed(path)) continue;
            PollsChoice choice = (PollsChoice)context.getZipEntryAsObject(path);
            PollsPortletDataHandlerImpl.importChoice(context, choice);
        }
        if (context.getBooleanParameter(_NAMESPACE, "votes")) {
            Element votesElement = rootElement.element("votes");
            for (Element voteElement : votesElement.elements("vote")) {
                String path = voteElement.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                PollsVote vote = (PollsVote)context.getZipEntryAsObject(path);
                PollsPortletDataHandlerImpl.importVote(context, vote);
            }
        }
        return null;
    }
}

