/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.ContentUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.messageboards.model.MBBan;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBCategoryConstants;
import com.liferay.portlet.messageboards.model.MBMailingList;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBStatsUser;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMailingListLocalServiceUtil;
import com.liferay.portlet.messageboards.util.MBMailMessage;
import com.liferay.util.mail.JavaMailUtil;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Part;
import javax.mail.internet.MimeMultipart;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class MBUtil {
    public static final String POP_PORTLET_PREFIX = "mb.";
    public static final int POP_SERVER_SUBDOMAIN_LENGTH = PropsValues.POP_SERVER_SUBDOMAIN.length();
    private static Log _log = LogFactoryUtil.getLog(MBUtil.class);

    public static void addPortletBreadcrumbEntries(long categoryId, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        if (categoryId == MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID || categoryId == MBCategoryConstants.DISCUSSION_CATEGORY_ID) {
            return;
        }
        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)categoryId);
        MBUtil.addPortletBreadcrumbEntries(category, request, renderResponse);
    }

    public static void addPortletBreadcrumbEntries(MBCategory category, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        String strutsAction = ParamUtil.getString((HttpServletRequest)request, (String)"struts_action");
        boolean selectCategory = strutsAction.equals("/message_boards/select_category");
        PortletURL portletURL = renderResponse.createRenderURL();
        if (selectCategory) {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
            portletURL.setWindowState(LiferayWindowState.POP_UP);
            portletURL.setParameter("struts_action", "/message_boards/select_category");
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)themeDisplay.translate("categories"), (String)portletURL.toString());
        } else {
            portletURL.setParameter("struts_action", "/message_boards/view");
            portletURL.setParameter("tabs1", "categories");
        }
        List ancestorCategories = category.getAncestors();
        Collections.reverse(ancestorCategories);
        for (MBCategory curCategory : ancestorCategories) {
            portletURL.setParameter("mbCategoryId", String.valueOf(curCategory.getCategoryId()));
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)curCategory.getName(), (String)portletURL.toString());
        }
        portletURL.setParameter("mbCategoryId", String.valueOf(category.getCategoryId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)category.getName(), (String)portletURL.toString());
    }

    public static void addPortletBreadcrumbEntries(MBMessage message, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        if (message.getCategoryId() == MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID || message.getCategoryId() == MBCategoryConstants.DISCUSSION_CATEGORY_ID) {
            return;
        }
        MBCategory category = message.getCategory();
        MBUtil.addPortletBreadcrumbEntries(category, request, renderResponse);
        PortletURL portletURL = renderResponse.createRenderURL();
        portletURL.setParameter("struts_action", "/message_boards/view_message");
        portletURL.setParameter("tabs1", "categories");
        portletURL.setParameter("messageId", String.valueOf(message.getMessageId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)message.getSubject(), (String)portletURL.toString());
    }

    public static void collectMultipartContent(MimeMultipart multipart, MBMailMessage collector) throws Exception {
        int i = 0;
        while (i < multipart.getCount()) {
            BodyPart part = multipart.getBodyPart(i);
            MBUtil.collectPartContent((Part)part, collector);
            ++i;
        }
    }

    public static void collectPartContent(Part part, MBMailMessage collector) throws Exception {
        Object partContent = part.getContent();
        String contentType = part.getContentType().toLowerCase();
        if (part.getDisposition() != null && part.getDisposition().equalsIgnoreCase("attachment")) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processing attachment");
            }
            byte[] bytes = null;
            if (partContent instanceof String) {
                bytes = ((String)partContent).getBytes();
            } else if (partContent instanceof InputStream) {
                bytes = JavaMailUtil.getBytes((Part)part);
            }
            collector.addFile(part.getFileName(), bytes);
        } else if (partContent instanceof MimeMultipart) {
            MBUtil.collectMultipartContent((MimeMultipart)partContent, collector);
        } else if (partContent instanceof String) {
            if (contentType.startsWith("text/html")) {
                collector.setHtmlBody((String)partContent);
            } else {
                collector.setPlainBody((String)partContent);
            }
        }
    }

    public static long getCategoryId(HttpServletRequest request, MBCategory category) {
        long categoryId = MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID;
        if (category != null) {
            categoryId = category.getCategoryId();
        }
        categoryId = ParamUtil.getLong((HttpServletRequest)request, (String)"mbCategoryId", (long)categoryId);
        return categoryId;
    }

    public static long getCategoryId(HttpServletRequest request, MBMessage message) {
        long categoryId = MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID;
        if (message != null) {
            categoryId = message.getCategoryId();
        }
        categoryId = ParamUtil.getLong((HttpServletRequest)request, (String)"mbCategoryId", (long)categoryId);
        return categoryId;
    }

    public static String getEmailFromAddress(PortletPreferences preferences) {
        String emailFromAddress = PropsValues.MESSAGE_BOARDS_EMAIL_FROM_ADDRESS;
        return preferences.getValue("email-from-address", emailFromAddress);
    }

    public static String getEmailFromName(PortletPreferences preferences) {
        String emailFromName = PropsValues.MESSAGE_BOARDS_EMAIL_FROM_NAME;
        return preferences.getValue("email-from-name", emailFromName);
    }

    public static boolean getEmailHtmlFormat(PortletPreferences preferences) {
        String emailHtmlFormat = preferences.getValue("email-html-format", "");
        if (Validator.isNotNull((String)emailHtmlFormat)) {
            return GetterUtil.getBoolean((String)emailHtmlFormat);
        }
        return PropsValues.MESSAGE_BOARDS_EMAIL_HTML_FORMAT;
    }

    public static String getEmailMessageAddedBody(PortletPreferences preferences) {
        String emailMessageAddedBody = preferences.getValue("email-message-added-body", "");
        if (Validator.isNotNull((String)emailMessageAddedBody)) {
            return emailMessageAddedBody;
        }
        return ContentUtil.get(PropsValues.MESSAGE_BOARDS_EMAIL_MESSAGE_ADDED_BODY);
    }

    public static boolean getEmailMessageAddedEnabled(PortletPreferences preferences) {
        String emailMessageAddedEnabled = preferences.getValue("email-message-added-enabled", "");
        if (Validator.isNotNull((String)emailMessageAddedEnabled)) {
            return GetterUtil.getBoolean((String)emailMessageAddedEnabled);
        }
        return PropsValues.MESSAGE_BOARDS_EMAIL_MESSAGE_ADDED_ENABLED;
    }

    public static String getEmailMessageAddedSignature(PortletPreferences preferences) {
        String emailMessageAddedSignature = preferences.getValue("email-message-added-signature", "");
        if (Validator.isNotNull((String)emailMessageAddedSignature)) {
            return emailMessageAddedSignature;
        }
        return ContentUtil.get(PropsValues.MESSAGE_BOARDS_EMAIL_MESSAGE_ADDED_SIGNATURE);
    }

    public static String getEmailMessageAddedSubjectPrefix(PortletPreferences preferences) {
        String emailMessageAddedSubjectPrefix = preferences.getValue("email-message-added-subject-prefix", "");
        if (Validator.isNotNull((String)emailMessageAddedSubjectPrefix)) {
            return emailMessageAddedSubjectPrefix;
        }
        return ContentUtil.get(PropsValues.MESSAGE_BOARDS_EMAIL_MESSAGE_ADDED_SUBJECT_PREFIX);
    }

    public static String getEmailMessageUpdatedBody(PortletPreferences preferences) {
        String emailMessageUpdatedBody = preferences.getValue("email-message-updated-body", "");
        if (Validator.isNotNull((String)emailMessageUpdatedBody)) {
            return emailMessageUpdatedBody;
        }
        return ContentUtil.get(PropsValues.MESSAGE_BOARDS_EMAIL_MESSAGE_UPDATED_BODY);
    }

    public static boolean getEmailMessageUpdatedEnabled(PortletPreferences preferences) {
        String emailMessageUpdatedEnabled = preferences.getValue("email-message-updated-enabled", "");
        if (Validator.isNotNull((String)emailMessageUpdatedEnabled)) {
            return GetterUtil.getBoolean((String)emailMessageUpdatedEnabled);
        }
        return PropsValues.MESSAGE_BOARDS_EMAIL_MESSAGE_UPDATED_ENABLED;
    }

    public static String getEmailMessageUpdatedSignature(PortletPreferences preferences) {
        String emailMessageUpdatedSignature = preferences.getValue("email-message-updated-signature", "");
        if (Validator.isNotNull((String)emailMessageUpdatedSignature)) {
            return emailMessageUpdatedSignature;
        }
        return ContentUtil.get(PropsValues.MESSAGE_BOARDS_EMAIL_MESSAGE_UPDATED_SIGNATURE);
    }

    public static String getEmailMessageUpdatedSubjectPrefix(PortletPreferences preferences) {
        String emailMessageUpdatedSubject = preferences.getValue("email-message-updated-subject-prefix", "");
        if (Validator.isNotNull((String)emailMessageUpdatedSubject)) {
            return emailMessageUpdatedSubject;
        }
        return ContentUtil.get(PropsValues.MESSAGE_BOARDS_EMAIL_MESSAGE_UPDATED_SUBJECT_PREFIX);
    }

    public static String getMailId(String mx, long categoryId, long messageId) {
        StringBundler sb = new StringBundler(10);
        sb.append("<");
        sb.append(POP_PORTLET_PREFIX);
        sb.append(categoryId);
        sb.append(".");
        sb.append(messageId);
        sb.append("@");
        if (Validator.isNotNull((String)PropsValues.POP_SERVER_SUBDOMAIN)) {
            sb.append(PropsValues.POP_SERVER_SUBDOMAIN);
            sb.append(".");
        }
        sb.append(mx);
        sb.append(">");
        return sb.toString();
    }

    public static String getMailingListAddress(long groupId, long categoryId, long messageId, String mx, String defaultMailingListAddress) {
        if (POP_SERVER_SUBDOMAIN_LENGTH <= 0) {
            String mailingListAddress = defaultMailingListAddress;
            try {
                MBMailingList mailingList = MBMailingListLocalServiceUtil.getCategoryMailingList((long)groupId, (long)categoryId);
                if (mailingList.isActive()) {
                    mailingListAddress = mailingList.getEmailAddress();
                }
            }
            catch (Exception exception) {}
            return mailingListAddress;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(POP_PORTLET_PREFIX);
        sb.append(categoryId);
        sb.append(".");
        sb.append(messageId);
        sb.append("@");
        sb.append(PropsValues.POP_SERVER_SUBDOMAIN);
        sb.append(".");
        sb.append(mx);
        return sb.toString();
    }

    public static long getMessageId(String mailId) {
        String temp;
        int z;
        int x = mailId.indexOf(60) + 1;
        int y = mailId.indexOf(64);
        long messageId = 0L;
        if (x > 0 && y != -1 && (z = (temp = mailId.substring(x, y)).lastIndexOf(46)) != -1) {
            messageId = GetterUtil.getLong((String)temp.substring(z + 1));
        }
        return messageId;
    }

    public static long getParentMessageId(Message message) throws Exception {
        long parentMessageId = -1L;
        String parentHeader = MBUtil.getParentMessageIdString(message);
        if (parentHeader != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Parent header " + parentHeader));
            }
            parentMessageId = MBUtil.getMessageId(parentHeader);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Previous message id " + parentMessageId));
            }
        }
        return parentMessageId;
    }

    public static String getParentMessageIdString(Message message) throws Exception {
        String[] inReplyToHeaders;
        String reference;
        int x;
        String parentHeader = null;
        String[] references = message.getHeader("References");
        if (references != null && references.length > 0 && (x = (reference = references[0]).lastIndexOf("<mb.")) > -1) {
            int y = reference.indexOf(">", x);
            parentHeader = reference.substring(x, y);
        }
        if (parentHeader == null && (inReplyToHeaders = message.getHeader("In-Reply-To")) != null && inReplyToHeaders.length > 0) {
            parentHeader = inReplyToHeaders[0];
        }
        if (Validator.isNull(parentHeader) || !parentHeader.startsWith(POP_PORTLET_PREFIX, 1)) {
            parentHeader = MBUtil._getParentMessageIdFromSubject(message);
        }
        return parentHeader;
    }

    public static String getSubjectWithoutMessageId(Message message) throws Exception {
        int pos;
        String subject = message.getSubject();
        String parentMessageId = MBUtil._getParentMessageIdFromSubject(message);
        if (Validator.isNotNull((String)parentMessageId) && (pos = subject.indexOf(parentMessageId)) != -1) {
            subject = subject.substring(0, pos);
        }
        return subject;
    }

    public static String[] getThreadPriority(PortletPreferences preferences, String languageId, double value, ThemeDisplay themeDisplay) throws Exception {
        String[] priorities = LocalizationUtil.getPreferencesValues((PortletPreferences)preferences, (String)"priorities", (String)languageId);
        String[] priorityPair = MBUtil._findThreadPriority(value, themeDisplay, priorities);
        if (priorityPair == null) {
            String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
            priorities = LocalizationUtil.getPreferencesValues((PortletPreferences)preferences, (String)"priorities", (String)defaultLanguageId);
            priorityPair = MBUtil._findThreadPriority(value, themeDisplay, priorities);
        }
        return priorityPair;
    }

    public static Date getUnbanDate(MBBan ban, int expireInterval) {
        Date banDate = ban.getCreateDate();
        Calendar cal = Calendar.getInstance();
        cal.setTime(banDate);
        cal.add(5, expireInterval);
        return cal.getTime();
    }

    public static String getUserRank(PortletPreferences preferences, String languageId, int posts) throws Exception {
        String rank = "";
        String[] ranks = LocalizationUtil.getPreferencesValues((PortletPreferences)preferences, (String)"ranks", (String)languageId);
        int i = 0;
        while (i < ranks.length) {
            String[] kvp = StringUtil.split((String)ranks[i], (String)"=");
            String kvpName = kvp[0];
            int kvpPosts = GetterUtil.getInteger((String)kvp[1]);
            if (posts < kvpPosts) break;
            rank = kvpName;
            ++i;
        }
        return rank;
    }

    public static String[] getUserRank(PortletPreferences preferences, String languageId, MBStatsUser statsUser) throws Exception {
        String[] rank = new String[]{"", ""};
        int maxPosts = 0;
        Group group = GroupLocalServiceUtil.getGroup((long)statsUser.getGroupId());
        long companyId = group.getCompanyId();
        String[] ranks = LocalizationUtil.getPreferencesValues((PortletPreferences)preferences, (String)"ranks", (String)languageId);
        int i = 0;
        while (i < ranks.length) {
            block7: {
                String[] kvp = StringUtil.split((String)ranks[i], (String)"=");
                String curRank = kvp[0];
                String curRankValue = kvp[1];
                String[] curRankValueKvp = StringUtil.split((String)curRankValue, (String)":");
                if (curRankValueKvp.length <= 1) {
                    int posts = GetterUtil.getInteger((String)curRankValue);
                    if (posts <= statsUser.getMessageCount() && posts >= maxPosts) {
                        rank[0] = curRank;
                        maxPosts = posts;
                    }
                } else {
                    String entityType = curRankValueKvp[0];
                    String entityValue = curRankValueKvp[1];
                    try {
                        if (MBUtil._isEntityRank(companyId, statsUser, entityType, entityValue)) {
                            rank[1] = curRank;
                            break;
                        }
                    }
                    catch (Exception e) {
                        if (!_log.isWarnEnabled()) break block7;
                        _log.warn((Throwable)e);
                    }
                }
            }
            ++i;
        }
        return rank;
    }

    public static boolean hasMailIdHeader(Message message) throws Exception {
        String[] messageIds = message.getHeader("Message-ID");
        if (messageIds == null) {
            return false;
        }
        String[] stringArray = messageIds;
        int n = messageIds.length;
        int n2 = 0;
        while (n2 < n) {
            String messageId = stringArray[n2];
            if (Validator.isNotNull((String)PropsValues.POP_SERVER_SUBDOMAIN) && messageId.contains(PropsValues.POP_SERVER_SUBDOMAIN)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isAllowAnonymousPosting(PortletPreferences preferences) {
        String allowAnonymousPosting = preferences.getValue("allow-anonymous-posting", "");
        if (Validator.isNotNull((String)allowAnonymousPosting)) {
            return GetterUtil.getBoolean((String)allowAnonymousPosting);
        }
        return PropsValues.MESSAGE_BOARDS_ANONYMOUS_POSTING_ENABLED;
    }

    private static String[] _findThreadPriority(double value, ThemeDisplay themeDisplay, String[] priorities) {
        int i = 0;
        while (i < priorities.length) {
            String[] priority = StringUtil.split((String)priorities[i]);
            try {
                String priorityName = priority[0];
                String priorityImage = priority[1];
                double priorityValue = GetterUtil.getDouble((String)priority[2]);
                if (value == priorityValue) {
                    if (!priorityImage.startsWith("http")) {
                        priorityImage = String.valueOf(themeDisplay.getPathThemeImages()) + priorityImage;
                    }
                    return new String[]{priorityName, priorityImage};
                }
            }
            catch (Exception e) {
                _log.error((Object)"Unable to determine thread priority", (Throwable)e);
            }
            ++i;
        }
        return null;
    }

    private static String _getParentMessageIdFromSubject(Message message) throws Exception {
        String parentMessageId = null;
        String subject = StringUtil.reverse((String)message.getSubject());
        int pos = subject.indexOf(60);
        if (pos != -1) {
            parentMessageId = StringUtil.reverse((String)subject.substring(0, pos + 1));
        }
        return parentMessageId;
    }

    private static boolean _isEntityRank(long companyId, MBStatsUser statsUser, String entityType, String entityValue) throws Exception {
        UserGroup userGroup;
        Organization organization;
        Role role;
        long groupId = statsUser.getGroupId();
        long userId = statsUser.getUserId();
        return entityType.equals("community-role") || entityType.equals("organization-role") ? UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)userId, (long)groupId, (long)(role = RoleLocalServiceUtil.getRole((long)companyId, (String)entityValue)).getRoleId(), (boolean)true) : (entityType.equals("organization") ? OrganizationLocalServiceUtil.hasUserOrganization((long)userId, (long)(organization = OrganizationLocalServiceUtil.getOrganization((long)companyId, (String)entityValue)).getOrganizationId(), (boolean)false, (boolean)true, (boolean)false) : (entityType.equals("regular-role") ? RoleLocalServiceUtil.hasUserRole((long)userId, (long)companyId, (String)entityValue, (boolean)true) : entityType.equals("user-group") && UserLocalServiceUtil.hasUserGroupUser((long)(userGroup = UserGroupLocalServiceUtil.getUserGroup((long)companyId, (String)entityValue)).getUserGroupId(), (long)userId)));
    }
}

