/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermissionUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBBanLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import java.util.List;

public class MBDiscussionPermission {
    public static void check(PermissionChecker permissionChecker, long companyId, long groupId, String className, long classPK, long messageId, String actionId) throws PortalException, SystemException {
        if (!MBDiscussionPermission.contains(permissionChecker, companyId, groupId, className, classPK, messageId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long companyId, long groupId, String className, long classPK, String actionId) throws PortalException, SystemException {
        if (!MBDiscussionPermission.contains(permissionChecker, companyId, groupId, className, classPK, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long companyId, long groupId, String className, long classPK, long messageId, String actionId) throws PortalException, SystemException {
        Boolean hasPermission;
        MBMessage message = MBMessageLocalServiceUtil.getMessage((long)messageId);
        if (message.isPending() && (hasPermission = WorkflowPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)message.getGroupId(), (String)message.getWorkflowClassName(), (long)message.getMessageId(), (String)actionId)) != null) {
            return hasPermission;
        }
        return MBDiscussionPermission.contains(permissionChecker, companyId, groupId, className, classPK, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long companyId, long groupId, String className, long classPK, String actionId) throws SystemException {
        List<String> resourceActions = ResourceActionsUtil.getResourceActions(className);
        if (!resourceActions.contains(actionId)) {
            return true;
        }
        if (MBBanLocalServiceUtil.hasBan((long)groupId, (long)permissionChecker.getUserId())) {
            return false;
        }
        return permissionChecker.hasPermission(groupId, className, classPK, actionId);
    }
}

