/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Lock;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.messageboards.LockedThreadException;
import com.liferay.portlet.messageboards.model.MBCategoryConstants;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.impl.MBThreadModelImpl;
import com.liferay.portlet.messageboards.service.base.MBThreadServiceBaseImpl;
import com.liferay.portlet.messageboards.service.permission.MBCategoryPermission;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBThreadServiceImpl
extends MBThreadServiceBaseImpl {
    public void deleteThread(long threadId) throws PortalException, SystemException {
        if (this.lockLocalService.isLocked(MBThread.class.getName(), threadId)) {
            throw new LockedThreadException();
        }
        List messages = this.mbMessagePersistence.findByThreadId(threadId);
        for (MBMessage message : messages) {
            MBMessagePermission.check(this.getPermissionChecker(), message.getMessageId(), "DELETE");
        }
        this.mbThreadLocalService.deleteThread(threadId);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, int status, boolean subscribed, boolean includeAnonymous, int start, int end) throws PortalException, SystemException {
        long[] categoryIds = this.mbCategoryService.getCategoryIds(groupId, MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID);
        if (categoryIds.length == 0) {
            return Collections.EMPTY_LIST;
        }
        if (userId <= 0L) {
            if (status == -1) {
                return this.mbThreadPersistence.findByG_C(groupId, categoryIds, start, end);
            }
            return this.mbThreadPersistence.findByG_C_S(groupId, categoryIds, status, start, end);
        }
        if (subscribed) {
            return this.mbThreadFinder.filterFindByS_G_U_C_S(groupId, userId, categoryIds, status, start, end);
        }
        List threadIds = null;
        threadIds = includeAnonymous ? this.mbMessageFinder.filterFindByG_U_C_S(groupId, userId, categoryIds, status, start, end) : this.mbMessageFinder.filterFindByG_U_C_A_S(groupId, userId, categoryIds, false, status, start, end);
        ArrayList<MBThread> threads = new ArrayList<MBThread>(threadIds.size());
        Iterator iterator = threadIds.iterator();
        while (iterator.hasNext()) {
            long threadId = (Long)iterator.next();
            MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
            threads.add(thread);
        }
        return threads;
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, int status, boolean subscribed, int start, int end) throws PortalException, SystemException {
        return this.getGroupThreads(groupId, userId, status, subscribed, true, start, end);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, int status, int start, int end) throws PortalException, SystemException {
        return this.getGroupThreads(groupId, userId, status, false, start, end);
    }

    public int getGroupThreadsCount(long groupId, long userId, int status) throws SystemException {
        return this.getGroupThreadsCount(groupId, userId, status, false);
    }

    public int getGroupThreadsCount(long groupId, long userId, int status, boolean subscribed) throws SystemException {
        return this.getGroupThreadsCount(groupId, userId, status, subscribed, true);
    }

    public int getGroupThreadsCount(long groupId, long userId, int status, boolean subscribed, boolean includeAnonymous) throws SystemException {
        long[] categoryIds = this.mbCategoryService.getCategoryIds(groupId, MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID);
        if (categoryIds.length == 0) {
            return 0;
        }
        if (userId <= 0L) {
            if (status == -1) {
                return this.mbThreadPersistence.countByG_C(groupId, categoryIds);
            }
            return this.mbThreadPersistence.countByG_C_S(groupId, categoryIds, status);
        }
        if (subscribed) {
            return this.mbThreadFinder.filterCountByS_G_U_C_S(groupId, userId, categoryIds, status);
        }
        if (includeAnonymous) {
            return this.mbMessageFinder.filterCountByG_U_C_S(groupId, userId, categoryIds, status);
        }
        return this.mbMessageFinder.filterCountByG_U_C_A_S(groupId, userId, categoryIds, false, status);
    }

    public List<MBThread> getThreads(long groupId, long categoryId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.mbThreadFinder.filterFindByG_C(groupId, categoryId, start, end);
        }
        return this.mbThreadFinder.filterFindByG_C_S(groupId, categoryId, status, start, end);
    }

    public int getThreadsCount(long groupId, long categoryId, int status) throws SystemException {
        if (status == -1) {
            return this.mbThreadFinder.filterCountByG_C(groupId, categoryId);
        }
        return this.mbThreadFinder.filterCountByG_C_S(groupId, categoryId, status);
    }

    public Lock lockThread(long threadId) throws PortalException, SystemException {
        MBThread thread = this.mbThreadLocalService.getThread(threadId);
        MBCategoryPermission.check(this.getPermissionChecker(), thread.getGroupId(), thread.getCategoryId(), "LOCK_THREAD");
        return this.lockLocalService.lock(this.getUserId(), MBThread.class.getName(), threadId, String.valueOf(threadId), false, MBThreadModelImpl.LOCK_EXPIRATION_TIME);
    }

    public MBThread moveThread(long categoryId, long threadId) throws PortalException, SystemException {
        MBThread thread = this.mbThreadLocalService.getThread(threadId);
        MBCategoryPermission.check(this.getPermissionChecker(), thread.getGroupId(), thread.getCategoryId(), "MOVE_THREAD");
        MBCategoryPermission.check(this.getPermissionChecker(), thread.getGroupId(), categoryId, "MOVE_THREAD");
        return this.mbThreadLocalService.moveThread(thread.getGroupId(), categoryId, threadId);
    }

    public MBThread splitThread(long messageId, ServiceContext serviceContext) throws PortalException, SystemException {
        MBMessage message = this.mbMessageLocalService.getMessage(messageId);
        MBCategoryPermission.check(this.getPermissionChecker(), message.getGroupId(), message.getCategoryId(), "MOVE_THREAD");
        return this.mbThreadLocalService.splitThread(messageId, serviceContext);
    }

    public void unlockThread(long threadId) throws PortalException, SystemException {
        MBThread thread = this.mbThreadLocalService.getThread(threadId);
        MBCategoryPermission.check(this.getPermissionChecker(), thread.getGroupId(), thread.getCategoryId(), "LOCK_THREAD");
        this.lockLocalService.unlock(MBThread.class.getName(), threadId);
    }
}

