/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.pop;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.pop.MessageListener;
import com.liferay.portal.kernel.pop.MessageListenerException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionCheckerUtil;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.messageboards.NoSuchCategoryException;
import com.liferay.portlet.messageboards.NoSuchMessageException;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBCategoryConstants;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageServiceUtil;
import com.liferay.portlet.messageboards.util.MBMailMessage;
import com.liferay.portlet.messageboards.util.MBUtil;
import javax.mail.Message;
import javax.mail.Part;
import org.apache.commons.lang.time.StopWatch;

public class MessageListenerImpl
implements MessageListener {
    private static Log _log = LogFactoryUtil.getLog(MessageListenerImpl.class);

    public boolean accept(String from, String recipient, Message message) {
        Company company;
        block7: {
            String messageId;
            block6: {
                try {
                    messageId = this.getMessageId(recipient, message);
                    if (messageId != null && messageId.startsWith("mb.", this.getOffset())) break block6;
                    return false;
                }
                catch (Exception e) {
                    if (_log.isErrorEnabled()) {
                        _log.error((Object)("Unable to process message: " + message), (Throwable)e);
                    }
                    return false;
                }
            }
            company = this.getCompany(recipient);
            long categoryId = this.getCategoryId(messageId);
            MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)categoryId);
            if (category.getCompanyId() == company.getCompanyId()) break block7;
            return false;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Check to see if user " + from + " exists"));
        }
        UserLocalServiceUtil.getUserByEmailAddress((long)company.getCompanyId(), (String)from);
        return true;
    }

    public void deliver(String from, String recipient, Message message) throws MessageListenerException {
        try {
            try {
                StopWatch stopWatch = null;
                if (_log.isDebugEnabled()) {
                    stopWatch = new StopWatch();
                    stopWatch.start();
                    _log.debug((Object)("Deliver message from " + from + " to " + recipient));
                }
                Company company = this.getCompany(recipient);
                String messageId = this.getMessageId(recipient, message);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Message id " + messageId));
                }
                long groupId = 0L;
                long categoryId = this.getCategoryId(messageId);
                try {
                    MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)categoryId);
                    groupId = category.getGroupId();
                }
                catch (NoSuchCategoryException noSuchCategoryException) {
                    groupId = categoryId;
                    categoryId = MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Group id " + groupId));
                    _log.debug((Object)("Category id " + categoryId));
                }
                User user = UserLocalServiceUtil.getUserByEmailAddress((long)company.getCompanyId(), (String)from);
                long parentMessageId = this.getParentMessageId(recipient, message);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Parent message id " + parentMessageId));
                }
                MBMessage parentMessage = null;
                try {
                    if (parentMessageId > 0L) {
                        parentMessage = MBMessageLocalServiceUtil.getMessage((long)parentMessageId);
                    }
                }
                catch (NoSuchMessageException noSuchMessageException) {}
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Parent message " + parentMessage));
                }
                String subject = MBUtil.getSubjectWithoutMessageId(message);
                MBMailMessage collector = new MBMailMessage();
                MBUtil.collectPartContent((Part)message, collector);
                PermissionCheckerUtil.setThreadValues(user);
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setAddCommunityPermissions(true);
                serviceContext.setAddGuestPermissions(true);
                serviceContext.setLayoutFullURL(PortalUtil.getLayoutFullURL((long)groupId, (String)"19"));
                serviceContext.setScopeGroupId(groupId);
                if (parentMessage == null) {
                    MBMessageServiceUtil.addMessage((long)groupId, (long)categoryId, (String)subject, (String)collector.getBody(), collector.getFiles(), (boolean)false, (double)0.0, (boolean)true, (ServiceContext)serviceContext);
                } else {
                    MBMessageServiceUtil.addMessage((long)groupId, (long)categoryId, (long)parentMessage.getThreadId(), (long)parentMessage.getMessageId(), (String)subject, (String)collector.getBody(), collector.getFiles(), (boolean)false, (double)0.0, (boolean)true, (ServiceContext)serviceContext);
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Delivering message takes " + stopWatch.getTime() + " ms"));
                }
            }
            catch (PrincipalException pe) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Prevented unauthorized post from " + from));
                }
                throw new MessageListenerException((Throwable)pe);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
                throw new MessageListenerException((Throwable)e);
            }
        }
        finally {
            PermissionCheckerUtil.setThreadValues(null);
        }
    }

    public String getId() {
        return MessageListenerImpl.class.getName();
    }

    protected long getCategoryId(String recipient) {
        int pos = recipient.indexOf(64);
        String target = recipient.substring("mb.".length() + this.getOffset(), pos);
        String[] parts = StringUtil.split((String)target, (String)".");
        return GetterUtil.getLong((String)parts[0]);
    }

    protected Company getCompany(String recipient) throws Exception {
        int pos = recipient.indexOf(64) + MBUtil.POP_SERVER_SUBDOMAIN_LENGTH + 1;
        if (MBUtil.POP_SERVER_SUBDOMAIN_LENGTH > 0) {
            ++pos;
        }
        String mx = recipient.substring(pos);
        return CompanyLocalServiceUtil.getCompanyByMx((String)mx);
    }

    protected String getMessageId(String recipient, Message message) throws Exception {
        if (MBUtil.POP_SERVER_SUBDOMAIN_LENGTH > 0) {
            return recipient;
        }
        return MBUtil.getParentMessageIdString(message);
    }

    protected int getOffset() {
        if (MBUtil.POP_SERVER_SUBDOMAIN_LENGTH == 0) {
            return 1;
        }
        return 0;
    }

    protected long getParentMessageId(String recipient, Message message) throws Exception {
        int pos = recipient.indexOf(64);
        String target = recipient.substring("mb.".length(), pos);
        String[] parts = StringUtil.split((String)target, (String)".");
        long parentMessageId = 0L;
        if (parts.length == 2) {
            parentMessageId = GetterUtil.getLong((String)parts[1]);
        }
        if (parentMessageId > 0L) {
            return parentMessageId;
        }
        return MBUtil.getParentMessageId(message);
    }
}

