/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.ActionResponseImpl;
import com.liferay.portlet.messageboards.MessageBodyException;
import com.liferay.portlet.messageboards.MessageSubjectException;
import com.liferay.portlet.messageboards.NoSuchMessageException;
import com.liferay.portlet.messageboards.NoSuchThreadException;
import com.liferay.portlet.messageboards.RequiredMessageException;
import com.liferay.portlet.messageboards.SplitThreadException;
import com.liferay.portlet.messageboards.action.ActionUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadServiceUtil;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class SplitThreadAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.splitThread(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof PrincipalException || e instanceof RequiredMessageException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.message_boards.error");
            }
            if (e instanceof MessageBodyException || e instanceof MessageSubjectException || e instanceof NoSuchThreadException || e instanceof SplitThreadException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getMessage((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchMessageException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.message_boards.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.message_boards.split_thread"));
    }

    protected void splitThread(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        MBMessage message = MBMessageLocalServiceUtil.getMessage((long)messageId);
        long oldThreadId = message.getThreadId();
        long oldParentMessageId = message.getParentMessageId();
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)MBThread.class.getName(), (PortletRequest)actionRequest);
        MBThread newThread = MBThreadServiceUtil.splitThread((long)messageId, (ServiceContext)serviceContext);
        boolean addExplanationPost = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"addExplanationPost");
        if (addExplanationPost) {
            String subject = ParamUtil.getString((PortletRequest)actionRequest, (String)"subject");
            String body = ParamUtil.getString((PortletRequest)actionRequest, (String)"body");
            String layoutFullURL = PortalUtil.getLayoutFullURL((ThemeDisplay)themeDisplay);
            String newThreadURL = String.valueOf(layoutFullURL) + "/-/message_boards/view_message/" + message.getMessageId();
            body = StringUtil.replace((String)body, (String[])new String[]{"[$NEW_THREAD_URL$]"}, (String[])new String[]{newThreadURL});
            serviceContext.setAddCommunityPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            MBMessageServiceUtil.addMessage((long)message.getGroupId(), (long)message.getCategoryId(), (long)oldThreadId, (long)oldParentMessageId, (String)subject, (String)body, new ArrayList(), (boolean)false, (double)-1.0, (boolean)message.getAllowPingbacks(), (ServiceContext)serviceContext);
        }
        PortletURL portletURL = ((ActionResponseImpl)actionResponse).createRenderURL();
        portletURL.setParameter("struts_action", "/message_boards/view_message");
        portletURL.setParameter("messageId", String.valueOf(newThread.getRootMessageId()));
        actionResponse.sendRedirect(portletURL.toString());
    }
}

