/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.action;

import com.liferay.documentlibrary.FileNameException;
import com.liferay.documentlibrary.FileSizeException;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.captcha.CaptchaUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.ActionResponseImpl;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.messageboards.LockedThreadException;
import com.liferay.portlet.messageboards.MessageBodyException;
import com.liferay.portlet.messageboards.MessageSubjectException;
import com.liferay.portlet.messageboards.NoSuchMessageException;
import com.liferay.portlet.messageboards.RequiredMessageException;
import com.liferay.portlet.messageboards.action.ActionUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBMessageFlagLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadServiceUtil;
import java.io.File;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditMessageAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            MBMessage message = null;
            if (cmd.equals("add") || cmd.equals("update")) {
                message = this.updateMessage(actionRequest, actionResponse);
            } else if (cmd.equals("delete")) {
                this.deleteMessage(actionRequest);
            } else if (cmd.equals("lock")) {
                this.lockThread(actionRequest);
            } else if (cmd.equals("subscribe")) {
                this.subscribeMessage(actionRequest);
            } else if (cmd.equals("unlock")) {
                this.unlockThread(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribeMessage(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                int workflowAction = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"workflowAction", (int)1);
                if (message != null && workflowAction == 2) {
                    redirect = this.getSaveAndContinueRedirect(actionRequest, actionResponse, message);
                }
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchMessageException || e instanceof PrincipalException || e instanceof RequiredMessageException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.message_boards.error");
            }
            if (e instanceof CaptchaTextException || e instanceof FileNameException || e instanceof FileSizeException || e instanceof LockedThreadException || e instanceof MessageBodyException || e instanceof MessageSubjectException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            }
            if (e instanceof AssetTagException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)e);
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getMessage((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchMessageException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.message_boards.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.message_boards.edit_message"));
    }

    protected void deleteMessage(ActionRequest actionRequest) throws Exception {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        MBMessageServiceUtil.deleteMessage((long)messageId);
    }

    protected String getSaveAndContinueRedirect(ActionRequest actionRequest, ActionResponse actionResponse, MBMessage message) {
        boolean preview = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"preview");
        PortletURL portletURL = ((ActionResponseImpl)actionResponse).createRenderURL();
        portletURL.setParameter("struts_action", "/message_boards/edit_message");
        portletURL.setParameter("messageId", String.valueOf(message.getMessageId()));
        portletURL.setParameter("preview", String.valueOf(preview));
        return portletURL.toString();
    }

    protected void lockThread(ActionRequest actionRequest) throws Exception {
        long threadId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"threadId");
        MBThreadServiceUtil.lockThread((long)threadId);
    }

    protected void subscribeMessage(ActionRequest actionRequest) throws Exception {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        MBMessageServiceUtil.subscribeMessage((long)messageId);
    }

    protected void unlockThread(ActionRequest actionRequest) throws Exception {
        long threadId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"threadId");
        MBThreadServiceUtil.unlockThread((long)threadId);
    }

    protected void unsubscribeMessage(ActionRequest actionRequest) throws Exception {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        MBMessageServiceUtil.unsubscribeMessage((long)messageId);
    }

    protected MBMessage updateMessage(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        long groupId = themeDisplay.getScopeGroupId();
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"mbCategoryId");
        long threadId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"threadId");
        long parentMessageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentMessageId");
        String subject = ParamUtil.getString((PortletRequest)actionRequest, (String)"subject");
        String body = ParamUtil.getString((PortletRequest)actionRequest, (String)"body");
        boolean attachments = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"attachments");
        ArrayList<ObjectValuePair> files = new ArrayList<ObjectValuePair>();
        if (attachments) {
            UploadPortletRequest uploadRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
            int i = 1;
            while (i <= 5) {
                File file = uploadRequest.getFile("msgFile" + i);
                String fileName = uploadRequest.getFileName("msgFile" + i);
                byte[] bytes = FileUtil.getBytes((File)file);
                if (bytes != null && bytes.length > 0) {
                    ObjectValuePair ovp = new ObjectValuePair((Object)fileName, (Object)bytes);
                    files.add(ovp);
                }
                ++i;
            }
        }
        boolean question = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"question");
        boolean anonymous = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"anonymous");
        double priority = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"priority");
        boolean allowPingbacks = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"allowPingbacks");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)MBMessage.class.getName(), (PortletRequest)actionRequest);
        MBMessage message = null;
        if (messageId <= 0L) {
            if (PropsValues.CAPTCHA_CHECK_PORTLET_MESSAGE_BOARDS_EDIT_MESSAGE) {
                CaptchaUtil.check((PortletRequest)actionRequest);
            }
            if (threadId <= 0L) {
                message = MBMessageServiceUtil.addMessage((long)groupId, (long)categoryId, (String)subject, (String)body, files, (boolean)anonymous, (double)priority, (boolean)allowPingbacks, (ServiceContext)serviceContext);
                if (question) {
                    MBMessageFlagLocalServiceUtil.addQuestionFlag((long)message.getMessageId());
                }
            } else {
                message = MBMessageServiceUtil.addMessage((long)groupId, (long)categoryId, (long)threadId, (long)parentMessageId, (String)subject, (String)body, files, (boolean)anonymous, (double)priority, (boolean)allowPingbacks, (ServiceContext)serviceContext);
            }
        } else {
            ArrayList<String> existingFiles = new ArrayList<String>();
            int i = 1;
            while (i <= 5) {
                String path = ParamUtil.getString((PortletRequest)actionRequest, (String)("existingPath" + i));
                if (Validator.isNotNull((String)path)) {
                    existingFiles.add(path);
                }
                ++i;
            }
            message = MBMessageServiceUtil.updateMessage((long)messageId, (String)subject, (String)body, files, existingFiles, (double)priority, (boolean)allowPingbacks, (ServiceContext)serviceContext);
            if (message.isRoot()) {
                if (question) {
                    MBMessageFlagLocalServiceUtil.addQuestionFlag((long)messageId);
                } else {
                    MBMessageFlagLocalServiceUtil.deleteQuestionAndAnswerFlags((long)message.getThreadId());
                }
            }
        }
        return message;
    }
}

