/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.persistence;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.impl.JournalArticleImpl;
import com.liferay.portlet.journal.service.persistence.JournalArticleFinder;
import com.liferay.portlet.journal.service.persistence.JournalArticleUtil;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JournalArticleFinderImpl
extends BasePersistenceImpl<JournalArticle>
implements JournalArticleFinder {
    public static String COUNT_BY_C_G_A_V_T_D_C_T_S_T_D_S_R = String.valueOf(JournalArticleFinder.class.getName()) + ".countByC_G_A_V_T_D_C_T_S_T_D_S_R";
    public static String FIND_BY_EXPIRATION_DATE = String.valueOf(JournalArticleFinder.class.getName()) + ".findByExpirationDate";
    public static String FIND_BY_REVIEW_DATE = String.valueOf(JournalArticleFinder.class.getName()) + ".findByReviewDate";
    public static String FIND_BY_R_D = String.valueOf(JournalArticleFinder.class.getName()) + ".findByR_D";
    public static String FIND_BY_C_G_A_V_T_D_C_T_S_T_D_S_R = String.valueOf(JournalArticleFinder.class.getName()) + ".findByC_G_A_V_T_D_C_T_S_T_D_S_R";

    public int countByKeywords(long companyId, long groupId, String keywords, Double version, String type, String structureId, String templateId, Date displayDateGT, Date displayDateLT, int status, Date reviewDate) throws SystemException {
        String[] articleIds = null;
        String[] titles = null;
        String[] descriptions = null;
        String[] contents = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            articleIds = CustomSQLUtil.keywords((String)keywords, (boolean)false);
            titles = CustomSQLUtil.keywords((String)keywords);
            descriptions = CustomSQLUtil.keywords((String)keywords, (boolean)false);
            contents = CustomSQLUtil.keywords((String)keywords, (boolean)false);
        } else {
            andOperator = true;
        }
        return this.countByC_G_A_V_T_D_C_T_S_T_D_S_R(companyId, groupId, articleIds, version, titles, descriptions, contents, type, new String[]{structureId}, new String[]{templateId}, displayDateGT, displayDateLT, status, reviewDate, andOperator);
    }

    public int countByC_G_A_V_T_D_C_T_S_T_D_S_R(long companyId, long groupId, String articleId, Double version, String title, String description, String content, String type, String structureId, String templateId, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator) throws SystemException {
        return this.countByC_G_A_V_T_D_C_T_S_T_D_S_R(companyId, groupId, articleId, version, title, description, content, type, new String[]{structureId}, new String[]{templateId}, displayDateGT, displayDateLT, status, reviewDate, andOperator);
    }

    public int countByC_G_A_V_T_D_C_T_S_T_D_S_R(long companyId, long groupId, String articleId, Double version, String title, String description, String content, String type, String[] structureIds, String[] templateIds, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator) throws SystemException {
        return this.countByC_G_A_V_T_D_C_T_S_T_D_S_R(companyId, groupId, new String[]{articleId}, version, new String[]{title}, new String[]{description}, new String[]{content}, type, structureIds, templateIds, displayDateGT, displayDateLT, status, reviewDate, andOperator);
    }

    public int countByC_G_A_V_T_D_C_T_S_T_D_S_R(long companyId, long groupId, String[] articleIds, Double version, String[] titles, String[] descriptions, String[] contents, String type, String[] structureIds, String[] templateIds, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator) throws SystemException {
        articleIds = CustomSQLUtil.keywords((String[])articleIds, (boolean)false);
        titles = CustomSQLUtil.keywords((String[])titles);
        descriptions = CustomSQLUtil.keywords((String[])descriptions, (boolean)false);
        contents = CustomSQLUtil.keywords((String[])contents, (boolean)false);
        structureIds = CustomSQLUtil.keywords((String[])structureIds, (boolean)false);
        templateIds = CustomSQLUtil.keywords((String[])templateIds, (boolean)false);
        Timestamp displayDateGT_TS = CalendarUtil.getTimestamp((Date)displayDateGT);
        Timestamp displayDateLT_TS = CalendarUtil.getTimestamp((Date)displayDateLT);
        Timestamp reviewDate_TS = CalendarUtil.getTimestamp((Date)reviewDate);
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_C_G_A_V_T_D_C_T_S_T_D_S_R);
            if (groupId <= 0L) {
                sql = StringUtil.replace((String)sql, (String)"(groupId = ?) AND", (String)"");
            }
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"articleId", (String)"LIKE", (boolean)false, (String[])articleIds);
            if (version == null) {
                sql = StringUtil.replace((String)sql, (String)"(version = ?) [$AND_OR_CONNECTOR$]", (String)"");
            } else if (version <= 0.0) {
                sql = StringUtil.replace((String)sql, (String)"COUNT(*", (String)"COUNT(DISTINCT articleId");
                sql = StringUtil.replace((String)sql, (String)"(version = ?) [$AND_OR_CONNECTOR$]", (String)"");
            }
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(title)", (String)"LIKE", (boolean)false, (String[])titles);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"description", (String)"LIKE", (boolean)false, (String[])descriptions);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"content", (String)"LIKE", (boolean)false, (String[])contents);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"structureId", (String)"=", (boolean)false, (String[])structureIds);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"templateId", (String)"=", (boolean)false, (String[])templateIds);
            if (status == -1) {
                sql = StringUtil.replace((String)sql, (String)"(status = ?) AND", (String)"");
            }
            sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            if (groupId > 0L) {
                qPos.add(groupId);
            }
            qPos.add(articleIds, 2);
            if (version != null && version > 0.0) {
                qPos.add(version);
            }
            qPos.add(titles, 2);
            qPos.add(descriptions, 2);
            qPos.add(contents, 2);
            qPos.add(type);
            qPos.add(type);
            qPos.add(structureIds, 2);
            qPos.add(templateIds, 2);
            qPos.add(displayDateGT_TS);
            qPos.add(displayDateGT_TS);
            qPos.add(displayDateLT_TS);
            qPos.add(displayDateLT_TS);
            if (status != -1) {
                qPos.add(status);
            }
            qPos.add(reviewDate_TS);
            qPos.add(reviewDate_TS);
            Iterator itr = q.list().iterator();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<JournalArticle> findByExpirationDate(int status, Date expirationDateLT, Date expirationDateGT) throws SystemException {
        Timestamp expirationDateLT_TS = CalendarUtil.getTimestamp((Date)expirationDateLT);
        Timestamp expirationDateGT_TS = CalendarUtil.getTimestamp((Date)expirationDateGT);
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_EXPIRATION_DATE);
            if (status == -1) {
                sql = StringUtil.replace((String)sql, (String)"(status = ?) AND", (String)"");
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("JournalArticle", JournalArticleImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            if (status != -1) {
                qPos.add(status);
            }
            qPos.add(expirationDateGT_TS);
            qPos.add(expirationDateLT_TS);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<JournalArticle> findByKeywords(long companyId, long groupId, String keywords, Double version, String type, String structureId, String templateId, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        String[] articleIds = null;
        String[] titles = null;
        String[] descriptions = null;
        String[] contents = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            articleIds = CustomSQLUtil.keywords((String)keywords, (boolean)false);
            titles = CustomSQLUtil.keywords((String)keywords);
            descriptions = CustomSQLUtil.keywords((String)keywords, (boolean)false);
            contents = CustomSQLUtil.keywords((String)keywords, (boolean)false);
        } else {
            andOperator = true;
        }
        return this.findByC_G_A_V_T_D_C_T_S_T_D_S_R(companyId, groupId, articleIds, version, titles, descriptions, contents, type, new String[]{structureId}, new String[]{templateId}, displayDateGT, displayDateLT, status, reviewDate, andOperator, start, end, orderByComparator);
    }

    public List<JournalArticle> findByReviewDate(Date reviewDateLT, Date reviewDateGT) throws SystemException {
        Timestamp reviewDateLT_TS = CalendarUtil.getTimestamp((Date)reviewDateLT);
        Timestamp reviewDateGT_TS = CalendarUtil.getTimestamp((Date)reviewDateGT);
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_REVIEW_DATE);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("JournalArticle", JournalArticleImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(reviewDateGT_TS);
            qPos.add(reviewDateLT_TS);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public JournalArticle findByR_D(long resourcePrimKey, Date displayDate) throws NoSuchArticleException, SystemException {
        Timestamp displayDate_TS = CalendarUtil.getTimestamp((Date)displayDate);
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_R_D);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("JournalArticle", JournalArticleImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(resourcePrimKey);
            qPos.add(displayDate_TS);
            List list = q.list();
            if (list.size() == 0) {
                StringBundler sb = new StringBundler(6);
                sb.append("No JournalArticle exists with the key ");
                sb.append("{resourcePrimKey=");
                sb.append(resourcePrimKey);
                sb.append(", displayDate=");
                sb.append((Object)displayDate);
                sb.append("}");
                throw new NoSuchArticleException(sb.toString());
            }
            JournalArticle journalArticle = (JournalArticle)list.get(0);
            return journalArticle;
        }
        catch (NoSuchArticleException nsae) {
            throw nsae;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<JournalArticle> findByC_G_A_V_T_D_C_T_S_T_D_S_R(long companyId, long groupId, String articleId, Double version, String title, String description, String content, String type, String structureId, String templateId, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.findByC_G_A_V_T_D_C_T_S_T_D_S_R(companyId, groupId, articleId, version, title, description, content, type, new String[]{structureId}, new String[]{templateId}, displayDateGT, displayDateLT, status, reviewDate, andOperator, start, end, orderByComparator);
    }

    public List<JournalArticle> findByC_G_A_V_T_D_C_T_S_T_D_S_R(long companyId, long groupId, String articleId, Double version, String title, String description, String content, String type, String[] structureIds, String[] templateIds, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.findByC_G_A_V_T_D_C_T_S_T_D_S_R(companyId, groupId, new String[]{articleId}, version, new String[]{title}, new String[]{description}, new String[]{content}, type, structureIds, templateIds, displayDateGT, displayDateLT, status, reviewDate, andOperator, start, end, orderByComparator);
    }

    public List<JournalArticle> findByC_G_A_V_T_D_C_T_S_T_D_S_R(long companyId, long groupId, String[] articleIds, Double version, String[] titles, String[] descriptions, String[] contents, String type, String[] structureIds, String[] templateIds, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        articleIds = CustomSQLUtil.keywords((String[])articleIds, (boolean)false);
        titles = CustomSQLUtil.keywords((String[])titles);
        descriptions = CustomSQLUtil.keywords((String[])descriptions, (boolean)false);
        contents = CustomSQLUtil.keywords((String[])contents, (boolean)false);
        structureIds = CustomSQLUtil.keywords((String[])structureIds, (boolean)false);
        templateIds = CustomSQLUtil.keywords((String[])templateIds, (boolean)false);
        Timestamp displayDateGT_TS = CalendarUtil.getTimestamp((Date)displayDateGT);
        Timestamp displayDateLT_TS = CalendarUtil.getTimestamp((Date)displayDateLT);
        Timestamp reviewDate_TS = CalendarUtil.getTimestamp((Date)reviewDate);
        Session session = null;
        try {
            String field;
            int n;
            int n2;
            String[] stringArray;
            StringBundler sb;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_G_A_V_T_D_C_T_S_T_D_S_R);
            if (groupId <= 0L) {
                sql = StringUtil.replace((String)sql, (String)"(groupId = ?) AND", (String)"");
            }
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"articleId", (String)"LIKE", (boolean)false, (String[])articleIds);
            String groupBy = "articleId";
            if (version == null) {
                sb = new StringBundler("id_ AS id");
                stringArray = orderByComparator.getOrderByFields();
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    field = stringArray[n];
                    sb.append(", ");
                    sb.append(field);
                    ++n;
                }
                sql = StringUtil.replace((String)sql, (String)"id_ AS id", (String)sb.toString());
                sql = StringUtil.replace((String)sql, (String)"(version = ?) [$AND_OR_CONNECTOR$]", (String)"");
            } else if (version <= 0.0) {
                sb = new StringBundler(groupBy);
                stringArray = orderByComparator.getOrderByFields();
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    field = stringArray[n];
                    if (!field.equals("articleId") && !field.equals("version")) {
                        sb.append(", ");
                        sb.append(field);
                    }
                    ++n;
                }
                groupBy = sb.toString();
                sb.append(", MAX(version) as version");
                sql = StringUtil.replace((String)sql, (String)"id_ AS id", (String)sb.toString());
                sql = StringUtil.replace((String)sql, (String)"(version = ?) [$AND_OR_CONNECTOR$]", (String)"");
            }
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(title)", (String)"LIKE", (boolean)false, (String[])titles);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"description", (String)"LIKE", (boolean)false, (String[])descriptions);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"content", (String)"LIKE", (boolean)false, (String[])contents);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"structureId", (String)"=", (boolean)false, (String[])structureIds);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"templateId", (String)"=", (boolean)false, (String[])templateIds);
            if (status == -1) {
                sql = StringUtil.replace((String)sql, (String)"(status = ?) AND", (String)"");
            }
            sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
            sql = version != null && version <= 0.0 ? StringUtil.replace((String)sql, (String)"[$GROUP_BY_CLAUSE$]", (String)("GROUP BY " + groupBy)) : StringUtil.replace((String)sql, (String)"[$GROUP_BY_CLAUSE$]", (String)"");
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)orderByComparator);
            SQLQuery q = session.createSQLQuery(sql);
            if (version != null && version <= 0.0) {
                q.addScalar("articleId", Type.STRING);
            } else {
                q.addScalar("id", Type.LONG);
            }
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            if (groupId > 0L) {
                qPos.add(groupId);
            }
            qPos.add(articleIds, 2);
            if (version != null && version > 0.0) {
                qPos.add(version);
            }
            qPos.add(titles, 2);
            qPos.add(descriptions, 2);
            qPos.add(contents, 2);
            qPos.add(type);
            qPos.add(type);
            qPos.add(structureIds, 2);
            qPos.add(templateIds, 2);
            qPos.add(displayDateGT_TS);
            qPos.add(displayDateGT_TS);
            qPos.add(displayDateLT_TS);
            qPos.add(displayDateLT_TS);
            if (status != -1) {
                qPos.add(status);
            }
            qPos.add(reviewDate_TS);
            qPos.add(reviewDate_TS);
            ArrayList<JournalArticle> articles = new ArrayList<JournalArticle>();
            Iterator itr = QueryUtil.iterate((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            while (itr.hasNext()) {
                Object value = itr.next();
                JournalArticle article = null;
                if (version != null && version <= 0.0) {
                    String articleId = (String)value;
                    article = this.getLatestArticle(groupId, articleId, status);
                } else {
                    long id = (Long)value;
                    article = JournalArticleUtil.findByPrimaryKey((long)id);
                }
                if (article == null) continue;
                articles.add(article);
            }
            ArrayList<JournalArticle> arrayList = articles;
            return arrayList;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected JournalArticle getLatestArticle(long groupId, String articleId, int status) throws SystemException {
        List articles = null;
        articles = status == -1 ? JournalArticleUtil.findByG_A((long)groupId, (String)articleId, (int)0, (int)1) : JournalArticleUtil.findByG_A_ST((long)groupId, (String)articleId, (int)status, (int)0, (int)1);
        if (articles.isEmpty()) {
            return null;
        }
        return (JournalArticle)articles.get(0);
    }
}

