/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermissionUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;

public class JournalArticlePermission {
    public static void check(PermissionChecker permissionChecker, JournalArticle article, String actionId) throws PortalException {
        if (!JournalArticlePermission.contains(permissionChecker, article, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long resourcePrimKey, String actionId) throws PortalException, SystemException {
        if (!JournalArticlePermission.contains(permissionChecker, resourcePrimKey, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, String articleId, String actionId) throws PortalException, SystemException {
        if (!JournalArticlePermission.contains(permissionChecker, groupId, articleId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, JournalArticle article, String actionId) {
        Boolean hasPermission;
        if (article.isPending() && (hasPermission = WorkflowPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)article.getGroupId(), (String)JournalArticle.class.getName(), (long)article.getResourcePrimKey(), (String)actionId)) != null) {
            return hasPermission;
        }
        if (permissionChecker.hasOwnerPermission(article.getCompanyId(), JournalArticle.class.getName(), article.getResourcePrimKey(), article.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(article.getGroupId(), JournalArticle.class.getName(), article.getResourcePrimKey(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long resourcePrimKey, String actionId) throws PortalException, SystemException {
        JournalArticle article = JournalArticleLocalServiceUtil.getLatestArticle((long)resourcePrimKey);
        return JournalArticlePermission.contains(permissionChecker, article, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, String articleId, String actionId) throws PortalException, SystemException {
        JournalArticle article = JournalArticleLocalServiceUtil.getArticle((long)groupId, (String)articleId);
        return JournalArticlePermission.contains(permissionChecker, article, actionId);
    }
}

