/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallery.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.service.base.IGImageServiceBaseImpl;
import com.liferay.portlet.imagegallery.service.permission.IGFolderPermission;
import com.liferay.portlet.imagegallery.service.permission.IGImagePermission;
import com.liferay.portlet.imagegallery.util.comparator.ImageModifiedDateComparator;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGImageServiceImpl
extends IGImageServiceBaseImpl {
    public IGImage addImage(long groupId, long folderId, String name, String description, File file, String contentType, ServiceContext serviceContext) throws PortalException, SystemException {
        IGFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "ADD_IMAGE");
        return this.igImageLocalService.addImage(this.getUserId(), groupId, folderId, name, description, file, contentType, serviceContext);
    }

    public void deleteImage(long imageId) throws PortalException, SystemException {
        IGImagePermission.check(this.getPermissionChecker(), imageId, "DELETE");
        this.igImageLocalService.deleteImage(imageId);
    }

    public void deleteImageByFolderIdAndNameWithExtension(long groupId, long folderId, String nameWithExtension) throws PortalException, SystemException {
        IGImage image = this.igImageLocalService.getImageByFolderIdAndNameWithExtension(groupId, folderId, nameWithExtension);
        this.deleteImage(image.getImageId());
    }

    public List<IGImage> getGroupImages(long groupId, long userId, int start, int end) throws SystemException {
        ImageModifiedDateComparator orderByComparator = new ImageModifiedDateComparator();
        if (userId <= 0L) {
            return this.igImagePersistence.filterFindByGroupId(groupId, start, end, (OrderByComparator)orderByComparator);
        }
        return this.igImagePersistence.filterFindByG_U(groupId, userId, start, end, (OrderByComparator)orderByComparator);
    }

    public int getGroupImagesCount(long groupId, long userId) throws SystemException {
        if (userId <= 0L) {
            return this.igImagePersistence.filterCountByGroupId(groupId);
        }
        return this.igImagePersistence.filterCountByG_U(groupId, userId);
    }

    public IGImage getImage(long imageId) throws PortalException, SystemException {
        IGImagePermission.check(this.getPermissionChecker(), imageId, "VIEW");
        return this.igImageLocalService.getImage(imageId);
    }

    public IGImage getImageByFolderIdAndNameWithExtension(long groupId, long folderId, String nameWithExtension) throws PortalException, SystemException {
        IGImage image = this.igImageLocalService.getImageByFolderIdAndNameWithExtension(groupId, folderId, nameWithExtension);
        IGImagePermission.check(this.getPermissionChecker(), image, "VIEW");
        return image;
    }

    public IGImage getImageByLargeImageId(long largeImageId) throws PortalException, SystemException {
        IGImage image = this.igImageLocalService.getImageByLargeImageId(largeImageId);
        IGImagePermission.check(this.getPermissionChecker(), image.getImageId(), "VIEW");
        return image;
    }

    public IGImage getImageBySmallImageId(long smallImageId) throws PortalException, SystemException {
        IGImage image = this.igImageLocalService.getImageBySmallImageId(smallImageId);
        IGImagePermission.check(this.getPermissionChecker(), image.getImageId(), "VIEW");
        return image;
    }

    public List<IGImage> getImages(long groupId, long folderId) throws SystemException {
        return this.igImagePersistence.filterFindByG_F(groupId, folderId);
    }

    public List<IGImage> getImages(long groupId, long folderId, int start, int end) throws SystemException {
        return this.igImagePersistence.filterFindByG_F(groupId, folderId, start, end);
    }

    public int getImagesCount(long groupId, long folderId) throws SystemException {
        return this.igImagePersistence.filterCountByG_F(groupId, folderId);
    }

    public IGImage updateImage(long imageId, long groupId, long folderId, String name, String description, File file, String contentType, ServiceContext serviceContext) throws PortalException, SystemException {
        IGImagePermission.check(this.getPermissionChecker(), imageId, "UPDATE");
        return this.igImageLocalService.updateImage(this.getUserId(), imageId, groupId, folderId, name, description, file, contentType, serviceContext);
    }
}

