/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallery.model.impl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Image;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portlet.imagegallery.model.IGFolder;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.model.impl.IGFolderImpl;
import com.liferay.portlet.imagegallery.model.impl.IGImageModelImpl;
import com.liferay.portlet.imagegallery.service.IGFolderLocalServiceUtil;

public class IGImageImpl
extends IGImageModelImpl
implements IGImage {
    private static Log _log = LogFactoryUtil.getLog(IGImageImpl.class);
    private Integer _imageSize;
    private String _imageType;

    public static String getNameWithExtension(String name, String type) {
        if (Validator.isNotNull((String)type)) {
            name = String.valueOf(name) + "." + type;
        }
        return name;
    }

    public IGFolder getFolder() {
        IGFolderImpl folder = null;
        if (this.getFolderId() > 0L) {
            try {
                folder = IGFolderLocalServiceUtil.getFolder((long)this.getFolderId());
            }
            catch (Exception e) {
                folder = new IGFolderImpl();
                _log.error((Throwable)e);
            }
        } else {
            folder = new IGFolderImpl();
        }
        return folder;
    }

    public int getImageSize() {
        if (this._imageSize == null) {
            try {
                Image largeImage = ImageLocalServiceUtil.getImage((long)this.getLargeImageId());
                this._imageSize = new Integer(largeImage.getSize());
            }
            catch (Exception e) {
                this._imageSize = new Integer(0);
                _log.error((Throwable)e);
            }
        }
        return this._imageSize;
    }

    public String getImageType() {
        if (this._imageType == null) {
            try {
                Image largeImage = ImageLocalServiceUtil.getImage((long)this.getLargeImageId());
                this._imageType = largeImage.getType();
            }
            catch (Exception e) {
                this._imageType = "";
                _log.error((Throwable)e);
            }
        }
        return this._imageType;
    }

    public String getNameWithExtension() {
        String nameWithExtension = this.getName();
        if (Validator.isNull((String)nameWithExtension)) {
            nameWithExtension = String.valueOf(this.getImageId());
        }
        String type = this.getImageType();
        return IGImageImpl.getNameWithExtension(nameWithExtension, type);
    }

    public void setImageType(String imageType) {
        this._imageType = imageType;
    }
}

