/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.sharepoint;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.sharepoint.BaseSharepointStorageImpl;
import com.liferay.portal.sharepoint.SharepointRequest;
import com.liferay.portal.sharepoint.SharepointUtil;
import com.liferay.portal.sharepoint.Tree;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderServiceUtil;
import java.io.File;
import java.io.InputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLSharepointStorageImpl
extends BaseSharepointStorageImpl {
    @Override
    public void addDocumentElements(SharepointRequest sharepointRequest, Element element) throws Exception {
        String parentFolderPath = sharepointRequest.getRootPath();
        long groupId = SharepointUtil.getGroupId(parentFolderPath);
        long parentFolderId = this.getLastFolderId(groupId, parentFolderPath, 0L);
        if (parentFolderId == 0L) {
            return;
        }
        List fileEntries = DLFileEntryServiceUtil.getFileEntries((long)groupId, (long)parentFolderId);
        for (DLFileEntry fileEntry : fileEntries) {
            String documentPath = parentFolderPath.concat("/").concat(fileEntry.getTitle());
            this.addDocumentElement(element, documentPath, fileEntry.getCreateDate(), fileEntry.getModifiedDate(), fileEntry.getUserName());
        }
    }

    @Override
    public void createFolder(SharepointRequest sharepointRequest) throws Exception {
        String folderPath = sharepointRequest.getRootPath();
        String parentFolderPath = this.getParentFolderPath(folderPath);
        long groupId = SharepointUtil.getGroupId(parentFolderPath);
        long parentFolderId = this.getLastFolderId(groupId, parentFolderPath, 0L);
        String folderName = this.getResourceName(folderPath);
        String description = "";
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        DLFolderServiceUtil.addFolder((long)groupId, (long)parentFolderId, (String)folderName, (String)description, (ServiceContext)serviceContext);
    }

    @Override
    public InputStream getDocumentInputStream(SharepointRequest sharepointRequest) throws Exception {
        DLFileEntry fileEntry = this.getFileEntry(sharepointRequest);
        return DLFileEntryLocalServiceUtil.getFileAsStream((long)sharepointRequest.getCompanyId(), (long)sharepointRequest.getUserId(), (long)fileEntry.getGroupId(), (long)fileEntry.getFolderId(), (String)fileEntry.getName());
    }

    @Override
    public Tree getDocumentTree(SharepointRequest sharepointRequest) throws Exception {
        String documentPath = sharepointRequest.getRootPath();
        String parentFolderPath = this.getParentFolderPath(documentPath);
        DLFileEntry fileEntry = this.getFileEntry(sharepointRequest);
        return this.getFileEntryTree(fileEntry, parentFolderPath);
    }

    @Override
    public Tree getDocumentsTree(SharepointRequest sharepointRequest) throws Exception {
        Tree documentsTree = new Tree();
        String parentFolderPath = sharepointRequest.getRootPath();
        long groupId = SharepointUtil.getGroupId(parentFolderPath);
        long parentFolderId = this.getLastFolderId(groupId, parentFolderPath, 0L);
        if (parentFolderId != 0L) {
            List fileEntries = DLFileEntryServiceUtil.getFileEntries((long)groupId, (long)parentFolderId);
            for (DLFileEntry fileEntry : fileEntries) {
                documentsTree.addChild(this.getFileEntryTree(fileEntry, parentFolderPath));
            }
        }
        return documentsTree;
    }

    @Override
    public Tree getFolderTree(SharepointRequest sharepointRequest) throws Exception {
        String folderPath = sharepointRequest.getRootPath();
        String parentFolderPath = this.getParentFolderPath(folderPath);
        long groupId = SharepointUtil.getGroupId(folderPath);
        long folderId = this.getLastFolderId(groupId, folderPath, 0L);
        DLFolder folder = DLFolderServiceUtil.getFolder((long)folderId);
        return this.getFolderTree(folder, parentFolderPath);
    }

    @Override
    public Tree getFoldersTree(SharepointRequest sharepointRequest) throws Exception {
        Tree foldersTree = new Tree();
        String parentFolderPath = sharepointRequest.getRootPath();
        long groupId = SharepointUtil.getGroupId(parentFolderPath);
        long parentFolderId = this.getLastFolderId(groupId, parentFolderPath, 0L);
        List folders = DLFolderServiceUtil.getFolders((long)groupId, (long)parentFolderId);
        for (DLFolder folder : folders) {
            foldersTree.addChild(this.getFolderTree(folder, parentFolderPath));
        }
        foldersTree.addChild(this.getFolderTree(parentFolderPath));
        return foldersTree;
    }

    @Override
    public void getParentFolderIds(long groupId, String path, List<Long> folderIds) throws Exception {
        String[] pathArray = SharepointUtil.getPathArray(path);
        if (pathArray.length == 0) {
            return;
        }
        long parentFolderId = folderIds.get(folderIds.size() - 1);
        long folderId = DLFolderServiceUtil.getFolderId((long)groupId, (long)parentFolderId, (String)pathArray[0]);
        folderIds.add(folderId);
        if (pathArray.length > 1) {
            path = this.removeFoldersFromPath(path, 1);
            this.getParentFolderIds(groupId, path, folderIds);
        }
    }

    @Override
    public Tree[] moveDocument(SharepointRequest sharepointRequest) throws Exception {
        DLFileEntry fileEntry;
        DLFolder folder;
        long groupId;
        block8: {
            String parentFolderPath = sharepointRequest.getRootPath();
            groupId = SharepointUtil.getGroupId(parentFolderPath);
            folder = null;
            fileEntry = null;
            try {
                long parentFolderId = this.getLastFolderId(groupId, parentFolderPath, 0L);
                folder = DLFolderServiceUtil.getFolder((long)parentFolderId);
            }
            catch (Exception e1) {
                if (!(e1 instanceof NoSuchFolderException)) break block8;
                try {
                    fileEntry = this.getFileEntry(sharepointRequest);
                }
                catch (Exception exception) {}
            }
        }
        Tree movedDocsTree = new Tree();
        Tree movedDirsTree = new Tree();
        String newPath = sharepointRequest.getParameterValue("newUrl");
        String newParentFolderPath = this.getParentFolderPath(newPath);
        long newGroupId = SharepointUtil.getGroupId(newParentFolderPath);
        long newParentFolderId = this.getLastFolderId(newGroupId, newParentFolderPath, 0L);
        String newName = this.getResourceName(newPath);
        ServiceContext serviceContext = new ServiceContext();
        if (fileEntry != null) {
            long folderId = fileEntry.getFolderId();
            String name = fileEntry.getName();
            String description = fileEntry.getDescription();
            String changeLog = "";
            String extraSettings = fileEntry.getExtraSettings();
            InputStream is = DLFileEntryLocalServiceUtil.getFileAsStream((long)sharepointRequest.getCompanyId(), (long)sharepointRequest.getUserId(), (long)fileEntry.getGroupId(), (long)fileEntry.getFolderId(), (String)fileEntry.getName());
            byte[] bytes = FileUtil.getBytes((InputStream)is);
            String[] assetTagNames = AssetTagLocalServiceUtil.getTagNames((String)DLFileEntry.class.getName(), (long)fileEntry.getFileEntryId());
            serviceContext.setAssetTagNames(assetTagNames);
            fileEntry = DLFileEntryServiceUtil.updateFileEntry((long)groupId, (long)folderId, (String)name, (String)newName, (String)newName, (String)description, (String)changeLog, (boolean)false, (String)extraSettings, (byte[])bytes, (ServiceContext)serviceContext);
            if (folderId != newParentFolderId) {
                fileEntry = DLFileEntryServiceUtil.moveFileEntry((long)groupId, (long)folderId, (long)newParentFolderId, (String)name, (ServiceContext)serviceContext);
            }
            Tree documentTree = this.getFileEntryTree(fileEntry, newParentFolderPath);
            movedDocsTree.addChild(documentTree);
        } else if (folder != null) {
            long folderId = folder.getFolderId();
            String description = folder.getDescription();
            folder = DLFolderServiceUtil.updateFolder((long)folderId, (long)newParentFolderId, (String)newName, (String)description, (ServiceContext)serviceContext);
            Tree folderTree = this.getFolderTree(folder, newParentFolderPath);
            movedDirsTree.addChild(folderTree);
        }
        return new Tree[]{movedDocsTree, movedDirsTree};
    }

    @Override
    public void putDocument(SharepointRequest sharepointRequest) throws Exception {
        String name;
        String documentPath = sharepointRequest.getRootPath();
        String parentFolderPath = this.getParentFolderPath(documentPath);
        long groupId = SharepointUtil.getGroupId(parentFolderPath);
        long parentFolderId = this.getLastFolderId(groupId, parentFolderPath, 0L);
        String title = name = this.getResourceName(documentPath);
        String description = "";
        String changeLog = "";
        String extraSettings = "";
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        try {
            DLFileEntry fileEntry = this.getFileEntry(sharepointRequest);
            name = fileEntry.getName();
            description = fileEntry.getDescription();
            extraSettings = fileEntry.getExtraSettings();
            String[] assetTagNames = AssetTagLocalServiceUtil.getTagNames((String)DLFileEntry.class.getName(), (long)fileEntry.getFileEntryId());
            serviceContext.setAssetTagNames(assetTagNames);
            DLFileEntryServiceUtil.updateFileEntry((long)groupId, (long)parentFolderId, (String)name, (String)title, (String)title, (String)description, (String)changeLog, (boolean)false, (String)extraSettings, (byte[])sharepointRequest.getBytes(), (ServiceContext)serviceContext);
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            File file = FileUtil.createTempFile((String)FileUtil.getExtension((String)name));
            FileUtil.write((File)file, (byte[])sharepointRequest.getBytes());
            DLFileEntryServiceUtil.addFileEntry((long)groupId, (long)parentFolderId, (String)name, (String)title, (String)description, (String)changeLog, (String)extraSettings, (File)file, (ServiceContext)serviceContext);
        }
    }

    @Override
    public Tree[] removeDocument(SharepointRequest sharepointRequest) {
        DLFileEntry fileEntry;
        DLFolder folder;
        String parentFolderPath;
        block15: {
            parentFolderPath = sharepointRequest.getRootPath();
            long groupId = SharepointUtil.getGroupId(parentFolderPath);
            folder = null;
            fileEntry = null;
            try {
                long parentFolderId = this.getLastFolderId(groupId, parentFolderPath, 0L);
                folder = DLFolderServiceUtil.getFolder((long)parentFolderId);
            }
            catch (Exception e1) {
                if (!(e1 instanceof NoSuchFolderException)) break block15;
                try {
                    fileEntry = this.getFileEntry(sharepointRequest);
                }
                catch (Exception exception) {}
            }
        }
        Tree documentTree = new Tree();
        Tree removedDocsTree = new Tree();
        Tree failedDocsTree = new Tree();
        Tree folderTree = new Tree();
        Tree removedDirsTree = new Tree();
        Tree failedDirsTree = new Tree();
        if (fileEntry != null) {
            try {
                documentTree = this.getFileEntryTree(fileEntry, parentFolderPath);
                DLFileEntryServiceUtil.deleteFileEntry((long)fileEntry.getGroupId(), (long)fileEntry.getFolderId(), (String)fileEntry.getName());
                removedDocsTree.addChild(documentTree);
            }
            catch (Exception exception) {
                try {
                    failedDocsTree.addChild(documentTree);
                }
                catch (Exception exception2) {}
            }
        } else if (folder != null) {
            try {
                folderTree = this.getFolderTree(folder, parentFolderPath);
                DLFolderServiceUtil.deleteFolder((long)folder.getFolderId());
                removedDirsTree.addChild(folderTree);
            }
            catch (Exception exception) {
                try {
                    failedDirsTree.addChild(folderTree);
                }
                catch (Exception exception3) {}
            }
        }
        return new Tree[]{removedDocsTree, removedDirsTree, failedDocsTree, failedDirsTree};
    }

    protected Tree getFolderTree(DLFolder folder, String parentFolderPath) {
        String folderPath = parentFolderPath.concat("/").concat(folder.getName());
        return this.getFolderTree(folderPath, folder.getCreateDate(), folder.getModifiedDate(), folder.getLastPostDate());
    }

    protected DLFileEntry getFileEntry(SharepointRequest sharepointRequest) throws Exception {
        String documentPath = sharepointRequest.getRootPath();
        String parentFolderPath = this.getParentFolderPath(documentPath);
        long groupId = SharepointUtil.getGroupId(parentFolderPath);
        long parentFolderId = this.getLastFolderId(groupId, parentFolderPath, 0L);
        String title = this.getResourceName(documentPath);
        return DLFileEntryServiceUtil.getFileEntryByTitle((long)groupId, (long)parentFolderId, (String)title);
    }

    protected Tree getFileEntryTree(DLFileEntry fileEntry, String parentFolderPath) {
        String documentPath = parentFolderPath.concat("/").concat(fileEntry.getTitle());
        return this.getDocumentTree(documentPath, fileEntry.getCreateDate(), fileEntry.getModifiedDate(), fileEntry.getSize(), fileEntry.getUserName(), fileEntry.getVersion());
    }
}

