/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.persistence;

import com.liferay.portal.NoSuchModelException;
import com.liferay.portal.kernel.annotation.BeanReference;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.BatchSessionUtil;
import com.liferay.portal.service.persistence.ResourcePersistence;
import com.liferay.portal.service.persistence.UserPersistence;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.asset.service.persistence.AssetEntryPersistence;
import com.liferay.portlet.documentlibrary.NoSuchFileVersionException;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.impl.DLFileVersionImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFileVersionModelImpl;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileEntryPersistence;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileRankPersistence;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileShortcutPersistence;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileVersionPersistence;
import com.liferay.portlet.documentlibrary.service.persistence.DLFolderPersistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFileVersionPersistenceImpl
extends BasePersistenceImpl<DLFileVersion>
implements DLFileVersionPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = DLFileVersionImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST = String.valueOf(FINDER_CLASS_NAME_ENTITY) + ".List";
    public static final FinderPath FINDER_PATH_FIND_BY_G_F_N = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByG_F_N", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_COUNT_BY_G_F_N = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByG_F_N", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName()});
    public static final FinderPath FINDER_PATH_FETCH_BY_G_F_N_V = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_ENTITY, "fetchByG_F_N_V", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), String.class.getName()});
    public static final FinderPath FINDER_PATH_COUNT_BY_G_F_N_V = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByG_F_N_V", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), String.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_BY_G_F_N_S = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByG_F_N_S", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), Integer.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_COUNT_BY_G_F_N_S = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByG_F_N_S", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), Integer.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_ALL = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countAll", new String[0]);
    @BeanReference(type=DLFileEntryPersistence.class)
    protected DLFileEntryPersistence dlFileEntryPersistence;
    @BeanReference(type=DLFileRankPersistence.class)
    protected DLFileRankPersistence dlFileRankPersistence;
    @BeanReference(type=DLFileShortcutPersistence.class)
    protected DLFileShortcutPersistence dlFileShortcutPersistence;
    @BeanReference(type=DLFileVersionPersistence.class)
    protected DLFileVersionPersistence dlFileVersionPersistence;
    @BeanReference(type=DLFolderPersistence.class)
    protected DLFolderPersistence dlFolderPersistence;
    @BeanReference(type=ResourcePersistence.class)
    protected ResourcePersistence resourcePersistence;
    @BeanReference(type=UserPersistence.class)
    protected UserPersistence userPersistence;
    @BeanReference(type=AssetEntryPersistence.class)
    protected AssetEntryPersistence assetEntryPersistence;
    private static final String _SQL_SELECT_DLFILEVERSION = "SELECT dlFileVersion FROM DLFileVersion dlFileVersion";
    private static final String _SQL_SELECT_DLFILEVERSION_WHERE = "SELECT dlFileVersion FROM DLFileVersion dlFileVersion WHERE ";
    private static final String _SQL_COUNT_DLFILEVERSION = "SELECT COUNT(dlFileVersion) FROM DLFileVersion dlFileVersion";
    private static final String _SQL_COUNT_DLFILEVERSION_WHERE = "SELECT COUNT(dlFileVersion) FROM DLFileVersion dlFileVersion WHERE ";
    private static final String _FINDER_COLUMN_G_F_N_GROUPID_2 = "dlFileVersion.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_F_N_FOLDERID_2 = "dlFileVersion.folderId = ? AND ";
    private static final String _FINDER_COLUMN_G_F_N_NAME_1 = "dlFileVersion.name IS NULL";
    private static final String _FINDER_COLUMN_G_F_N_NAME_2 = "dlFileVersion.name = ?";
    private static final String _FINDER_COLUMN_G_F_N_NAME_3 = "(dlFileVersion.name IS NULL OR dlFileVersion.name = ?)";
    private static final String _FINDER_COLUMN_G_F_N_V_GROUPID_2 = "dlFileVersion.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_F_N_V_FOLDERID_2 = "dlFileVersion.folderId = ? AND ";
    private static final String _FINDER_COLUMN_G_F_N_V_NAME_1 = "dlFileVersion.name IS NULL AND ";
    private static final String _FINDER_COLUMN_G_F_N_V_NAME_2 = "dlFileVersion.name = ? AND ";
    private static final String _FINDER_COLUMN_G_F_N_V_NAME_3 = "(dlFileVersion.name IS NULL OR dlFileVersion.name = ?) AND ";
    private static final String _FINDER_COLUMN_G_F_N_V_VERSION_1 = "dlFileVersion.version IS NULL";
    private static final String _FINDER_COLUMN_G_F_N_V_VERSION_2 = "dlFileVersion.version = ?";
    private static final String _FINDER_COLUMN_G_F_N_V_VERSION_3 = "(dlFileVersion.version IS NULL OR dlFileVersion.version = ?)";
    private static final String _FINDER_COLUMN_G_F_N_S_GROUPID_2 = "dlFileVersion.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_F_N_S_FOLDERID_2 = "dlFileVersion.folderId = ? AND ";
    private static final String _FINDER_COLUMN_G_F_N_S_NAME_1 = "dlFileVersion.name IS NULL AND ";
    private static final String _FINDER_COLUMN_G_F_N_S_NAME_2 = "dlFileVersion.name = ? AND ";
    private static final String _FINDER_COLUMN_G_F_N_S_NAME_3 = "(dlFileVersion.name IS NULL OR dlFileVersion.name = ?) AND ";
    private static final String _FINDER_COLUMN_G_F_N_S_STATUS_2 = "dlFileVersion.status = ?";
    private static final String _ORDER_BY_ENTITY_ALIAS = "dlFileVersion.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No DLFileVersion exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No DLFileVersion exists with the key {";
    private static Log _log = LogFactoryUtil.getLog(DLFileVersionPersistenceImpl.class);

    public void cacheResult(DLFileVersion dlFileVersion) {
        EntityCacheUtil.putResult((boolean)DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionImpl.class, (Serializable)Long.valueOf(dlFileVersion.getPrimaryKey()), (Object)dlFileVersion);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_G_F_N_V, (Object[])new Object[]{new Long(dlFileVersion.getGroupId()), new Long(dlFileVersion.getFolderId()), dlFileVersion.getName(), dlFileVersion.getVersion()}, (Object)dlFileVersion);
    }

    public void cacheResult(List<DLFileVersion> dlFileVersions) {
        for (DLFileVersion dlFileVersion : dlFileVersions) {
            if (EntityCacheUtil.getResult((boolean)DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionImpl.class, (Serializable)Long.valueOf(dlFileVersion.getPrimaryKey()), (SessionFactory)this) != null) continue;
            this.cacheResult(dlFileVersion);
        }
    }

    public void clearCache() {
        CacheRegistryUtil.clear((String)DLFileVersionImpl.class.getName());
        EntityCacheUtil.clearCache((String)DLFileVersionImpl.class.getName());
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
    }

    public void clearCache(DLFileVersion dlFileVersion) {
        EntityCacheUtil.removeResult((boolean)DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionImpl.class, (Serializable)Long.valueOf(dlFileVersion.getPrimaryKey()));
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_G_F_N_V, (Object[])new Object[]{new Long(dlFileVersion.getGroupId()), new Long(dlFileVersion.getFolderId()), dlFileVersion.getName(), dlFileVersion.getVersion()});
    }

    public DLFileVersion create(long fileVersionId) {
        DLFileVersionImpl dlFileVersion = new DLFileVersionImpl();
        dlFileVersion.setNew(true);
        dlFileVersion.setPrimaryKey(fileVersionId);
        return dlFileVersion;
    }

    public DLFileVersion remove(Serializable primaryKey) throws NoSuchModelException, SystemException {
        return this.remove((Long)primaryKey);
    }

    public DLFileVersion remove(long fileVersionId) throws NoSuchFileVersionException, SystemException {
        Session session = null;
        try {
            session = this.openSession();
            DLFileVersion dlFileVersion = (DLFileVersion)session.get(DLFileVersionImpl.class, (Serializable)new Long(fileVersionId));
            if (dlFileVersion == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + fileVersionId));
                }
                throw new NoSuchFileVersionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + fileVersionId);
            }
            DLFileVersion dLFileVersion = (DLFileVersion)this.remove((BaseModel)dlFileVersion);
            return dLFileVersion;
        }
        catch (NoSuchFileVersionException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DLFileVersion removeImpl(DLFileVersion dlFileVersion) throws SystemException {
        dlFileVersion = this.toUnwrappedModel(dlFileVersion);
        Session session = null;
        try {
            try {
                session = this.openSession();
                BatchSessionUtil.delete((Session)session, (BaseModel)dlFileVersion);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
        DLFileVersionModelImpl dlFileVersionModelImpl = (DLFileVersionModelImpl)dlFileVersion;
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_G_F_N_V, (Object[])new Object[]{new Long(dlFileVersionModelImpl.getGroupId()), new Long(dlFileVersionModelImpl.getFolderId()), dlFileVersionModelImpl.getName(), dlFileVersionModelImpl.getVersion()});
        EntityCacheUtil.removeResult((boolean)DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionImpl.class, (Serializable)Long.valueOf(dlFileVersion.getPrimaryKey()));
        return dlFileVersion;
    }

    public DLFileVersion updateImpl(DLFileVersion dlFileVersion, boolean merge) throws SystemException {
        dlFileVersion = this.toUnwrappedModel(dlFileVersion);
        boolean isNew = dlFileVersion.isNew();
        DLFileVersionModelImpl dlFileVersionModelImpl = (DLFileVersionModelImpl)dlFileVersion;
        Session session = null;
        try {
            try {
                session = this.openSession();
                BatchSessionUtil.update((Session)session, (BaseModel)dlFileVersion, (boolean)merge);
                dlFileVersion.setNew(false);
            }
            catch (Exception e) {
                throw this.processException(e);
            }
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
        EntityCacheUtil.putResult((boolean)DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionImpl.class, (Serializable)Long.valueOf(dlFileVersion.getPrimaryKey()), (Object)dlFileVersion);
        if (!(isNew || dlFileVersion.getGroupId() == dlFileVersionModelImpl.getOriginalGroupId() && dlFileVersion.getFolderId() == dlFileVersionModelImpl.getOriginalFolderId() && Validator.equals((Object)dlFileVersion.getName(), (Object)dlFileVersionModelImpl.getOriginalName()) && Validator.equals((Object)dlFileVersion.getVersion(), (Object)dlFileVersionModelImpl.getOriginalVersion()))) {
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_G_F_N_V, (Object[])new Object[]{new Long(dlFileVersionModelImpl.getOriginalGroupId()), new Long(dlFileVersionModelImpl.getOriginalFolderId()), dlFileVersionModelImpl.getOriginalName(), dlFileVersionModelImpl.getOriginalVersion()});
        }
        if (isNew || dlFileVersion.getGroupId() != dlFileVersionModelImpl.getOriginalGroupId() || dlFileVersion.getFolderId() != dlFileVersionModelImpl.getOriginalFolderId() || !Validator.equals((Object)dlFileVersion.getName(), (Object)dlFileVersionModelImpl.getOriginalName()) || !Validator.equals((Object)dlFileVersion.getVersion(), (Object)dlFileVersionModelImpl.getOriginalVersion())) {
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_G_F_N_V, (Object[])new Object[]{new Long(dlFileVersion.getGroupId()), new Long(dlFileVersion.getFolderId()), dlFileVersion.getName(), dlFileVersion.getVersion()}, (Object)dlFileVersion);
        }
        return dlFileVersion;
    }

    protected DLFileVersion toUnwrappedModel(DLFileVersion dlFileVersion) {
        if (dlFileVersion instanceof DLFileVersionImpl) {
            return dlFileVersion;
        }
        DLFileVersionImpl dlFileVersionImpl = new DLFileVersionImpl();
        dlFileVersionImpl.setNew(dlFileVersion.isNew());
        dlFileVersionImpl.setPrimaryKey(dlFileVersion.getPrimaryKey());
        dlFileVersionImpl.setFileVersionId(dlFileVersion.getFileVersionId());
        dlFileVersionImpl.setGroupId(dlFileVersion.getGroupId());
        dlFileVersionImpl.setCompanyId(dlFileVersion.getCompanyId());
        dlFileVersionImpl.setUserId(dlFileVersion.getUserId());
        dlFileVersionImpl.setUserName(dlFileVersion.getUserName());
        dlFileVersionImpl.setCreateDate(dlFileVersion.getCreateDate());
        dlFileVersionImpl.setFolderId(dlFileVersion.getFolderId());
        dlFileVersionImpl.setName(dlFileVersion.getName());
        dlFileVersionImpl.setExtension(dlFileVersion.getExtension());
        dlFileVersionImpl.setTitle(dlFileVersion.getTitle());
        dlFileVersionImpl.setDescription(dlFileVersion.getDescription());
        dlFileVersionImpl.setChangeLog(dlFileVersion.getChangeLog());
        dlFileVersionImpl.setExtraSettings(dlFileVersion.getExtraSettings());
        dlFileVersionImpl.setVersion(dlFileVersion.getVersion());
        dlFileVersionImpl.setSize(dlFileVersion.getSize());
        dlFileVersionImpl.setStatus(dlFileVersion.getStatus());
        dlFileVersionImpl.setStatusByUserId(dlFileVersion.getStatusByUserId());
        dlFileVersionImpl.setStatusByUserName(dlFileVersion.getStatusByUserName());
        dlFileVersionImpl.setStatusDate(dlFileVersion.getStatusDate());
        return dlFileVersionImpl;
    }

    public DLFileVersion findByPrimaryKey(Serializable primaryKey) throws NoSuchModelException, SystemException {
        return this.findByPrimaryKey((Long)primaryKey);
    }

    public DLFileVersion findByPrimaryKey(long fileVersionId) throws NoSuchFileVersionException, SystemException {
        DLFileVersion dlFileVersion = this.fetchByPrimaryKey(fileVersionId);
        if (dlFileVersion == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + fileVersionId));
            }
            throw new NoSuchFileVersionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + fileVersionId);
        }
        return dlFileVersion;
    }

    public DLFileVersion fetchByPrimaryKey(Serializable primaryKey) throws SystemException {
        return this.fetchByPrimaryKey((Long)primaryKey);
    }

    public DLFileVersion fetchByPrimaryKey(long fileVersionId) throws SystemException {
        DLFileVersion dlFileVersion = (DLFileVersion)EntityCacheUtil.getResult((boolean)DLFileVersionModelImpl.ENTITY_CACHE_ENABLED, DLFileVersionImpl.class, (Serializable)Long.valueOf(fileVersionId), (SessionFactory)this);
        if (dlFileVersion == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    dlFileVersion = (DLFileVersion)session.get(DLFileVersionImpl.class, (Serializable)new Long(fileVersionId));
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (dlFileVersion != null) {
                    this.cacheResult(dlFileVersion);
                }
                this.closeSession(session);
            }
        }
        return dlFileVersion;
    }

    public List<DLFileVersion> findByG_F_N(long groupId, long folderId, String name) throws SystemException {
        return this.findByG_F_N(groupId, folderId, name, -1, -1, null);
    }

    public List<DLFileVersion> findByG_F_N(long groupId, long folderId, String name, int start, int end) throws SystemException {
        return this.findByG_F_N(groupId, folderId, name, start, end, null);
    }

    public List<DLFileVersion> findByG_F_N(long groupId, long folderId, String name, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        Object[] finderArgs = new Object[]{groupId, folderId, name, String.valueOf(start), String.valueOf(end), String.valueOf(orderByComparator)};
        List list = (List)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_G_F_N, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
            query.append(_SQL_SELECT_DLFILEVERSION_WHERE);
            query.append("dlFileVersion.groupId = ? AND ");
            query.append("dlFileVersion.folderId = ? AND ");
            if (name == null) {
                query.append(_FINDER_COLUMN_G_F_N_NAME_1);
            } else if (name.equals("")) {
                query.append(_FINDER_COLUMN_G_F_N_NAME_3);
            } else {
                query.append(_FINDER_COLUMN_G_F_N_NAME_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY dlFileVersion.folderId DESC, dlFileVersion.name DESC, dlFileVersion.createDate DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(groupId);
                    qPos.add(folderId);
                    if (name != null) {
                        qPos.add(name);
                    }
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (list == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FIND_BY_G_F_N, (Object[])finderArgs);
                } else {
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_G_F_N, (Object[])finderArgs, (Object)list);
                }
                this.closeSession(session);
            }
        }
        return list;
    }

    public DLFileVersion findByG_F_N_First(long groupId, long folderId, String name, OrderByComparator orderByComparator) throws NoSuchFileVersionException, SystemException {
        List<DLFileVersion> list = this.findByG_F_N(groupId, folderId, name, 0, 1, orderByComparator);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(8);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", folderId=");
            msg.append(folderId);
            msg.append(", name=");
            msg.append(name);
            msg.append("}");
            throw new NoSuchFileVersionException(msg.toString());
        }
        return list.get(0);
    }

    public DLFileVersion findByG_F_N_Last(long groupId, long folderId, String name, OrderByComparator orderByComparator) throws NoSuchFileVersionException, SystemException {
        int count = this.countByG_F_N(groupId, folderId, name);
        List<DLFileVersion> list = this.findByG_F_N(groupId, folderId, name, count - 1, count, orderByComparator);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(8);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", folderId=");
            msg.append(folderId);
            msg.append(", name=");
            msg.append(name);
            msg.append("}");
            throw new NoSuchFileVersionException(msg.toString());
        }
        return list.get(0);
    }

    public DLFileVersion[] findByG_F_N_PrevAndNext(long fileVersionId, long groupId, long folderId, String name, OrderByComparator orderByComparator) throws NoSuchFileVersionException, SystemException {
        DLFileVersion dlFileVersion = this.findByPrimaryKey(fileVersionId);
        Session session = null;
        try {
            session = this.openSession();
            DLFileVersion[] array = new DLFileVersionImpl[]{this.getByG_F_N_PrevAndNext(session, dlFileVersion, groupId, folderId, name, orderByComparator, true), dlFileVersion, this.getByG_F_N_PrevAndNext(session, dlFileVersion, groupId, folderId, name, orderByComparator, false)};
            DLFileVersion[] dLFileVersionArray = array;
            return dLFileVersionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DLFileVersion getByG_F_N_PrevAndNext(Session session, DLFileVersion dlFileVersion, long groupId, long folderId, String name, OrderByComparator orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 6) : new StringBundler(3);
        query.append(_SQL_SELECT_DLFILEVERSION_WHERE);
        query.append("dlFileVersion.groupId = ? AND ");
        query.append("dlFileVersion.folderId = ? AND ");
        if (name == null) {
            query.append(_FINDER_COLUMN_G_F_N_NAME_1);
        } else if (name.equals("")) {
            query.append(_FINDER_COLUMN_G_F_N_NAME_3);
        } else {
            query.append(_FINDER_COLUMN_G_F_N_NAME_2);
        }
        if (orderByComparator != null) {
            String[] orderByFields = orderByComparator.getOrderByFields();
            if (orderByFields.length > 0) {
                query.append(" AND ");
            }
            int i = 0;
            while (i < orderByFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                    } else {
                        query.append(" <= ? AND ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                } else {
                    query.append(" <= ? ");
                }
                ++i;
            }
            query.append(" ORDER BY ");
            i = 0;
            while (i < orderByFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                    } else {
                        query.append(" DESC, ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                } else {
                    query.append(" DESC");
                }
                ++i;
            }
        } else {
            query.append(" ORDER BY dlFileVersion.folderId DESC, dlFileVersion.name DESC, dlFileVersion.createDate DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(groupId);
        qPos.add(folderId);
        if (name != null) {
            qPos.add(name);
        }
        if (orderByComparator != null) {
            Object[] values;
            Object[] objectArray = values = orderByComparator.getOrderByValues((Object)dlFileVersion);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                qPos.add(value);
                ++n2;
            }
        }
        if ((list = q.list()).size() == 2) {
            return (DLFileVersion)list.get(1);
        }
        return null;
    }

    public DLFileVersion findByG_F_N_V(long groupId, long folderId, String name, String version) throws NoSuchFileVersionException, SystemException {
        DLFileVersion dlFileVersion = this.fetchByG_F_N_V(groupId, folderId, name, version);
        if (dlFileVersion == null) {
            StringBundler msg = new StringBundler(10);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", folderId=");
            msg.append(folderId);
            msg.append(", name=");
            msg.append(name);
            msg.append(", version=");
            msg.append(version);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchFileVersionException(msg.toString());
        }
        return dlFileVersion;
    }

    public DLFileVersion fetchByG_F_N_V(long groupId, long folderId, String name, String version) throws SystemException {
        return this.fetchByG_F_N_V(groupId, folderId, name, version, true);
    }

    public DLFileVersion fetchByG_F_N_V(long groupId, long folderId, String name, String version, boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[]{groupId, folderId, name, version};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_G_F_N_V, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result == null) {
            StringBundler query = new StringBundler(6);
            query.append(_SQL_SELECT_DLFILEVERSION_WHERE);
            query.append("dlFileVersion.groupId = ? AND ");
            query.append("dlFileVersion.folderId = ? AND ");
            if (name == null) {
                query.append("dlFileVersion.name IS NULL AND ");
            } else if (name.equals("")) {
                query.append("(dlFileVersion.name IS NULL OR dlFileVersion.name = ?) AND ");
            } else {
                query.append("dlFileVersion.name = ? AND ");
            }
            if (version == null) {
                query.append(_FINDER_COLUMN_G_F_N_V_VERSION_1);
            } else if (version.equals("")) {
                query.append(_FINDER_COLUMN_G_F_N_V_VERSION_3);
            } else {
                query.append(_FINDER_COLUMN_G_F_N_V_VERSION_2);
            }
            query.append(" ORDER BY dlFileVersion.folderId DESC, dlFileVersion.name DESC, dlFileVersion.createDate DESC");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                qPos.add(folderId);
                if (name != null) {
                    qPos.add(name);
                }
                if (version != null) {
                    qPos.add(version);
                }
                List list = q.list();
                result = list;
                DLFileVersion dlFileVersion = null;
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_G_F_N_V, (Object[])finderArgs, (Object)list);
                } else {
                    dlFileVersion = (DLFileVersion)list.get(0);
                    this.cacheResult(dlFileVersion);
                    if (dlFileVersion.getGroupId() != groupId || dlFileVersion.getFolderId() != folderId || dlFileVersion.getName() == null || !dlFileVersion.getName().equals(name) || dlFileVersion.getVersion() == null || !dlFileVersion.getVersion().equals(version)) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_G_F_N_V, (Object[])finderArgs, (Object)dlFileVersion);
                    }
                }
                DLFileVersion dLFileVersion = dlFileVersion;
                return dLFileVersion;
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (result == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_G_F_N_V, (Object[])finderArgs);
                }
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (DLFileVersion)result;
    }

    public List<DLFileVersion> findByG_F_N_S(long groupId, long folderId, String name, int status) throws SystemException {
        return this.findByG_F_N_S(groupId, folderId, name, status, -1, -1, null);
    }

    public List<DLFileVersion> findByG_F_N_S(long groupId, long folderId, String name, int status, int start, int end) throws SystemException {
        return this.findByG_F_N_S(groupId, folderId, name, status, start, end, null);
    }

    public List<DLFileVersion> findByG_F_N_S(long groupId, long folderId, String name, int status, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        Object[] finderArgs = new Object[]{groupId, folderId, name, status, String.valueOf(start), String.valueOf(end), String.valueOf(orderByComparator)};
        List list = (List)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_G_F_N_S, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(6);
            query.append(_SQL_SELECT_DLFILEVERSION_WHERE);
            query.append("dlFileVersion.groupId = ? AND ");
            query.append("dlFileVersion.folderId = ? AND ");
            if (name == null) {
                query.append("dlFileVersion.name IS NULL AND ");
            } else if (name.equals("")) {
                query.append("(dlFileVersion.name IS NULL OR dlFileVersion.name = ?) AND ");
            } else {
                query.append("dlFileVersion.name = ? AND ");
            }
            query.append(_FINDER_COLUMN_G_F_N_S_STATUS_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY dlFileVersion.folderId DESC, dlFileVersion.name DESC, dlFileVersion.createDate DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(groupId);
                    qPos.add(folderId);
                    if (name != null) {
                        qPos.add(name);
                    }
                    qPos.add(status);
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (list == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FIND_BY_G_F_N_S, (Object[])finderArgs);
                } else {
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_G_F_N_S, (Object[])finderArgs, (Object)list);
                }
                this.closeSession(session);
            }
        }
        return list;
    }

    public DLFileVersion findByG_F_N_S_First(long groupId, long folderId, String name, int status, OrderByComparator orderByComparator) throws NoSuchFileVersionException, SystemException {
        List<DLFileVersion> list = this.findByG_F_N_S(groupId, folderId, name, status, 0, 1, orderByComparator);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(10);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", folderId=");
            msg.append(folderId);
            msg.append(", name=");
            msg.append(name);
            msg.append(", status=");
            msg.append(status);
            msg.append("}");
            throw new NoSuchFileVersionException(msg.toString());
        }
        return list.get(0);
    }

    public DLFileVersion findByG_F_N_S_Last(long groupId, long folderId, String name, int status, OrderByComparator orderByComparator) throws NoSuchFileVersionException, SystemException {
        int count = this.countByG_F_N_S(groupId, folderId, name, status);
        List<DLFileVersion> list = this.findByG_F_N_S(groupId, folderId, name, status, count - 1, count, orderByComparator);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(10);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", folderId=");
            msg.append(folderId);
            msg.append(", name=");
            msg.append(name);
            msg.append(", status=");
            msg.append(status);
            msg.append("}");
            throw new NoSuchFileVersionException(msg.toString());
        }
        return list.get(0);
    }

    public DLFileVersion[] findByG_F_N_S_PrevAndNext(long fileVersionId, long groupId, long folderId, String name, int status, OrderByComparator orderByComparator) throws NoSuchFileVersionException, SystemException {
        DLFileVersion dlFileVersion = this.findByPrimaryKey(fileVersionId);
        Session session = null;
        try {
            session = this.openSession();
            DLFileVersion[] array = new DLFileVersionImpl[]{this.getByG_F_N_S_PrevAndNext(session, dlFileVersion, groupId, folderId, name, status, orderByComparator, true), dlFileVersion, this.getByG_F_N_S_PrevAndNext(session, dlFileVersion, groupId, folderId, name, status, orderByComparator, false)};
            DLFileVersion[] dLFileVersionArray = array;
            return dLFileVersionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DLFileVersion getByG_F_N_S_PrevAndNext(Session session, DLFileVersion dlFileVersion, long groupId, long folderId, String name, int status, OrderByComparator orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 6) : new StringBundler(3);
        query.append(_SQL_SELECT_DLFILEVERSION_WHERE);
        query.append("dlFileVersion.groupId = ? AND ");
        query.append("dlFileVersion.folderId = ? AND ");
        if (name == null) {
            query.append("dlFileVersion.name IS NULL AND ");
        } else if (name.equals("")) {
            query.append("(dlFileVersion.name IS NULL OR dlFileVersion.name = ?) AND ");
        } else {
            query.append("dlFileVersion.name = ? AND ");
        }
        query.append(_FINDER_COLUMN_G_F_N_S_STATUS_2);
        if (orderByComparator != null) {
            String[] orderByFields = orderByComparator.getOrderByFields();
            if (orderByFields.length > 0) {
                query.append(" AND ");
            }
            int i = 0;
            while (i < orderByFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                    } else {
                        query.append(" <= ? AND ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                } else {
                    query.append(" <= ? ");
                }
                ++i;
            }
            query.append(" ORDER BY ");
            i = 0;
            while (i < orderByFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                    } else {
                        query.append(" DESC, ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                } else {
                    query.append(" DESC");
                }
                ++i;
            }
        } else {
            query.append(" ORDER BY dlFileVersion.folderId DESC, dlFileVersion.name DESC, dlFileVersion.createDate DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(groupId);
        qPos.add(folderId);
        if (name != null) {
            qPos.add(name);
        }
        qPos.add(status);
        if (orderByComparator != null) {
            Object[] values;
            Object[] objectArray = values = orderByComparator.getOrderByValues((Object)dlFileVersion);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                qPos.add(value);
                ++n2;
            }
        }
        if ((list = q.list()).size() == 2) {
            return (DLFileVersion)list.get(1);
        }
        return null;
    }

    public List<DLFileVersion> findAll() throws SystemException {
        return this.findAll(-1, -1, null);
    }

    public List<DLFileVersion> findAll(int start, int end) throws SystemException {
        return this.findAll(start, end, null);
    }

    public List<DLFileVersion> findAll(int start, int end, OrderByComparator orderByComparator) throws SystemException {
        Object[] finderArgs = new Object[]{String.valueOf(start), String.valueOf(end), String.valueOf(orderByComparator)};
        List list = (List)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 3);
                query.append(_SQL_SELECT_DLFILEVERSION);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_DLFILEVERSION.concat(" ORDER BY dlFileVersion.folderId DESC, dlFileVersion.name DESC, dlFileVersion.createDate DESC");
            }
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    if (orderByComparator == null) {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                        Collections.sort(list);
                    } else {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                    }
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (list == null) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs);
                } else {
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, (Object)list);
                }
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeByG_F_N(long groupId, long folderId, String name) throws SystemException {
        for (DLFileVersion dlFileVersion : this.findByG_F_N(groupId, folderId, name)) {
            this.remove((BaseModel)dlFileVersion);
        }
    }

    public void removeByG_F_N_V(long groupId, long folderId, String name, String version) throws NoSuchFileVersionException, SystemException {
        DLFileVersion dlFileVersion = this.findByG_F_N_V(groupId, folderId, name, version);
        this.remove((BaseModel)dlFileVersion);
    }

    public void removeByG_F_N_S(long groupId, long folderId, String name, int status) throws SystemException {
        for (DLFileVersion dlFileVersion : this.findByG_F_N_S(groupId, folderId, name, status)) {
            this.remove((BaseModel)dlFileVersion);
        }
    }

    public void removeAll() throws SystemException {
        for (DLFileVersion dlFileVersion : this.findAll()) {
            this.remove((BaseModel)dlFileVersion);
        }
    }

    public int countByG_F_N(long groupId, long folderId, String name) throws SystemException {
        Object[] finderArgs = new Object[]{groupId, folderId, name};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_G_F_N, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_COUNT_DLFILEVERSION_WHERE);
            query.append("dlFileVersion.groupId = ? AND ");
            query.append("dlFileVersion.folderId = ? AND ");
            if (name == null) {
                query.append(_FINDER_COLUMN_G_F_N_NAME_1);
            } else if (name.equals("")) {
                query.append(_FINDER_COLUMN_G_F_N_NAME_3);
            } else {
                query.append(_FINDER_COLUMN_G_F_N_NAME_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(groupId);
                    qPos.add(folderId);
                    if (name != null) {
                        qPos.add(name);
                    }
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_G_F_N, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByG_F_N_V(long groupId, long folderId, String name, String version) throws SystemException {
        Object[] finderArgs = new Object[]{groupId, folderId, name, version};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_G_F_N_V, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(5);
            query.append(_SQL_COUNT_DLFILEVERSION_WHERE);
            query.append("dlFileVersion.groupId = ? AND ");
            query.append("dlFileVersion.folderId = ? AND ");
            if (name == null) {
                query.append("dlFileVersion.name IS NULL AND ");
            } else if (name.equals("")) {
                query.append("(dlFileVersion.name IS NULL OR dlFileVersion.name = ?) AND ");
            } else {
                query.append("dlFileVersion.name = ? AND ");
            }
            if (version == null) {
                query.append(_FINDER_COLUMN_G_F_N_V_VERSION_1);
            } else if (version.equals("")) {
                query.append(_FINDER_COLUMN_G_F_N_V_VERSION_3);
            } else {
                query.append(_FINDER_COLUMN_G_F_N_V_VERSION_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(groupId);
                    qPos.add(folderId);
                    if (name != null) {
                        qPos.add(name);
                    }
                    if (version != null) {
                        qPos.add(version);
                    }
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_G_F_N_V, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByG_F_N_S(long groupId, long folderId, String name, int status) throws SystemException {
        Object[] finderArgs = new Object[]{groupId, folderId, name, status};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_G_F_N_S, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(5);
            query.append(_SQL_COUNT_DLFILEVERSION_WHERE);
            query.append("dlFileVersion.groupId = ? AND ");
            query.append("dlFileVersion.folderId = ? AND ");
            if (name == null) {
                query.append("dlFileVersion.name IS NULL AND ");
            } else if (name.equals("")) {
                query.append("(dlFileVersion.name IS NULL OR dlFileVersion.name = ?) AND ");
            } else {
                query.append("dlFileVersion.name = ? AND ");
            }
            query.append(_FINDER_COLUMN_G_F_N_S_STATUS_2);
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(groupId);
                    qPos.add(folderId);
                    if (name != null) {
                        qPos.add(name);
                    }
                    qPos.add(status);
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_G_F_N_S, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countAll() throws SystemException {
        Object[] finderArgs = new Object[0];
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(_SQL_COUNT_DLFILEVERSION);
                    count = (Long)q.uniqueResult();
                }
                catch (Exception e) {
                    throw this.processException(e);
                }
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("value.object.listener.com.liferay.portlet.documentlibrary.model.DLFileVersion")));
        if (listenerClassNames.length > 0) {
            try {
                ArrayList<ModelListener> listenersList = new ArrayList<ModelListener>();
                String[] stringArray = listenerClassNames;
                int n = listenerClassNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String listenerClassName = stringArray[n2];
                    listenersList.add((ModelListener)InstanceFactory.newInstance((String)listenerClassName));
                    ++n2;
                }
                this.listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache((String)DLFileVersionImpl.class.getName());
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_LIST);
    }
}

