/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.persistence;

import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryImpl;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileEntryFinder;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFileEntryFinderImpl
extends BasePersistenceImpl<DLFileEntry>
implements DLFileEntryFinder {
    public static String COUNT_BY_G_F_S = String.valueOf(DLFileEntryFinder.class.getName()) + ".countByG_F_S";
    public static String FIND_BY_NO_ASSETS = String.valueOf(DLFileEntryFinder.class.getName()) + ".findByNoAssets";

    public int countByG_F_S(long groupId, List<Long> folderIds, int status) throws SystemException {
        return this.doCountByG_F_S(groupId, folderIds, status, false);
    }

    public int filterCountByG_F_S(long groupId, List<Long> folderIds, int status) throws SystemException {
        return this.doCountByG_F_S(groupId, folderIds, status, true);
    }

    public List<DLFileEntry> findByNoAssets() throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_ASSETS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("DLFileEntry", DLFileEntryImpl.class);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountByG_F_S(long groupId, List<Long> folderIds, int status, boolean inlineSQLHelper) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_G_F_S);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)DLFileEntry.class.getName(), (String)"DLFileEntry.fileEntryId", (String)"DLFileEntry.userId", (long)groupId);
            }
            sql = StringUtil.replace((String)sql, (String)"[$FOLDER_ID$]", (String)this.getFolderIds(folderIds));
            if (status == -1) {
                sql = StringUtil.replace((String)sql, (String)"(DLFileVersion.status = ?) AND", (String)"");
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            if (status != -1) {
                qPos.add(status);
            }
            int i = 0;
            while (i < folderIds.size()) {
                Long folderId = folderIds.get(i);
                qPos.add(folderId);
                ++i;
            }
            Iterator itr = q.list().iterator();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getFolderIds(List<Long> folderIds) {
        if (folderIds.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(folderIds.size() * 2 - 1);
        int i = 0;
        while (i < folderIds.size()) {
            sb.append("DLFileEntry.folderId = ? ");
            if (i + 1 != folderIds.size()) {
                sb.append("OR ");
            }
            ++i;
        }
        return sb.toString();
    }
}

