/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portlet.documentlibrary.NoSuchFileVersionException;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.service.base.DLFileVersionLocalServiceBaseImpl;
import com.liferay.portlet.documentlibrary.util.comparator.FileVersionVersionComparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFileVersionLocalServiceImpl
extends DLFileVersionLocalServiceBaseImpl {
    public DLFileVersion getFileVersion(long fileVersionId) throws PortalException, SystemException {
        return this.dlFileVersionPersistence.findByPrimaryKey(fileVersionId);
    }

    public DLFileVersion getFileVersion(long groupId, long folderId, String name, String version) throws PortalException, SystemException {
        return this.dlFileVersionPersistence.findByG_F_N_V(groupId, folderId, name, version);
    }

    public List<DLFileVersion> getFileVersions(long groupId, long folderId, String name, int status) throws SystemException {
        if (status == -1) {
            return this.dlFileVersionPersistence.findByG_F_N(groupId, folderId, name);
        }
        return this.dlFileVersionPersistence.findByG_F_N_S(groupId, folderId, name, status);
    }

    public DLFileVersion getLatestFileVersion(long groupId, long folderId, String name) throws PortalException, SystemException {
        List fileVersions = this.dlFileVersionPersistence.findByG_F_N(groupId, folderId, name, 0, 1, (OrderByComparator)new FileVersionVersionComparator());
        if (fileVersions.isEmpty()) {
            throw new NoSuchFileVersionException();
        }
        return (DLFileVersion)fileVersions.get(0);
    }

    public DLFileVersion updateDescription(long fileVersionId, String description) throws PortalException, SystemException {
        DLFileVersion fileVersion = this.dlFileVersionPersistence.findByPrimaryKey(fileVersionId);
        fileVersion.setDescription(description);
        this.dlFileVersionPersistence.update((BaseModel)fileVersion, false);
        return fileVersion;
    }
}

