/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.base.DLFileShortcutLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

public class DLFileShortcutLocalServiceImpl
extends DLFileShortcutLocalServiceBaseImpl {
    public DLFileShortcut addFileShortcut(long userId, long groupId, long folderId, long toFolderId, String toName, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        folderId = this.getFolderId(user.getCompanyId(), folderId);
        Date now = new Date();
        this.validate(user, groupId, toFolderId, toName);
        long fileShortcutId = this.counterLocalService.increment();
        DLFileShortcut fileShortcut = this.dlFileShortcutPersistence.create(fileShortcutId);
        fileShortcut.setUuid(serviceContext.getUuid());
        fileShortcut.setGroupId(groupId);
        fileShortcut.setCompanyId(user.getCompanyId());
        fileShortcut.setUserId(user.getUserId());
        fileShortcut.setUserName(user.getFullName());
        fileShortcut.setCreateDate(serviceContext.getCreateDate(now));
        fileShortcut.setModifiedDate(serviceContext.getModifiedDate(now));
        fileShortcut.setFolderId(folderId);
        fileShortcut.setToFolderId(toFolderId);
        fileShortcut.setToName(toName);
        fileShortcut.setStatus(0);
        fileShortcut.setStatusByUserId(userId);
        fileShortcut.setStatusByUserName(user.getFullName());
        fileShortcut.setStatusDate(now);
        this.dlFileShortcutPersistence.update((BaseModel)fileShortcut, false);
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addFileShortcutResources(fileShortcut, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addFileShortcutResources(fileShortcut, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        if (folderId != 0L) {
            DLFolder folder = this.dlFolderPersistence.findByPrimaryKey(folderId);
            folder.setLastPostDate(fileShortcut.getModifiedDate());
            this.dlFolderPersistence.update((BaseModel)folder, false);
        }
        DLFileEntry fileEntry = this.dlFileEntryLocalService.getFileEntry(groupId, toFolderId, toName);
        this.copyAssetTags(fileEntry, serviceContext);
        this.updateAsset(userId, fileShortcut, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        return fileShortcut;
    }

    public void addFileShortcutResources(DLFileShortcut fileShortcut, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(fileShortcut.getCompanyId(), fileShortcut.getGroupId(), fileShortcut.getUserId(), DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addFileShortcutResources(DLFileShortcut fileShortcut, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(fileShortcut.getCompanyId(), fileShortcut.getGroupId(), fileShortcut.getUserId(), DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId(), communityPermissions, guestPermissions);
    }

    public void addFileShortcutResources(long fileShortcutId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        DLFileShortcut fileShortcut = this.dlFileShortcutPersistence.findByPrimaryKey(fileShortcutId);
        this.addFileShortcutResources(fileShortcut, addCommunityPermissions, addGuestPermissions);
    }

    public void addFileShortcutResources(long fileShortcutId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        DLFileShortcut fileShortcut = this.dlFileShortcutPersistence.findByPrimaryKey(fileShortcutId);
        this.addFileShortcutResources(fileShortcut, communityPermissions, guestPermissions);
    }

    public void deleteFileShortcut(DLFileShortcut fileShortcut) throws PortalException, SystemException {
        this.dlFileShortcutPersistence.remove((BaseModel)fileShortcut);
        this.resourceLocalService.deleteResource(fileShortcut.getCompanyId(), DLFileShortcut.class.getName(), 4, fileShortcut.getFileShortcutId());
        this.assetEntryLocalService.deleteEntry(DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId());
    }

    public void deleteFileShortcut(long fileShortcutId) throws PortalException, SystemException {
        DLFileShortcut fileShortcut = this.dlFileShortcutLocalService.getDLFileShortcut(fileShortcutId);
        this.deleteFileShortcut(fileShortcut);
    }

    public void deleteFileShortcuts(long groupId, long toFolderId, String toName) throws PortalException, SystemException {
        List fileShortcuts = this.dlFileShortcutPersistence.findByG_TF_TN(groupId, toFolderId, toName);
        for (DLFileShortcut fileShortcut : fileShortcuts) {
            this.deleteFileShortcut(fileShortcut);
        }
    }

    public DLFileShortcut getFileShortcut(long fileShortcutId) throws PortalException, SystemException {
        return this.dlFileShortcutPersistence.findByPrimaryKey(fileShortcutId);
    }

    public void updateAsset(long userId, DLFileShortcut fileShortcut, long[] assetCategoryIds, String[] assetTagNames) throws PortalException, SystemException {
        DLFileEntry fileEntry = this.dlFileEntryLocalService.getFileEntry(fileShortcut.getGroupId(), fileShortcut.getToFolderId(), fileShortcut.getToName());
        String mimeType = MimeTypesUtil.getContentType((String)fileEntry.getTitle());
        this.assetEntryLocalService.updateEntry(userId, fileShortcut.getGroupId(), DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId(), fileShortcut.getUuid(), assetCategoryIds, assetTagNames, false, null, null, null, null, mimeType, fileEntry.getTitle(), fileEntry.getDescription(), null, null, 0, 0, null, false);
    }

    public DLFileShortcut updateFileShortcut(long userId, long fileShortcutId, long folderId, long toFolderId, String toName, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        DLFileShortcut fileShortcut = this.dlFileShortcutPersistence.findByPrimaryKey(fileShortcutId);
        this.validate(user, fileShortcut.getGroupId(), toFolderId, toName);
        fileShortcut.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        fileShortcut.setFolderId(folderId);
        fileShortcut.setToFolderId(toFolderId);
        fileShortcut.setToName(toName);
        this.dlFileShortcutPersistence.update((BaseModel)fileShortcut, false);
        if (folderId != 0L) {
            DLFolder folder = this.dlFolderPersistence.findByPrimaryKey(folderId);
            folder.setLastPostDate(fileShortcut.getModifiedDate());
            this.dlFolderPersistence.update((BaseModel)folder, false);
        }
        DLFileEntry fileEntry = this.dlFileEntryLocalService.getFileEntry(fileShortcut.getGroupId(), toFolderId, toName);
        this.copyAssetTags(fileEntry, serviceContext);
        this.updateAsset(userId, fileShortcut, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        return fileShortcut;
    }

    public void updateFileShortcuts(long groupId, long oldToFolderId, String oldToName, long newToFolderId, String newToName) throws SystemException {
        List fileShortcuts = this.dlFileShortcutPersistence.findByG_TF_TN(groupId, oldToFolderId, oldToName);
        for (DLFileShortcut fileShortcut : fileShortcuts) {
            fileShortcut.setToFolderId(newToFolderId);
            fileShortcut.setToName(newToName);
            this.dlFileShortcutPersistence.update((BaseModel)fileShortcut, false);
        }
    }

    protected void copyAssetTags(DLFileEntry fileEntry, ServiceContext serviceContext) throws PortalException, SystemException {
        String[] assetTagNames = this.assetTagLocalService.getTagNames(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
        this.assetTagLocalService.checkTags(serviceContext.getUserId(), serviceContext.getScopeGroupId(), assetTagNames);
        serviceContext.setAssetTagNames(assetTagNames);
    }

    protected long getFolderId(long companyId, long folderId) throws SystemException {
        DLFolder folder;
        if (folderId != 0L && ((folder = this.dlFolderPersistence.fetchByPrimaryKey(folderId)) == null || companyId != folder.getCompanyId())) {
            folderId = 0L;
        }
        return folderId;
    }

    protected void validate(User user, long groupId, long toFolderId, String toName) throws PortalException, SystemException {
        DLFileEntry fileEntry = this.dlFileEntryLocalService.getFileEntry(groupId, toFolderId, toName);
        if (user.getCompanyId() != fileEntry.getCompanyId()) {
            throw new NoSuchFileEntryException();
        }
    }
}

