/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.DLFileRank;
import com.liferay.portlet.documentlibrary.service.base.DLFileRankLocalServiceBaseImpl;
import com.liferay.portlet.documentlibrary.util.comparator.FileRankCreateDateComparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFileRankLocalServiceImpl
extends DLFileRankLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(DLFileRankLocalServiceImpl.class);

    public DLFileRank addFileRank(long groupId, long companyId, long userId, long folderId, String name, ServiceContext serviceContext) throws SystemException {
        DLFileRank fileRank;
        block3: {
            long fileRankId = this.counterLocalService.increment();
            fileRank = this.dlFileRankPersistence.create(fileRankId);
            fileRank.setGroupId(groupId);
            fileRank.setCompanyId(companyId);
            fileRank.setUserId(userId);
            fileRank.setCreateDate(serviceContext.getCreateDate(null));
            fileRank.setFolderId(folderId);
            fileRank.setName(name);
            try {
                this.dlFileRankPersistence.update((BaseModel)fileRank, false);
            }
            catch (SystemException se) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Add failed, fetch {companyId=" + companyId + ", userId=" + userId + ", folderId=" + folderId + ", name=" + name + "}"));
                }
                if ((fileRank = this.dlFileRankPersistence.fetchByC_U_F_N(companyId, userId, folderId, name, false)) != null) break block3;
                throw se;
            }
        }
        return fileRank;
    }

    public void deleteFileRanks(long userId) throws SystemException {
        this.dlFileRankPersistence.removeByUserId(userId);
    }

    public void deleteFileRanks(long folderId, String name) throws SystemException {
        this.dlFileRankPersistence.removeByF_N(folderId, name);
    }

    public List<DLFileRank> getFileRanks(long groupId, long userId) throws SystemException {
        return this.getFileRanks(groupId, userId, -1, -1);
    }

    public List<DLFileRank> getFileRanks(long groupId, long userId, int start, int end) throws SystemException {
        return this.dlFileRankPersistence.findByG_U(groupId, userId, start, end, (OrderByComparator)new FileRankCreateDateComparator());
    }

    public DLFileRank updateFileRank(long groupId, long companyId, long userId, long folderId, String name, ServiceContext serviceContext) throws SystemException {
        if (!PropsValues.DL_FILE_RANK_ENABLED) {
            return null;
        }
        DLFileRank fileRank = this.dlFileRankPersistence.fetchByC_U_F_N(companyId, userId, folderId, name);
        if (fileRank != null) {
            fileRank.setCreateDate(serviceContext.getCreateDate(null));
            this.dlFileRankPersistence.update((BaseModel)fileRank, false);
        } else {
            fileRank = this.addFileRank(groupId, companyId, userId, folderId, name, serviceContext);
        }
        if (this.dlFileRankPersistence.countByG_U(groupId, userId) > 5) {
            List<DLFileRank> fileRanks = this.getFileRanks(groupId, userId);
            DLFileRank lastFileRank = fileRanks.get(fileRanks.size() - 1);
            long lastFileRankId = lastFileRank.getFileRankId();
            try {
                this.dlFileRankPersistence.remove((BaseModel)lastFileRank);
            }
            catch (Exception exception) {
                _log.warn((Object)("Failed to remove file rank " + lastFileRankId + " because another thread already removed it"));
            }
        }
        return fileRank;
    }
}

