/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.communities.action;

import com.liferay.portal.NoSuchLayoutSetException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.SitemapUtil;
import com.liferay.util.servlet.ServletResponseUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class SitemapAction
extends Action {
    private static Log _log = LogFactoryUtil.getLog(SitemapAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
            long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
            boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)request, (String)"privateLayout");
            LayoutSet layoutSet = null;
            if (groupId > 0L) {
                Group group = GroupLocalServiceUtil.getGroup((long)groupId);
                if (group.isStagingGroup()) {
                    groupId = group.getLiveGroupId();
                }
                layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
            } else {
                String host = PortalUtil.getHost((HttpServletRequest)request);
                layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((String)host);
            }
            String sitemap = SitemapUtil.getSitemap(layoutSet.getGroupId(), layoutSet.isPrivateLayout(), themeDisplay);
            ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, null, (byte[])sitemap.getBytes("UTF-8"), (String)"text/xml; charset=UTF-8");
        }
        catch (NoSuchLayoutSetException nslse) {
            PortalUtil.sendError((int)404, (Exception)((Object)nslse), (HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
            PortalUtil.sendError((int)500, (Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
        }
        return null;
    }
}

