/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.communities.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.communities.action.ActionUtil;
import com.liferay.portlet.communities.action.EditPagesAction;
import com.liferay.portlet.tasks.DuplicateReviewUserIdException;
import com.liferay.portlet.tasks.NoSuchProposalException;
import com.liferay.portlet.tasks.ProposalDueDateException;
import com.liferay.portlet.tasks.ProposalPublishDateException;
import com.liferay.portlet.tasks.model.TasksProposal;
import com.liferay.portlet.tasks.service.TasksProposalLocalServiceUtil;
import com.liferay.portlet.tasks.service.TasksProposalServiceUtil;
import com.liferay.portlet.tasks.service.TasksReviewServiceUtil;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditProposalAction
extends EditPagesAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.checkPermissions((PortletRequest)actionRequest);
        }
        catch (PrincipalException principalException) {
            return;
        }
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateProposal(actionRequest, actionResponse);
            } else if (cmd.equals("approve")) {
                this.approveReview(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteProposal(actionRequest);
            } else if (cmd.equals("publish")) {
                this.publishProposal(actionRequest);
            } else if (cmd.equals("reject")) {
                this.rejectReview(actionRequest);
            }
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"pagesRedirect");
            if (Validator.isNull((String)redirect)) {
                redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            }
            this.sendRedirect(actionRequest, actionResponse, redirect);
        }
        catch (Exception e) {
            if (e instanceof NoSuchProposalException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.communities.error");
            }
            if (e instanceof DuplicateReviewUserIdException || e instanceof ProposalDueDateException || e instanceof ProposalPublishDateException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)e);
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            this.checkPermissions((PortletRequest)renderRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)renderRequest, (String)PrincipalException.class.getName());
            return mapping.findForward("portlet.communities.error");
        }
        try {
            ActionUtil.getGroup((PortletRequest)renderRequest);
            long proposalId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"proposalId");
            TasksProposal proposal = null;
            if (proposalId > 0L) {
                proposal = TasksProposalLocalServiceUtil.getProposal((long)proposalId);
            }
            renderRequest.setAttribute("TASKS_PROPOSAL", (Object)proposal);
        }
        catch (Exception e) {
            if (e instanceof NoSuchProposalException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.communities.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.communities.edit_proposal"));
    }

    protected void approveReview(ActionRequest actionRequest) throws Exception {
        long proposalId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"proposalId");
        int stage = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"stage");
        TasksReviewServiceUtil.approveReview((long)proposalId, (int)stage);
    }

    protected void deleteProposal(ActionRequest actionRequest) throws Exception {
        long proposalId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"proposalId");
        TasksProposalServiceUtil.deleteProposal((long)proposalId);
    }

    protected void publishProposal(ActionRequest actionRequest) throws Exception {
        long proposalId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"proposalId");
        TasksProposal proposal = TasksProposalLocalServiceUtil.getProposal((long)proposalId);
        String className = PortalUtil.getClassName((long)proposal.getClassNameId());
        if (className.equals(Layout.class.getName())) {
            StagingUtil.publishToLive((PortletRequest)actionRequest);
        } else if (className.equals(Portlet.class.getName())) {
            String classPK = proposal.getClassPK();
            String portletId = classPK.substring(classPK.indexOf("_LAYOUT_") + "_LAYOUT_".length());
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)proposal.getCompanyId(), (String)portletId);
            StagingUtil.publishToLive((PortletRequest)actionRequest, (Portlet)portlet);
        }
        TasksProposalServiceUtil.deleteProposal((long)proposal.getProposalId());
    }

    protected void rejectReview(ActionRequest actionRequest) throws Exception {
        long proposalId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"proposalId");
        int stage = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"stage");
        TasksReviewServiceUtil.rejectReview((long)proposalId, (int)stage);
    }

    protected void updateProposal(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long proposalId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"proposalId");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        if (proposalId <= 0L) {
            long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
            long reviewUserId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"reviewUserId");
            String className = ParamUtil.getString((PortletRequest)actionRequest, (String)"className");
            String classPK = ParamUtil.getString((PortletRequest)actionRequest, (String)"classPK");
            String name = "";
            if (className.equals(Layout.class.getName())) {
                long plid = GetterUtil.getLong((String)classPK);
                Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
                name = layout.getName(themeDisplay.getLocale());
            } else if (className.equals(Portlet.class.getName())) {
                String portletId = classPK.substring(classPK.indexOf("_LAYOUT_") + "_LAYOUT_".length());
                name = PortalUtil.getPortletTitle((String)portletId, (Locale)themeDisplay.getLocale());
            }
            boolean addCommunityPermissions = true;
            boolean addGuestPermissions = true;
            TasksProposalServiceUtil.addProposal((long)groupId, (String)className, (String)classPK, (String)name, (String)description, (long)reviewUserId, (boolean)addCommunityPermissions, (boolean)addGuestPermissions);
        } else {
            int dueDateMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"dueDateMonth");
            int dueDateDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"dueDateDay");
            int dueDateYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"dueDateYear");
            int dueDateHour = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"dueDateHour");
            int dueDateMinute = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"dueDateMinute");
            TasksProposalServiceUtil.updateProposal((long)proposalId, (String)description, (int)dueDateMonth, (int)dueDateDay, (int)dueDateYear, (int)dueDateHour, (int)dueDateMinute);
            long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            int workflowStages = group.getWorkflowStages();
            long[][] userIdsPerStage = new long[workflowStages][0];
            int i = 2;
            while (i <= workflowStages) {
                long[] userIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)("reviewUserIds_" + i)), (long)0L);
                userIdsPerStage[i - 2] = userIds;
                ++i;
            }
            TasksReviewServiceUtil.updateReviews((long)proposalId, (long[][])userIdsPerStage);
        }
    }
}

