/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.util;

import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.portlet.calendar.service.CalEventLocalServiceUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletURL;

public class CalIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{CalEvent.class.getName()};
    public static final String PORTLET_ID = "8";

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public Summary getSummary(Document document, String snippet, PortletURL portletURL) {
        String title = document.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)document.get("description"), (int)200);
        }
        String eventId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/calendar/view_event");
        portletURL.setParameter("eventId", eventId);
        return new Summary(title, content, portletURL);
    }

    protected void doDelete(Object obj) throws Exception {
        CalEvent event = (CalEvent)obj;
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, event.getEventId());
        SearchEngineUtil.deleteDocument((long)event.getCompanyId(), (String)document.get("uid"));
    }

    protected Document doGetDocument(Object obj) throws Exception {
        CalEvent event = (CalEvent)obj;
        long companyId = event.getCompanyId();
        long groupId = this.getParentGroupId(event.getGroupId());
        long scopeGroupId = event.getGroupId();
        long userId = event.getUserId();
        long eventId = event.getEventId();
        String userName = PortalUtil.getUserName((long)userId, (String)event.getUserName());
        String title = event.getTitle();
        String description = HtmlUtil.extractText((String)event.getDescription());
        Date modifiedDate = event.getModifiedDate();
        long[] assetCategoryIds = AssetCategoryLocalServiceUtil.getCategoryIds((String)CalEvent.class.getName(), (long)eventId);
        String[] assetTagNames = AssetTagLocalServiceUtil.getTagNames((String)CalEvent.class.getName(), (long)eventId);
        ExpandoBridge expandoBridge = event.getExpandoBridge();
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, eventId);
        document.addModifiedDate(modifiedDate);
        document.addKeyword("companyId", companyId);
        document.addKeyword("portletId", PORTLET_ID);
        document.addKeyword("groupId", groupId);
        document.addKeyword("scopeGroupId", scopeGroupId);
        document.addKeyword("userId", userId);
        document.addText("userName", userName);
        document.addText("title", title);
        document.addText("description", description);
        document.addKeyword("assetCategoryIds", assetCategoryIds);
        document.addKeyword("assetTagNames", assetTagNames);
        document.addKeyword("entryClassName", CalEvent.class.getName());
        document.addKeyword("entryClassPK", eventId);
        ExpandoBridgeIndexerUtil.addAttributes((Document)document, (ExpandoBridge)expandoBridge);
        return document;
    }

    protected void doReindex(Object obj) throws Exception {
        CalEvent event = (CalEvent)obj;
        Document document = this.getDocument(event);
        SearchEngineUtil.updateDocument((long)event.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        CalEvent event = CalEventLocalServiceUtil.getEvent((long)classPK);
        this.doReindex(event);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexEvents(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexEvents(long companyId) throws Exception {
        int count = CalEventLocalServiceUtil.getCompanyEventsCount((long)companyId);
        int pages = count / 1000;
        int i = 0;
        while (i <= pages) {
            int start = i * 1000;
            int end = start + 1000;
            this.reindexEvents(companyId, start, end);
            ++i;
        }
    }

    protected void reindexEvents(long companyId, int start, int end) throws Exception {
        List events = CalEventLocalServiceUtil.getCompanyEvents((long)companyId, (int)start, (int)end);
        if (events.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>();
        for (CalEvent event : events) {
            Document document = this.getDocument(event);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((long)companyId, documents);
    }
}

